import java.awt.*;
import java.math.*;

public class CutoffTest {
/*projection onto negative eigenspace*/



/*both endpoints of the edge are the same.  The
edge just serves as a useful structure for
storing two values, the coefficients of E0K and EiK.*/

  public static  Edge Pi1(IntervalComplexVector v) {
	Edge e1=new Edge();
	Edge e2=new Edge();
	Edge e3=new Edge();
        IntervalComplexVector v1=NumericalValues.E0K();
        IntervalComplexVector v2=NumericalValues.EiK();
        e1.s[1][1]=v1.a;
        e1.s[1][2]=v1.b; 
        e1.s[2][1]=v2.a;
        e1.s[2][2]=v2.b;
        e2.s[1][1]=v.a;
        e2.s[1][2]=v.b; 
        e2.s[2][1]=v.a;
        e2.s[2][2]=v.b;
        e3=EdgeIntersection.normal_position(e1,e2);
        return(e3);
    }


 public static   IntervalComplexVector Pi2(IntervalComplexVector v) {
       IntervalComplexVector x=NumericalValues.EpK();
       IntervalComplex[] z=new IntervalComplex[5];
       z[1]=IntervalComplexVector.hermitianDot(v,x);
       z[2]=IntervalComplexVector.hermitianDot(x,x);
       z[3]=IntervalComplex.divide(z[1],z[2]);
       x=IntervalComplexVector.minus(v,IntervalComplexVector.scale(z[3],x));
       return(x);
    }






public static Graph cutoff_graph(IntervalPoly P)
{
    Graph G =new Graph();
    int i,j,count;
    Edge e1=new Edge();
    Edge e2=new Edge();
    Edge e3=new Edge();
    count=1;
    for(i=1;i<=4;++i)
      {
      for(j=i+1;j<=4;++j)
         {
         e1=Pi1(Pi2(P.v[i]));
         e2=Pi1(Pi2(P.v[j]));
         e3.s[1][1]=e1.s[1][1];
         e3.s[1][2]=e1.s[1][2];
         e3.s[2][1]=e2.s[2][1];
         e3.s[2][2]=e2.s[2][2];
         G.e[count]=e3;
         ++count;
	 }
      }
G.l=6;
return(G);
}




/*an edge is a collection of 2 points in C2.  Here
  we make a graph with 6 edges*/

  public static Graph unit_circle_graph() {
     Graph G=new Graph();
     G.l=2;
     G.e[1].s[1][1]=new IntervalComplex(1.0,0.0);
     G.e[1].s[1][2]=new IntervalComplex(1.0,0.0);
     G.e[1].s[2][1]=new IntervalComplex(0.0,1.0);
     G.e[1].s[2][2]=new IntervalComplex(0.0,-1.0);
     G.e[2].s[1][1]=new IntervalComplex(1.0,0.0);
     G.e[2].s[1][2]=new IntervalComplex(1.0,0.0);
     G.e[2].s[2][1]=new IntervalComplex(0.0,-1.0);
     G.e[2].s[2][2]=new IntervalComplex(0.0,1.0);
  return(G);
  }



    public static int inside_unit_circle(IntervalPoly P) {
    IntervalComplex value=new IntervalComplex();
    Interval norm=new Interval();
    int i,j,test;
    Graph G1=cutoff_graph(P);
    Graph G2=unit_circle_graph();
    for(i=1;i<=6;++i)
       {
        for(j=1;j<=2;++j)
	  {
	  test=EdgeIntersection.generic_intersection_number(G1.e[i],G2.e[j]);
	  if(test!=0) return(0);
	  }
       }
  value=IntervalComplex.divide(G1.e[1].s[1][1],G1.e[1].s[1][2]);
  norm=IntervalComplex.norm(value);
  if(norm.r<1) return(1);
  return(0);
}




    public static int outside_unit_circle(IntervalPoly P) {
  IntervalComplex value=new IntervalComplex();
    Interval norm=new Interval();
    int i,j,test;
    Graph G1=cutoff_graph(P);
    Graph G2=unit_circle_graph();
  for(i=1;i<=6;++i)
    {
      for(j=1;j<=2;++j)
	{
	  test=EdgeIntersection.generic_intersection_number(G1.e[i],G2.e[j]);
	  if(test!=0) return(0);
	}
    }
  value=IntervalComplex.divide(G1.e[1].s[1][1],G1.e[1].s[1][2]);
  norm=IntervalComplex.norm(value);
  if(norm.l>1) return(1);
  return(0);
}

 public static   int first_good_positive_shift(IntervalPoly P) {
int i,test;
Interval val=new Interval();
IntervalPoly Q=new IntervalPoly(P);

  for(i=0;i<=6;++i)
  {
  test=outside_unit_circle(Q);
  if(test==1) return(i);
  Q=PolyhedronOperations.positive_shift(Q);
  }
  return(1000);
}

    
  
 public static   int first_good_negative_shift(IntervalPoly P) {
int i,test;
Interval val=new Interval();
IntervalPoly Q=new IntervalPoly(P);

  for(i=0;i<=6;++i)
  {
  test=inside_unit_circle(Q);
  if(test==1) return(i);
  Q=PolyhedronOperations.negative_shift(Q);
  }
  return(1000);
}

    public static int main_test(IntervalPoly P) {
       int j,test;
       int test1=first_good_positive_shift(P);
       int test2=first_good_negative_shift(P);
       if(test1>4) return 0;
       if(test2>5) return 0;
       return 1;
    }

}
