import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;


public class DebugCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    ControlPanel DEBUG;
    ListenSquare DO_DEBUG;
    String[] MESSAGE=new String[5];

     public DebugCanvas() {
	 addMouseListener(this);
	 DO_DEBUG=new ListenSquare(150,0,50,20);
	 setPanels();
     }

    public void setPanels() {
	Color[] C0={new Color(0,120,150),Color.white,
		    Color.white,Color.white,new Color(0,255,255)};

	String[] DebugString={"interval","interval complex","interval complex vector","debug"};
	int[] DebugState={1,0,0};
        DEBUG=new ControlPanel(C0,DebugString,DebugState,3);
	DEBUG.mode=0;
    }

    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(155,0,200));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }
    
    public void drawControls(Graphics2D g) {
	DEBUG.render(g,0,0,150);
	DO_DEBUG.render(g,"debug",12,2,new Color(0,170,0));
    }
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	DEBUG.switchMode(J.X);
	if(DO_DEBUG.inside(J.X)==1) Debugger.main(DEBUG.mode); //do debugger
	M.repaint();
    }
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

}


