import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is the debugger*/

public class Debugger {

    public static void main(int mode) {
	if(mode==0) debugInterval();
	if(mode==1) debugIntervalComplex();
	if(mode==2) debugIntervalComplexVector();
    }







    public static void debugInterval() {
	System.out.println("===============DEBUG INTERVALS=================");
	double x=1-2*Math.random();
	double y=1-2*Math.random();
	double z;

	Interval X=new Interval(x);
	Interval Y=new Interval(y);
	Interval Z=new Interval();

	System.out.println("-----the doubles");
	System.out.println(x);
	System.out.println(y);
	
	System.out.println("-----the intervals");
	X.print();
	Y.print();
	
	System.out.println("-----the operations");
	
	System.out.println("plus");
	z=x+y;
	Z=Interval.plus(X,Y);
	System.out.println(z);
	Z.print();
	System.out.println("traps: "+traps(z,Z));

	System.out.println("minus");
	z=x-y;
	Z=Interval.minus(X,Y);
	System.out.println(z);
	Z.print();
	System.out.println("traps: "+traps(z,Z));

	System.out.println("times");
	z=x*y;
	Z=Interval.times(X,Y);
	System.out.println(z);
	Z.print();
	System.out.println("traps: "+traps(z,Z));

	System.out.println("divide");
	z=x/y;
	Z=Interval.divide(X,Y);
	System.out.println(z);
	Z.print();
	System.out.println("traps: "+traps(z,Z));

	System.out.println("max");
	z=Math.max(x,y);
       	Z=Interval.max(X,Y);
	System.out.println(z);
	Z.print();
	System.out.println("traps: "+traps(z,Z));

	System.out.println("min");
	z=Math.min(x,y);
       	Z=Interval.min(X,Y);
	System.out.println(z);
	Z.print();
	System.out.println("traps: "+traps(z,Z));

	System.out.println("negative");
	z=-x;
       	Z=Interval.negative(X);
	System.out.println(z);
	Z.print();
	System.out.println("traps: "+traps(z,Z));

	
	System.out.println("sq_root");
	if(x<0) {
	    System.out.println("negative number: not tested");
	}
	else {
	  z=Math.sqrt(x);
       	  Z=Interval.sqrt(X);
	  System.out.println(z);
	  Z.print();
	  System.out.println("traps: "+traps(z,Z));
	}

	

	System.out.println("============================================");

    }



    public static void debugIntervalComplex() {
	System.out.println("===============DEBUG COMPLEX=================");
	double x1=1-2*Math.random();
	double y1=1-2*Math.random();
	Complex z1=new Complex(x1,y1);
	double x2=1-2*Math.random();
	double y2=1-2*Math.random();
	Complex z2=new Complex(x2,y2);
	IntervalComplex Z1=new IntervalComplex(z1);
	IntervalComplex Z2=new IntervalComplex(z2);

	System.out.println("the structures");
	z1.print();
	Z1.print();
	z2.print();
	Z2.print();

	System.out.println("basis conversion");
	boolean test=traps(z1,Z1);
	System.out.println("traps "+test);

	System.out.println("norm");
	double n=Complex.norm(z1);
	Interval N=IntervalComplex.norm(Z1);
	System.out.println(n);
	N.print();
        test=traps(n,N);
	System.out.println("traps "+test);
	
	System.out.println("unit");
	Complex u=Complex.unit(z1);
	IntervalComplex U=IntervalComplex.unit(Z1);
	u.print();
	U.print();
        test=traps(u,U);
	System.out.println("traps "+test);

	System.out.println("negative");
	u=Complex.negative(z1);
	U=IntervalComplex.negative(Z1);
	u.print();
	U.print();
        test=traps(u,U);
	System.out.println("traps "+test);

	System.out.println("dist");
	double d=Complex.dist(z1,z2);
	Interval D=IntervalComplex.dist(Z1,Z2);
        test=traps(d,D);
	System.out.println("traps "+test);

	System.out.println("plus");
	Complex w=Complex.plus(z1,z2);
	IntervalComplex W=IntervalComplex.plus(Z1,Z2);
	w.print();
	W.print();
        test=traps(w,W);
	System.out.println("traps "+test);

	System.out.println("minus");
	w=Complex.minus(z1,z2);
	W=IntervalComplex.minus(Z1,Z2);
	w.print();
	W.print();
        test=traps(w,W);
	System.out.println("traps "+test);

	System.out.println("times");
	w=Complex.times(z1,z2);
	W=IntervalComplex.times(Z1,Z2);
	w.print();
	W.print();
        test=traps(w,W);
	System.out.println("traps "+test);

	System.out.println("inverse");
	w=Complex.inverse(z1);
	W=IntervalComplex.inverse(Z1);
	w.print();
	W.print();
        test=traps(w,W);
	System.out.println("traps "+test);

	System.out.println("divide");
	w=Complex.divide(z1,z2);
	W=IntervalComplex.divide(Z1,Z2);
	w.print();
	W.print();
        test=traps(w,W);
	System.out.println("traps "+test);
	
	System.out.println("conjugate");
	u=Complex.conjugate(z1);
	U=IntervalComplex.conjugate(Z1);
	u.print();
	U.print();
        test=traps(u,U);
	System.out.println("traps "+test);

	System.out.println("============================================");
    }

    public static void debugIntervalComplexVector() {
	IntervalComplexVector V=IntervalComplexVector.random();
	IntervalComplexVector W=IntervalComplexVector.random();
	IntervalComplexVector X=IntervalComplexVector.hermitianCross(V,W);

	System.out.println("debug dot and cross");
	IntervalComplex D=IntervalComplexVector.hermitianDot(X,V);
	D.print();
	D=IntervalComplexVector.hermitianDot(X,W);
	D.print();






    }
    

    public static boolean traps(double x,Interval I) {
	if(x<I.l) return false;
	if(x>I.r) return false;
	return true;
    }
    
    public static boolean traps(Complex z,IntervalComplex Z) {
	if(traps(z.x,Z.x)==false) return false;
	if(traps(z.y,Z.y)==false) return false;
	return true;
    }




    

}




