import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void action(DocumentCanvas D) {
	String S="action mode";
	S=S+"\n\nThere are two main modes for this program.";

	S=S+"\n\nproof mode:  This runs the calculation for Lemma A135.  When you are in this mode, you can select the kind of calculations you want to make: floating point or interval.  You can also select the energy hybrid to be tested, using the blue controls.  If you click the arrow keys you can test the hybrids needed for Lemma A135.  You can also make your own energy hybrid to test.  It is a good idea to use the arrow keys, because they automatically set the tests to wha is needed for Lemma A135.  When you press GO the program is launched. you halt the program at any time by pressing STOP.  When you run the proof, the program interacts with the block window. As each block is passed, it is sent to the Block window and displayed.  If you want to see a nice animation, you should open the block window and run the program.  The code runs with or without the block window open, and takes about the same amount of time either way.";

	S=S+"\n\ndebug mode: you can run several auxiliary programs which serve as sanity checks that the program is operating correctly.  If you click the question box on the debug window you can see a description of what these do.";

	sendTo(D,S);
    }


    public static void parallel(DocumentCanvas D) {
	String S="parallel computation control";

	S=S+"\n\nWe classify the block B=Q0xQ1xQ2xQ3 into 8 types according to the signs of c0-1, c1, c3.  Here c0 is the center of Q0, etc. Our subdivision algorithm guarantees that we never have a block where one of the 3 quantities is 0.  Thus, each block has a unique classification from 0-7.";
	S=S+"\n\nWhen you click on the 8 squares in this row, you toggle the parallel branch of the program that tests the corresponding blocks. Thus, if square 3 is on, the program will test all blocks having classification 3.  If you turn on all the squares then you test everything.  I broke up the calculation this way so as to have it run faster.";
	S=S+"\n\nIt can get tedious turning these squares off and on.  The second row of 2 squares lets you turn on or off all 8 squares at once.  This makes changing the parallelization scheme faster.";

	sendTo(D,S);
    }

    public static void speed(DocumentCanvas D) {
	String S="speed";

	S=S+"\n\nThis row of boxes controls the speed of the calculation.  When you have the speed all the way to the left, the calculation runs as fast as it can.  You have the option of slowing down the calculation so that you can see what it is doing on a step by step basis.  A slow version is best appreciated when you have the blocks window open.  Then you can see each block flash on the screen as it is treated.  If you turn on the 'failures' option and run the calculation very slowly you can get a good appreciation for the subdivision operation.";

	sendTo(D,S);
    }


    

    public static void popups(DocumentCanvas D) {
	String S="popup windows";
	S=S+"\n\nThis control console lets you launch 3 auxiliary windows. One of them is the info window, which you are now reading.  The other two windows allow you to display, manipulate, and analyze blocks.";

	S=S+"\n\nWhen the program is running the proof, the Block window displays each block as it is being passed by the algorithm. So, in principle, if you could slow down the program and watch the block window you would see the entire partition of the configuration space being drawn dynamically.  The program works too fast for this, and you just get to see a nice animation.";

	S=S+"\n\nWhen the program is in the debug mode, you can use the controls on the block window to select and manipulate blocks.  Once you choose a block, the grading window will subject it to the main step of the algorithm. This lets you see how the algorithm decides whether to pass a given block.  Of course, the block you select may not actually arise during the running of the algorithm.";
	sendTo(D,S);
    }



    public static void debugmode(DocumentCanvas D) {
	String S="debugging options";

	S=S+"\n\nvector operations: This operation selects two random integer vectors and computes their dot product, their sum, etc.  You can check this against some other program, like Mathematica, to see that these basic operations are programmed correctly.";

	S=S+"\n\ninterval arithmetic: This operation checks our interval arithmetic implementation for gross errors.  Given a double d, we have an operation called fat(d), which produces the interval D=[d1,d2], where d1 is obtained by rounding d down one click and d2 is obtained by rounding d up one click.  This routine takes two doubles a and b, sets A=fat(a) and B=fat(B) and then considers the basic operations performed on A and B.  The routine checks that each operation produces an interval which traps the same floating point operation performed on a and b.  We check plus, minus, times, divide, max, min, and power.";

	S=S+"\n\npower of 2 lookup:  To save time with some calculations, we store the inverse powers of 2 up to 2^{-25}.  This routine just checks that the floating point computation (a') of such a power of 2 fits inside the interval made by taking the lookup value (a) and placing it inside the interval A=fat(a).";



	S=S+"\n\nstereographic projection:  This routine just checks that the interval version of our stereographic projection agrees (in the appropriate sense) with our floating point version.  What is nontrivial here is that the floating point version is computed from the a complex number z whereas the interval version is computed using the gaussian integer obtained by scaling z up by 2^{25}.  We only apply our operations to those z for which the corresponding g really is an integer.  The interval version works by multiplying g by 2^{-25} and then doing the formula for stereographic projection.  So, we just wanted to check that we did not make a mistake when implementing this.";

	S=S+"\n\nerror terms:  This computes all the functions which go into our Energy Theorem, and checks that the interval versions match the floating point versions in the appropriate sense.  The appropriate sense is that the floating point quantity is always trapped in the interval quantity.";

	S=S+"\n\nCheck Energy Theorem:  This option should be used in tandem with the block window.  When the block window is open, this option does two things. First, it computes the lower energy bound given by the theorem.  Second, it computes the actual energy of a million randomly chosen configurations in the block and then takes the minimum. The check is that the min-random energy is greater than the bound from the theorem.";


	sendTo(D,S);
    }

    public static void grade(DocumentCanvas D) {
	String S="grading algorithm modifier";

	S=S+"\n\nThis control panel specifies how the grading algorithm works.  There are 5 options.  When you use the blue arrow keys you set these options correctly for all the tests in Lemma A135.  However, you can also change the test options manually.   The 5th option is just for debugging purposes. It sets thing up so that reasonably small blocks are automatically passed. This should be off for the main calculations.";

	S=S+"\n\noutside \u03A9: This eliminates irrelevant blocks that we calculate to be disjoint from \u03A9 the main domain from the monograph.";

	S=S+"\n\ninside \u03A90: This eliminates blocks that we calculate to be inside the are small cubical neighborhood \u03A90 of the TBP";

	S=S+"\n\ninside \u03A5: This eliminates blocks which are inside the region \u03A5 (upsilon) described in the monograph and plotted in the picture window.  This is on for the calculation involving G_10^sharp and otherwise off.";

	S=S+"\n\noutside \u03A5: This eliminates blocks which are outside the region \u03A5 (upsilon) described in the monograph and plotted in the picture window.  This is on for the calculation involving G_10^double sharp and otherwise off.";

	sendTo(D,S);
    }

    public static void proofmode(DocumentCanvas D) {
	String S="calculation type selector";

	S=S+"\n\nYou can run the proof in 2 ways:";

	S=S+"\n\nfloating point calculations:  These calculations do not constitute a rigorous proof of the main result in the paper.  However, they are a very good indication of how the rigorous calcualations will do.";

	S=S+"\n\ninterval arithmetic:  These calculations are the ones advertised in the paper.  They take about 5 times as long to run as the floating point calculations.  You can get a rough idea of how long it takes to run them by looking at the proof monitor as the proof is running.  The interval arithmetic calculations still rely on floating point calculations in a sense.  To save time, we only apply interval arithmetic calculations to blocks which pass the grading step based on floating point calculations.  So, the actual partition is produced in a non-rigorous way but then the produced partition is rigorously certified to work.  This still constitutes a proof.";
	sendTo(D,S);
    }



    public static void monitor(DocumentCanvas D) {
	String S="proof monitor";

	S=S+"\n\nWhen you run the proof, the algorithm sends various pieces of information to this monitor, so that you can see the progress of the program:";

	S=S+"\n\ntime:  This keeps track of the total time the proof has been running.";

	S=S+"\n\nPartition size:  (This is the number in parenthesis.) Ultimately the program produces a partition of the configuration space into blocks such that each block passes the grading.  This keeps track of how many blocks of the partition have been passed.";

	S=S+"\n\nVolume: This keeps track of the percentage of the total volume of the configuration space which the program has passed.  We keep track of this as a lfloating point number, so the final answer will be quite close but perhaps not exactly 1.  The white strip fills up as the volume grows. The 8 rainbow colored strips keep track of 8 times the volume of blocks having a given characteristic.  To read more about the characteristic of a bllock, look at the question box for the parallelization squares.";

S=S+"\n\n max depth:  As the program runs, the dyadic squares and segments comprising the block are subdivided.  This number keeps track of the deepest nested subdivision.   The program would abort and declare failure if this number ever reached 25.";

S=S+"\n\nThis displays the current dimensions of the block being eliminated.  The 4 numbers s1,s2,s3,s4 indicate that  the current block has the form (Q0,Q1,Q2,Q3) where Qk has side length 2^{-sk}.  Here $Q1 is a dyadic segment and Q2,Q3,Q4 are dyadic squares.";

S=S+"\n\n list length:  The number keeps track of the number of blocks on the current list.  The number in parens keeps track of the longest that the list ahs been up to the current moment.";

	sendTo(D,S);
    }







}


