import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="Real Hyperbolic on the Outside, Complex Hyperbolic on the Inside\n\n";
        S=S+"Richard Evan Schwartz\n";
	S=S+"program started: 1 Feb 2023\n";


	S=S+"\n\nPURPOSE:\n\n";
	S=S+"This program is a companion to my paper with the above title.  Originally I wrote the program in C.  In January 2023 I discovered that the program no longer ran with the modern gcc compiler.  I fixed the C version and subsequently wrote this Java version.  This version has a nicer graphical user interface than the original.  In most ways it does more than the original but in a few ways it does a bit less.  The best thing is does is let you survey the injectivity proof.\n\nThis is an ongoing project.  I will improve the interface whenever I feel like it.  I had wanted to do this for 20 years and now I am doing it.\n\nEssentially what the program does is store the structure of the complexes Z and Z_prime from the paper.  You can plot the intersections of these complexes with the unit sphere and also you can run the various tests mentioned in the paper.  The biggest test is the injectivity test, and quite a bit of the interface is devoted to that.  This part of the interface is much better than the original.";

	    S=S+"\n\nOPERATING INSTRUCTIONS\n\n";

	    S=S+"This window gives explanations for the rest of the program.  Drag the mouse over the text to scroll up or down. (There may be more text than what is now visible.) The text in this window will change if you press some of the black ?-boxes sprinkled throughout the rest of the program. If you want to return this text, press the black ?-box at top left.";

	    S=S+"\n\nWhen this program opens, it only shows this window. If you press buttons on the popup window you get more windows. All the popup windows are resizable.";

	    S=S+"\n\nThis program is designed to work best with a 3 button mouse. On the picture window, buttoms 1 and 3 zoom in and out of the picture and button 2 selects a new point. If you don't have a 3 button mouse, you can use the keyboard buttons z,x,c or the buttons b,n,m to simulate the 3 buttons when you are operating any of the windows where you might want to rescale the picture.";

	    S=S+"\n\nOVERVIEW OF THE WINDOWS:";

	    S=S+"\n\ncontrol panel: This is the window from which you launch the programs. You should click the ?-boxes to learn more about what it does.";

	    S=S+"\n\ndocument: This is the window you are currently looking at.";

	    S=S+"\n\nPair selector: The complex Z_prime has 393 tetrahedra. This window lets you click/drag the mouse around and select any pair of tetrahedra from this list.";

	    S=S+"\n\nPicture canvas: After you select a pair from the pair selector, you can see the two tetrahedra plotted in such a way that you can see they have disjoint interiors.  The plot involves various maps into CP^1.  The various tests are described in the monograph.  All the tests involve constructing graphs made from the projectivizations of the edges, which are circular arcs.  Basically the tests show that with a suitable map the two graphs are disjoint in the strong sense that the domains bounded by the graphs have disjoint interiors.";

	    S=S+"\n\nTiling: This window shows the tiling associated to the complexes Z and Z_prime, plotted in canonical coordinates which are adapted to the spherical CR structure on S^3.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

