import java.awt.*;
import java.math.*;
import java.awt.geom.*;

/*This file contains the specialized drawing routines.*/
public class DrawTiling {


/*finds positive roots of Ax^2+Bx+C=0.  gives
error when roots are imaginary.  This case
should not arise in our computations */

   public static double polynomial_root(int i,double A,double B,double C) {
	double d=Math.sqrt(B*B-4*A*C);
	if(i==1) return (-B-d)/(2*A);
	else return (-B+d)/(2*A);
    }

/*this routine returns the null vector
interpolating between a negative
and a positive vector*/



public static ComplexVector null_vector(ComplexVector neg,ComplexVector pos) {
    ComplexVector N=new ComplexVector();
    ComplexVector P=new ComplexVector();
    Complex nn=ComplexVector.hermitianDot(neg,neg);
    
  if(nn.x<=0) {
      N=new ComplexVector(neg);
      P=new ComplexVector(pos);
  }

  if(nn.x>=0) {
      P=new ComplexVector(neg);
      N=new ComplexVector(pos);
  }

  nn=ComplexVector.hermitianDot(N,N);
  Complex pp=ComplexVector.hermitianDot(P,P);
  Complex pn=ComplexVector.hermitianDot(P,N);
  Complex np=ComplexVector.hermitianDot(N,P);
  double A=(nn.x+pp.x)-(np.x+pn.x);
  double B=(np.x+pn.x)-(pp.x+pp.x);
  double C=pp.x;
  double X1=polynomial_root(1,A,B,C);
  double X2=polynomial_root(2,A,B,C);
  double X=X2;
  if((X1>=0)&&(X1<=1)) X=X1;
  Complex CX=new Complex(X,0);
  Complex CY=new Complex(1-X,0);
  ComplexVector U=ComplexVector.plus(ComplexVector.scale(CX,N),ComplexVector.scale(CY,P));
  return(U);
}





/*Here is the elevation map, discussed in Ch 4.1 of the paper.*/



public static Complex Psi(int render,ComplexVector q) {
  double r;
  Complex[] z=new Complex[10];
  for(int i=0;i<10;++i) z[i]=new Complex();
  ComplexVector a=NumericalValues.EiK_plain();
  ComplexVector b=NumericalValues.E0K_plain();
  ComplexVector c=NumericalValues.EpK_plain();
  z[1]=ComplexVector.hermitianDot(q,a);
  z[2]=ComplexVector.hermitianDot(q,b);
  z[3]=ComplexVector.hermitianDot(q,c);
  z[8].x=Complex.norm(z[1]);z[8].y=0;
  z[9].x=Complex.norm(z[2]);z[9].y=0;
  z[4]=Complex.plus(Complex.times(z[8],z[2]),Complex.times(z[9],z[1]));
  z[5]=Complex.divide(z[3],z[4]);
  z[5].x=-z[5].x;
  z[5].y=-z[5].y;
  z[6].x=-Complex.arg(z[5]);
  z[6].y=Complex.norm(Complex.divide(z[1],z[2]));
  z[6].y=.5*Math.log(z[6].y);
  if(render==1) return(z[6]);
  r=Math.exp(z[6].y);
  z[7].x=r*Math.cos(z[6].x);
  z[7].y=r*Math.sin(z[6].x);
  return(z[7]);
}




/*this program deals with the problem of
  wrap on the cylinder.  The guide parameter
  prevents jumps in the arg function */


public static Complex guided_Psi(int guide,int render,ComplexVector q) {
  double r;
  Complex[] z=new Complex[10];
  for(int i=0;i<10;++i) z[i]=new Complex();
  ComplexVector a=NumericalValues.EiK_plain();
  ComplexVector b=NumericalValues.E0K_plain();
  ComplexVector c=NumericalValues.EpK_plain();
  z[1]=ComplexVector.hermitianDot(q,a);
  z[2]=ComplexVector.hermitianDot(q,b);
  z[3]=ComplexVector.hermitianDot(q,c);
  z[8].x=Complex.norm(z[1]);z[8].y=0;
  z[9].x=Complex.norm(z[2]);z[9].y=0;
  z[4]=Complex.plus(Complex.times(z[8],z[2]),Complex.times(z[9],z[1]));
  z[5]=Complex.divide(z[3],z[4]);
  z[5].x=-z[5].x;
  z[5].y=-z[5].y;
  z[6].x=-Complex.arg(z[5]);
  double temp=z[6].x;
  if((guide==0)&&(z[6].x>-0.5*Math.PI)) temp=z[6].x-2*Math.PI;
  if((guide==1)&&(z[6].x<-1.5*Math.PI)) temp=z[6].x+2*Math.PI;
  z[6].x=temp;
  z[6].y=Complex.norm(Complex.divide(z[1],z[2]));
  z[6].y=.5*Math.log(z[6].y);
  if(render==1) return(z[6]);
  r=Math.exp(z[6].y);
  z[7].x=r*Math.cos(z[6].x);
  z[7].y=r*Math.sin(z[6].x);
  return(z[7]);
}



    


/*This program draws solid (many-sided) polygons
which are part of the tiling of Z_0, discussed
in Ch 4.*/

 public static Path2D.Double fill_mixed_draw(int guide,int render,ComplexVector p,ComplexVector q,ComplexVector r) {
    PolygonWrapper X=new PolygonWrapper();
    X.count=100; 
    for(int i=0;i<=100;++i) {
       double ii=1.0*i/100;
       Complex cq=new Complex(1-ii,0.0);
       Complex cr=new Complex(ii,0.0);
       ComplexVector v=ComplexVector.plus(ComplexVector.scale(cq,q),ComplexVector.scale(cr,r));
       ComplexVector w=null_vector(p,v);
       Complex z=guided_Psi(guide,render,w);
       X.z[i]=new Complex(z);
    }
    Path2D.Double pa=X.toPathOpen();
    return pa;
 }

    

    public static Path2D.Double poly_mixed_draw(int render,IntervalPoly P0)  {
	Poly P=P0.toPoly();
        IntegerList l1=PolyhedronOperations.negative_vertices(P0);
        IntegerList l2=PolyhedronOperations.positive_vertices(P0);
        if(l1.l*l2.l==0) return null;
        Complex z=Psi(render,null_vector(P.v[l1.n[1]],P.v[l2.n[1]])); 
        int  guide=1;  
        if(z.x<-3.14159265) guide=0;
        Path2D.Double p=new Path2D.Double();
 

 if(l1.l==1) 
   {
       p.append(fill_mixed_draw(guide,render,P.v[l1.n[1]],P.v[l2.n[1]],P.v[l2.n[2]]),true);
       p.append(fill_mixed_draw(guide,render,P.v[l1.n[1]],P.v[l2.n[2]],P.v[l2.n[3]]),true);
       p.append(fill_mixed_draw(guide,render,P.v[l1.n[1]],P.v[l2.n[3]],P.v[l2.n[1]]),true);
  }

 if(l2.l==1) 
   {
       p.append(fill_mixed_draw(guide,render,P.v[l2.n[1]],P.v[l1.n[1]],P.v[l1.n[2]]),true);
       p.append(fill_mixed_draw(guide,render,P.v[l2.n[1]],P.v[l1.n[2]],P.v[l1.n[3]]),true);
       p.append(fill_mixed_draw(guide,render,P.v[l2.n[1]],P.v[l1.n[3]],P.v[l1.n[1]]),true);
  }


 if(l2.l==2) 
   {
        p.append(fill_mixed_draw(guide,render,P.v[l1.n[1]],P.v[l2.n[2]],P.v[l2.n[1]]),true);
        p.append(fill_mixed_draw(guide,render,P.v[l2.n[1]],P.v[l1.n[1]],P.v[l1.n[2]]),true);
        p.append(fill_mixed_draw(guide,render,P.v[l1.n[2]],P.v[l2.n[1]],P.v[l2.n[2]]),true);
        p.append(fill_mixed_draw(guide,render,P.v[l2.n[2]],P.v[l1.n[2]],P.v[l1.n[1]]),true);
  }
 return p;
}




/*these routines find the null center of symmetry of
a symmetric tetrahedron with two positive and two negative
vectors. It is used to label the tiles */


/*
interval_vector null_center (n1,n2,p1,p2)
     interval_vector n1,n2,p1,p2;
{
  interval_vector n,p,v;
  n=vec_plus(n1,n2);
  p=vec_plus(p1,p2);
  v=null_vector(n,p);
  return(v);
}

*/
/*

complex Complex._null_center (render,n1,n2,p1,p2)
     int render;
     interval_vector n1,n2,p1,p2;
{
  interval_vector v;
  complex z;
  v=null_center(n1,n2,p1,p2);
  z=Psi(render,v);
  return(z);
}
  

*/


/*this routine draws an the projection of an edge to C.
It is similar to the routine edge_project_draw, except
that it doesn't plot individual points but rather
uses the routines in circle.c*/

/*
projection_edge_draw(color,joe,e)
     int color;
     FILE *joe;
     edge e;
{
  interval_vector v;
  vector pv;
  arc a;
  tcl_arc ta;
  v=edge_to_vector(e);
  pv=interval_to_plain(v);
  a=circle(pv);
  ta=arc_to_tcl(a);
  arc_write(color,joe,ta);
}

*/


/*this routine draws the projection of a polyhedron
  into the complex line stabilized by the shift K*/


/*
projection_graph_draw(color,joe,P)
     int color;
     FILE *joe;
     poly P;
{
  graph g;
  int i;
  g=cutoff_graph(P);
  for(i=1;i<=6;++i) projection_edge_draw(color,joe,g.e[i]);
}

*/
/*
projection_unit_circle_draw(color,joe)
     int color;
     FILE *joe;
{
  graph g;
  g=unit_circle_graph();
  projection_edge_draw(color,joe,g.e[1]);
  projection_edge_draw(color,joe,g.e[2]);
}



*/


/*thie routine intersects a tetrahedron with a
complex line.  The complex line 
is defined by the polar vector v.
The routine only works on tetrahedra within the
subdivision of a piece whose line of symmetry
is the complex line in question */

/*
plane_plot(color,joe,v,P)
int color;
FILE *joe;
interval_vector v;
poly P;
{
int i,total;
interval test;
edge e[5];
poly GOOD, BAD;
interval_vector w[10];
total=0;
GOOD.l=0;
BAD.l=0;

*/
/*the variable total counts the number
  of vertices contained in the complex line*/

/*
for(i=1;i<=4;++i)
  {
  test=Complex._norm(ComplexVector.hermitianDot(P.v[i],v));
  if(test.l<.001) 
    {
    ++GOOD.l;
    GOOD.v[GOOD.l]=P.v[i];
    ++total;
    }

   
  if(test.l>.001) 
    {
    ++BAD.l;
    BAD.v[BAD.l]=P.v[i];
    }
   
  }
*/



/*here an entire face is contained in the complex line*/

/*
if(total==3)
  {
  w[1]=GOOD.v[1];
  w[2]=GOOD.v[2]; 
  w[3]=GOOD.v[3];
  w[4]=w[1];

  for(i=1;i<=3;++i)
    {
    e[i].s[1][1]=w[i].a;
    e[i].s[1][2]=w[i].c;
    e[i].s[2][1]=w[i+1].a;
    e[i].s[2][2]=w[i+1].c;
    }

  for(i=1;i<=3;++i) projection_edge_draw(color,joe,e[i]);
  }

*/
/*here an edge is contained in the complex line.
Either the complex line bisects the other edge, or
not.  In the latter case we draw a triangle and
in the former case we just draw the single edge*/

/*
if(total == 2)
  {
  w[1]=GOOD.v[1];
  w[2]=GOOD.v[2]; 
  w[3]=vec_plus(BAD.v[1],BAD.v[2]);
  w[4]=w[1];
  for(i=1;i<=3;++i)
    {
    e[i].s[1][1]=w[i].a;
    e[i].s[1][2]=w[i].c;
    e[i].s[2][1]=w[i+1].a;
    e[i].s[2][2]=w[i+1].c;
    }

*/

/*

  projection_edge_draw(color,joe,e[1]);
  test=Complex._norm(ComplexVector.hermitianDot(w[3],v)); 
  if(test.l<.00001) 
    {
      projection_edge_draw(color,joe,e[2]);
      projection_edge_draw(color,joe,e[3]);
    }
  }

}

*/

}
