import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;



public class Edge {
    IntervalComplex[][] s=new IntervalComplex[4][4];
    
    public Edge() {
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		s[i][j]=new IntervalComplex();
	    }
	}
    }

    public Complex[][] toComplex() {
  	Complex[][] z=new Complex[4][4];
	for(int i=1;i<=3;++i) {
	    for(int j=1;j<=3;++j) {
		z[i][j]=this.s[i][j].toComplex();
	    }
	}
	return z;
    }


    

    public Path2D.Double projectivizeAlt() {
	PolygonWrapper L=new PolygonWrapper();
	Complex[][] w=this.toComplex();
	L.count=100;
	Complex[] c=new Complex[6];
	Complex z=new Complex();
        for(int i=0;i<=100;++i) {
          double ii=1.0*i/100.0;
          c[1]=new Complex(ii,0.0);
          c[2]=new Complex(1.0-ii,0.0);
          c[3]=Complex.plus(Complex.times(c[1],w[1][1]),Complex.times(c[2],w[2][1]));
          c[4]=Complex.plus(Complex.times(c[1],w[1][2]),Complex.times(c[2],w[2][2]));
          c[5]=Complex.divide(c[3],c[4]);
	  L.z[i]=new Complex(c[5]);
	}
	return L.toPathOpen();
    }

    public Path2D.Double projectivize() {
	Complex[] L=new Complex[3];
	Complex[][] w=this.toComplex();
	Complex[] c=new Complex[6];
	Complex z=new Complex();
        for(int i=0;i<=2;++i) {
          double ii=1.0*i/2.0;
          c[1]=new Complex(ii,0.0);
          c[2]=new Complex(1.0-ii,0.0);
          c[3]=Complex.plus(Complex.times(c[1],w[1][1]),Complex.times(c[2],w[2][1]));
          c[4]=Complex.plus(Complex.times(c[1],w[1][2]),Complex.times(c[2],w[2][2]));
          c[5]=Complex.divide(c[3],c[4]);
	  L[i]=new Complex(c[5]);
	}
	CircularArc A=CircularArc.makeArc(L[0],L[1],L[2]);
	if(A.line==false) return A.toPath();
	return A.toPath();

    }


    

    public void print() {
	System.out.println("------EDGE------");
	for(int i=1;i<=2;++i) {
	    for(int j=1;j<=2;++j) {
		s[i][j].print();
	    }
	}
	System.out.println("---------------");
    }
	
}




