import java.awt.*;
import java.math.*;


public class EdgeIntersection {


/*convert an edge to a vector*/

public static IntervalComplexVector edge_to_vector(Edge e) {
    IntervalComplexVector v=new IntervalComplexVector();
  v.a=IntervalComplex.divide(e.s[1][1],e.s[1][2]);
  v.b=IntervalComplex.divide(IntervalComplex.plus(e.s[1][1],e.s[2][1]),IntervalComplex.plus(e.s[1][2],e.s[2][2]));
  v.c=IntervalComplex.divide(e.s[2][1],e.s[2][2]);
  return(v);
}

/*convert a vector to an edge*/

public static Edge vector_to_edge(IntervalComplexVector v)
{
  Edge e=new Edge();
  IntervalComplex w=IntervalComplex.divide(IntervalComplex.minus(v.b,v.a),IntervalComplex.minus(v.c,v.b));
  e.s[1][1]=v.a;
  e.s[1][2]=new IntervalComplex(1,0);
  e.s[2][1]=IntervalComplex.times(w,v.c);
  e.s[2][2]=w;
  return(e);
}


/*normalize so that one of the edges projectivizes
  to the positive real line.  See Ch. 10 in the paper.
  The other edge is called e3, and is the one that is
  returned by the program*/

    public static Edge normal_position(Edge e1,Edge e2) {
	Edge e3=new Edge();
  int i,j;
  e3.s[1][1]=IntervalComplex.minus(IntervalComplex.times(e1.s[2][2],e2.s[1][1]),IntervalComplex.times(e1.s[2][1],e2.s[1][2]));
  e3.s[1][2]=IntervalComplex.minus(IntervalComplex.times(e1.s[1][1],e2.s[1][2]),IntervalComplex.times(e1.s[1][2],e2.s[1][1]));
  e3.s[2][1]=IntervalComplex.minus(IntervalComplex.times(e1.s[2][2],e2.s[2][1]),IntervalComplex.times(e1.s[2][1],e2.s[2][2]));
  e3.s[2][2]=IntervalComplex.minus(IntervalComplex.times(e1.s[1][1],e2.s[2][2]),IntervalComplex.times(e1.s[1][2],e2.s[2][1]));
  return(e3);
}





/*computes the intersection number of the
projectivizations of two segments in C2. 
The segments are circular arcs.  The arcs are
not supposed to have any endpoints in common.
If they do, the computer returns a -1, signifying
a general failure of the test. The intersections
are found using the quadratic formula.  Special
cases somewhat complicate the otherwise
straightforward routine.*/


    public static Interval evaluate(Interval a,Interval b,Interval c,Interval t) {
       Interval y=new Interval();
       try{
         y=c;
         y=Interval.plus(y,Interval.times(b,t));
         y=Interval.plus(y,Interval.times(a,Interval.times(t,t)));
       }
       catch(Exception e) {
	   System.out.println("bad multiplication in evaluate: caught ");
	   y.l=-1;
	   y.r=1;
	   return y; //automatic fail
       }
    return(y);
}



public static int alternate_generic_intersection_number(Edge e) {
  /*this test computes the midpoint of the
line segment joining the endpoints of the
arc represented by e and then tries to show
that this arc lies in the circle centered
at this midpoint and containing the two endpoints.
We just need to show that another point on the
arc is closer to this midpoint. Once we know this,
then we check that the entire circle is disjoint
from the positive real axis by showing that the
x coordinate of the center is more negative
than the radius is positive.*/

    IntervalComplex x1=new IntervalComplex();
    IntervalComplex x2=new IntervalComplex();
    IntervalComplex x3=new IntervalComplex();
    IntervalComplex y=new IntervalComplex();
    Interval n1=new Interval();
    Interval n2=new Interval();
    int i,j;
    try{
       x1=IntervalComplex.divide(e.s[1][1],e.s[1][2]);
       x2=IntervalComplex.divide(e.s[2][1],e.s[2][2]);
       x3=IntervalComplex.divide(IntervalComplex.plus(e.s[1][1],e.s[2][1]),IntervalComplex.plus(e.s[1][2],e.s[2][2]));
    }
    catch(Exception exc) {
	System.out.println("bad division in alternatae_generic_intersection_number: caught");
	return(-1);//fails
    }
    
  /*take average*/
  y=IntervalComplex.plus(x1,x2);
  y.x.l=.5*y.x.l;
  y.x.r=.5*y.x.r;
  y.y.l=.5*y.y.l;
  y.y.r=.5*y.y.r;

  n1=IntervalComplex.norm(IntervalComplex.minus(x1,y));
  n2=IntervalComplex.norm(IntervalComplex.minus(x3,y));

  if(n2.r>n1.l) return(-1);
  if(n1.r<-y.x.r) return(0);
  return(-1);
}








public static int generic_intersection_number(Edge e1,Edge e2)
{
    Edge e;
  int n;
  IntervalComplex ca=new IntervalComplex();
  IntervalComplex cb=new IntervalComplex();
  IntervalComplex cc=new IntervalComplex();
  IntervalComplex R=new IntervalComplex();
  Interval a0=new Interval();
  Interval b0=new Interval();
  Interval c0=new Interval();
  Interval a1=new Interval();
  Interval b1=new Interval();
  Interval c1=new Interval();
  Interval a2=new Interval();
  Interval b2=new Interval();
  Interval t1=new Interval();
  Interval t2=new Interval();
  Interval v1=new Interval();
  Interval v2=new Interval();
  Interval v3=new Interval();
  Interval v4=new Interval();
  Interval ZERO=new Interval(0);

  e=normal_position(e1,e2); 

/*******************************************/
  /*if there are common endpoints we fail the
    computation*/

  if(Interval.equal(IntervalComplex.norm(e.s[1][1]),ZERO)==1) return(-1);
  if(Interval.equal(IntervalComplex.norm(e.s[1][2]),ZERO)==1) return(-1);
  if(Interval.equal(IntervalComplex.norm(e.s[2][1]),ZERO)==1) return(-1);
  if(Interval.equal(IntervalComplex.norm(e.s[2][2]),ZERO)==1) return(-1);
/*******************************************/


/*******************************************/
  /*find coefficients of the two quadratic polynomials
    a0_t^2+b0_t+c0* and a_1t^2+b_1t+c_1*/

  ca=IntervalComplex.times(e.s[1][1],IntervalComplex.conjugate(e.s[1][2]));
  cb=IntervalComplex.plus(IntervalComplex.times(e.s[1][1],IntervalComplex.conjugate(e.s[2][2])),
             IntervalComplex.times(e.s[2][1],IntervalComplex.conjugate(e.s[1][2])));
  cc=IntervalComplex.times(e.s[2][1],IntervalComplex.conjugate(e.s[2][2]));
  a0=ca.y;
  b0=cb.y;
  c0=cc.y; 
  a1=ca.x;
  b1=cb.x;
  c1=cc.x;  

  /*if just a0=0 we interchange a0 with c0 and a1 with c1,
    as described in Ch10 of the paper*/

  if(Interval.equal(a0,ZERO)==1) {
  c0=ca.y;
  b0=cb.y;
  a0=cc.y; 
  c1=ca.x;
  b1=cb.x;
  a1=cc.x;  
  }



  if((Interval.equal(a0,ZERO)==1)) return(alternate_generic_intersection_number(e));
  /*now we know that a0 is nonzero*/
  /****************************************************/




  /****************************************************/
  /*case 1:  In some cases we can guarantee easily that
    there are no real roots*/

  /*no real roots if the discriminant is negative*/
  v1=Interval.times(b0,b0);
  v2=Interval.times(Interval.plus(c0,c0),Interval.plus(a0,a0));
  v3=Interval.minus(v1,v2);
  if(v3.r<0) return(0);

  /*If c*a and b*a are both positive then there are
    no real roots.*/
  v1=Interval.times(c0,a0);
  v2=Interval.times(b0,a0);
  if((v1.l>0)&&(v2.l>0)) return(0);
 /****************************************************/


 /****************************************************/
  /*compute the auxilliary quantities a2 and b2*/
  if(a0.l>0) {
  a2=Interval.minus(Interval.times(a0,b1),Interval.times(b0,a1));
  b2=Interval.minus(Interval.times(a0,c1),Interval.times(c0,a1));
  }

  if(a0.r<0) {
  a2=Interval.minus(Interval.times(a1,b0),Interval.times(b1,a0));
  b2=Interval.minus(Interval.times(a1,c0),Interval.times(c1,a0));
  }
  /****************************************************/


  /****************************************************/
  /*case 2: the inequalities are incompatible, so no roots*/
  if((a2.r<0)&&(b2.r<0)) return(0);
  /****************************************************/

  /****************************************************/
  /*case 3: the second inequality is redundant.  Then we
    just have to compute the number of positive roots of
    P(t)=a_0t^2+b_0t+c_0=0*/

  if((a2.l>0)&&(b2.l>0)) 
    {
    if((c0.r<0)&&(a0.r>0)) return(1);
    if((c0.r>0)&&(a0.r<0)) return(1);
  /*now we know that P(0) and P(infinity) have the same sign.
    So we compute the critical point t1=-b0/2a0.*/
    t1=Interval.minus(ZERO,Interval.divide(b0,Interval.plus(a0,a0)));
    if(t1.r<0) return(0);  /*critical point negative*/
    /*now we know that the critical point is positive,
      so we compute the critical value*/
    v1=evaluate(a0,b0,c0,t1);
    
    if(Interval.equal(v1,ZERO)==1) return(-1); /*fail boundary case*/
    if((c0.r<0)&&(v1.r<0)) return(0);
    if((c0.l>0)&&(v1.l>0)) return(0);
    if((c0.r<0)&&(v1.l>0)) return(2);
    if((c0.l>0)&&(v1.r<0)) return(2);
    return(-1); /*fail any other cases*/
    }
   /****************************************************/


   /****************************************************/
  /*case 4: the first inequality is redundant.  Then we
    just have to compute the number of roots of P(t) where
    t is in the ray [-b_2/a_2, infinity) */

    if((a2.l>0)&&(b2.r<0)) 
      {
	  try{
  	       t1=Interval.minus(ZERO,Interval.divide(b2,a2));
	  }
	  catch(Exception exc) {
	      System.out.println("bad division in generic intersection number (case 4):  caught");
	      b2.print();
	      a2.print();
	      return(-1); //fails any bad divisions
	  }

	  
	v1=evaluate(a0,b0,c0,t1);
	if(Interval.equal(v1,ZERO)==1) return(-1); /*fail boundary case*/
	if((v1.r<0)&&(a0.l>0)) return(1);
	if((v1.l>0)&&(a0.r<0)) return(1);
        /*now we know that P(t1) and P(infinity) have the same sign.
	  So we compute the critical point t2=-b0/2a0.*/
         t2=Interval.minus(ZERO,Interval.divide(b0,Interval.plus(a0,a0)));
         if(t2.r<t1.l) return(0);  /*critical pt less than endpoint*/
        /*now we know that the critical point lies in the
	  ray, so we compute the critical value*/
         v2=evaluate(a0,b0,c0,t2);
         if(Interval.equal(v2,ZERO)==1) return(-1); /*fail boundary case*/
         if((a0.r<0)&&(v2.r<0)) return(0);
         if((a0.l>0)&&(v2.l>0)) return(0);
         if((a0.r<0)&&(v2.l>0)) return(2);
         if((a0.l>0)&&(v2.r<0)) return(2);
	 return(-1); /*fail any other cases*/
      }
    /****************************************************/



    /****************************************************/
    /*case 5: the two inequalities carve out an interval.
      The interval is [0,t1] where t1=-b2/a2*/

     if((a2.r<0)&&(b2.l>0)) 
       {
	   try{
               t1=Interval.minus(ZERO,Interval.divide(b2,a2));
	   }
	   
	   catch(Exception exc) {
	       System.out.println("bad division in generic_intersection_number (case 5): caught");
	       return(-1); //fails
			       }

       v1=evaluate(a0,b0,c0,t1);
       if(Interval.equal(v1,ZERO)==1) return(-1); /*fail boundary case*/
       if((v1.r<0)&&(c0.l>0)) return(1);
       if((v1.l>0)&&(c0.r<0)) return(1);
       /*now we know that P(0) and P(t1) have the same sign.
	 So we compute the critical point t2=-b0/2a0.*/
       t2=Interval.minus(ZERO,Interval.divide(b0,Interval.plus(a0,a0)));
       if(t2.r<0) return(0);  /*critical pt negative*/
       if(t2.l>t1.r) return(0);  /*critical pt greater than endpt*/
       /*now we know that the critical point lies in the
       ray, so we compute the critical value*/
       v2=evaluate(a0,b0,c0,t2);
         if(Interval.equal(v2,ZERO)==1) return(-1); /*fail boundary case*/
         if((c0.r<0)&&(v2.r<0)) return(0);
         if((c0.l>0)&&(v2.l>0)) return(0);
         if((c0.r<0)&&(v2.l>0)) return(2);
         if((c0.l>0)&&(v2.r<0)) return(2);
	 return(-1); /*fail any other cases*/
       }
     /****************************************************/

     return(-1); /* fail any remaining cases*/
}




/*computes the intersection number of the
projectivizations of two segments in C2. 
The segments are circular arcs.  In this case
the arcs share an endpoint in common.  Special
cases somewhat complicate the otherwise
straightforward routine.*/

    public static int special_intersection_number(Edge e1,Edge e2) {
	Edge e=new Edge();
  int n;
  IntervalComplexVector v=new IntervalComplexVector();
  IntervalComplex ca=new IntervalComplex();
  IntervalComplex cb=new IntervalComplex();
  IntervalComplex cc=new IntervalComplex();
  Interval a= new Interval();
  Interval b= new Interval();
  Interval c= new Interval();
  Interval t1= new Interval();
  Interval v1= new Interval();
  Interval ZERO=new Interval(0);

  e=normal_position(e1,e2);

  /*******************************************/
  /*find polynomial coefficients*/
  /*******************************************/
  ca=IntervalComplex.times(e.s[1][1],IntervalComplex.conjugate(e.s[1][2]));
  cb=IntervalComplex.plus(IntervalComplex.times(e.s[1][1],IntervalComplex.conjugate(e.s[2][2])),
     IntervalComplex.times(e.s[2][1],IntervalComplex.conjugate(e.s[1][2])));
  cc=IntervalComplex.times(e.s[2][1],IntervalComplex.conjugate(e.s[2][2]));
  a=ca.y;
  b=cb.y;
  c=cc.y;
  
  /************************************************/
  /*degenerate case: all coefficients disappear*/
  /************************************************/
  if((Interval.equal(a,ZERO)==1)&&(Interval.equal(b,ZERO)==1)&&(Interval.equal(c,ZERO)==1))
    {
    a=ca.x;
    b=cb.x;
    c=cc.x; 
    if(Interval.equal(c,ZERO)==1) 
      {
        if((a.r<0)&&(b.r<0)) return(1);
        return(-1);
      }
    if(Interval.equal(a,ZERO)==1) 
      { 
        if((c.r<0)&&(b.r<0)) return(1);
        return(-1);
      }
    }
  /************************************************/
  /**************not all coefficients disappear**************/ 
  /************************************************/
  
  /*degenerate case: the the edge e projectivizes to an infinite ray*/
  if((Interval.equal(a,ZERO)==1) && (Interval.equal(b,ZERO)==1) &&(Interval.equal(c,ZERO)!=1))
     return(1);
  if((Interval.equal(c,ZERO)==1) && (Interval.equal(b,ZERO)==1) &&(Interval.equal(a,ZERO)!=1))
     return(1);

  int a0=Interval.equal(a,ZERO);
  int c0=Interval.equal(c,ZERO);

  /*typical cases: solve linear equation*/
  if((a0==1)&&(c0==1)) return(-1); //fail
  if(c0==1)  {t1=Interval.divide(b,a); t1=Interval.minus(ZERO,t1);}
  if(a0==1)  {t1=Interval.divide(c,b); t1=Interval.minus(ZERO,t1);}
  if(Interval.equal(t1,ZERO)==1) return(-1);
  if(t1.r<0) return(1);



  /*******************************/
  /*at this point t1 is positive*/
  /*******************************/
  a=ca.x;
  b=cb.x;
  c=cc.x; 
 
  if(Interval.equal(c,ZERO)==1) v1=Interval.plus(Interval.times(a,t1),b);
  if(Interval.equal(a,ZERO)==1) v1=Interval.plus(Interval.times(b,t1),c);
  if(Interval.equal(v1,ZERO)==1) return(-1);
  if(v1.l>0) return(2);
  return(1);
}



/* 1 indicates success -- that is, the arcs are disjoint
   except if they share an endpoint. */

public static int edge_projection_test(Edge e1,Edge e2)
{
    Edge e=new Edge();
    Edge e3=new Edge();
    int[] n=new int[5];
    int i,test;

  e=normal_position(e1,e2);
  
  n[1]=0;
  n[2]=0;
  n[3]=0;
  n[4]=0;
  Interval ZERO=new Interval(0);
  if((Interval.equal(IntervalComplex.norm(e.s[1][1]),ZERO)==1)) n[1]=1;
  if((Interval.equal(IntervalComplex.norm(e.s[1][2]),ZERO)==1)) n[2]=1;
  if((Interval.equal(IntervalComplex.norm(e.s[2][1]),ZERO)==1)) n[3]=1;
  if((Interval.equal(IntervalComplex.norm(e.s[2][2]),ZERO)==1)) n[4]=1;

  if((n[1]==1)&&(n[2]==1)) return(-1);
  if((n[3]==1)&&(n[4]==1)) return(-1);
  if((n[1]==1)&&(n[4]==1)) return(4); /*both endpoints agree*/
  if((n[2]==1)&&(n[3]==1)) return(4); /*both endpoints agree*/

  if(n[1]+n[2]+n[3]+n[4]>0)
    {
    test=special_intersection_number(e1,e2);
    if(test==1) return(1);
    return(-1);
    }
  test=generic_intersection_number(e1,e2);
  if(test==0) return(1);
  return(-1);
}

}
