import java.awt.*;
import java.math.*;


public class EdgeSmash {
    
/*This is the graph L_1(e times T), described in Ch 10.
  It is a triangle in C2.  Here times is the Hermitian
  cross product.*/


  public static  Graph edge_smash_graph(IntervalPoly P1,IntervalPoly P2) {
  int a,b,count;
  int c=0;
  int d=0;
  IntegerList l=new IntegerList();
  Graph G=new Graph();
  Edge ee=new Edge();
  IntervalComplexVector v0=new IntervalComplexVector();
  IntervalComplexVector v1=new IntervalComplexVector();
  IntervalComplexVector v2=new IntervalComplexVector();
  IntervalComplexVector v3=new IntervalComplexVector();
  IntervalComplexVector v4=new IntervalComplexVector();
  IntervalComplexVector v5=new IntervalComplexVector();
  
  G.l=4;
   l=PolyhedronOperations.code_common_vertices(P1,P2);
  a=l.n[1];
  b=l.n[2];
  if(a*b==2)  {c=3;d=4;}
  if(a*b==3)  {c=2;d=4;}
  if(a*b==4)  {c=2;d=3;} 
  if(a*b==6)  {c=1;d=4;}
  if(a*b==8)  {c=1;d=3;}
  if(a*b==12) {c=1;d=2;}
  v0=IntervalComplexVector.minus(P1.v[a],P1.v[b]);
  v1=IntervalComplexVector.hermitianCross(v0,P1.v[b]);
   v2=IntervalComplexVector.hermitianCross(v0,P1.v[c]);
  v3=IntervalComplexVector.hermitianCross(v0,P1.v[d]);

  G.e[1]=Projection.create_edge(1,v1,v2);
  G.e[2]=Projection.create_edge(1,v2,v3);
  G.e[3]=Projection.create_edge(1,v3,v1);

 /*this edge encodes the barycenter*/
  v4=IntervalComplexVector.plus(IntervalComplexVector.plus(P1.v[b],P1.v[c]),P1.v[d]);
  v5=IntervalComplexVector.hermitianCross(v0,v4);
  G.e[4]=Projection.create_edge(1,v5,v5);
  G.l=3;
  return(G);
}



    public static int smash_interior_test(Edge e,Graph G) {
  int i,n,test;
  n=0;
  for(i=1;i<=3;++i) 
    {
        test=EdgeIntersection.generic_intersection_number(e,G.e[i]); 
      if(test<0) return(-1);  
      n=n+test;
    }
  return(n%2);
}


/* creates the edge which joins the barycenters of
   the two graphs */

    public static Edge join_smash_barycenters(Graph G1,Graph G2) {
    Edge ee=new Edge();
    ee.s[1][1]=G1.e[4].s[1][1];
    ee.s[1][2]=G1.e[4].s[1][2];
    ee.s[2][1]=G2.e[4].s[2][1];
    ee.s[2][2]=G2.e[4].s[2][2];
    return(ee);
}





public static int edge_smash_test(IntervalPoly P1,IntervalPoly P2) {
    Edge ee=new Edge();
  int test,i,j;
  Graph G2=edge_smash_graph(P2,P1);
  Graph G1=edge_smash_graph(P1,P2); 

  for(i=1;i<=3;++i) 
    {
      for(j=1;j<=3;++j)
	{
  	  test=EdgeIntersection.edge_projection_test(G1.e[i],G2.e[j]);
          if(test!=1) return(-1);
	}
    }

  ee=join_smash_barycenters(G1,G2);
  test=smash_interior_test(ee,G1);
  if(test!=1) return(-1);
  test=smash_interior_test(ee,G2);
  if(test!=1) return(-1);
  test=smash_interior_test(ee,G1);
  if(test!=1) return(-1);
  test=smash_interior_test(ee,G2);
  if(test!=1) return(-1);
  return(1);
}

}
