import java.awt.*;
import java.math.*;

/**This is the implementation of interval
   arithmetic.*/

public class Interval {
    double l,r;

    /**constructors **/

    public Interval() { }

    public Interval(Interval X) {
	this.l=X.l;
	this.r=X.r;
    }

    public Interval(double x) {
	this.l=x;
	this.r=x;
    }

    /**x<=y in this case**/
    public Interval(double x,double y) {
	this.l=x;
	this.r=y;
    }

    /**printout**/

    public void print() {
	System.out.println("["+this.l+" , "+this.r+"]");
    }


    
    
    /**rounds a double upwards **/
  public static double roundUp(double x) {
    if(x==Double.POSITIVE_INFINITY) return(Double.POSITIVE_INFINITY);
    if(x==Double.NEGATIVE_INFINITY) return(Double.NEGATIVE_INFINITY);
    if(x==0)      return Double.longBitsToDouble(1);
    long xx = Double.doubleToLongBits(x);
    if(x>0) return(Double.longBitsToDouble(xx+1));
    return(Double.longBitsToDouble(xx-1));
  }

    /**rounds downward**/
  public static double roundDn(double x) {
      if (x==0) return(-roundUp(0.0));
      return(-roundUp(-x));
  }


    

    /**basic arithmetic routines**/

    public static Interval max(Interval I,Interval J) {
	double t1=Math.max(I.l,J.l);
	double t2=Math.max(I.r,J.r);
	return(new Interval(t1,t2));
    }

    public static Interval min(Interval I,Interval J) {
	double t1=Math.min(I.l,J.l);
	double t2=Math.min(I.r,J.r);
	return(new Interval(t1,t2));
    }

    public static Interval plus(Interval I,Interval J) {
	checkRangePlusMinus(I,J);
	Interval K=new Interval();
	K.l=roundDn(I.l+J.l);
	K.r=roundUp(I.r+J.r);
	return(K);
    }

    public static Interval minus(Interval I,Interval J) {
	checkRangePlusMinus(I,J);
	Interval K=new Interval();
	K.l=roundDn(I.l-J.r);
	K.r=roundUp(I.r-J.l);
	return(K);
    }

    public static Interval times(Interval I,Interval J) throws ProofException {
	checkRangeTimes(I,J);
	Interval K=new Interval();
        double ll,lr,rl,rr,l,r;
        ll=I.l*J.l;
        lr=I.l*J.r;
        rl=I.r*J.l;
        rr=I.r*J.r;
        K.l=ll;
        if(K.l>lr) K.l=lr;
        if(K.l>rl) K.l=rl;
        if(K.l>rr) K.l=rr;
        K.r=ll;
        if(K.r<lr) K.r=lr;
        if(K.r<rl) K.r=rl;
        if(K.r<rr) K.r=rr;
	K.l=roundDn(K.l);
	K.r=roundUp(K.r);
	return(K);
    }


    /**our division routine is a bit complicated because it happens occasionally
       the we want to compute I0/J0, where both are close to 0.  In this case, we 
       multiply both by 2^{10} to make them larger. This avoids overflow errors*/

    
    public  static Interval divide(Interval I0,Interval J0) throws ProofException {
	Interval I=new Interval(I0);
	Interval J=new Interval(J0);
	
	boolean test=smallDenominator(J0);
	if(test==true) {
	    Interval K=new Interval(Math.pow(2,10));
	    I=times(I,K);
	    J=times(J,K);
	}

	checkRangeDivide(I,J);
	Interval K=new Interval();	
        double ll,lr,rl,rr,l,r;
        ll=I.l/J.l;
        lr=I.l/J.r;
        rl=I.r/J.l;
        rr=I.r/J.r;
        K.l=ll;
        if(K.l>lr) K.l=lr;
        if(K.l>rl) K.l=rl;
        if(K.l>rr) K.l=rr;
        K.r=ll;
        if(K.r<lr) K.r=lr;
        if(K.r<rl) K.r=rl;
        if(K.r<rr) K.r=rr;
        K.l=roundDn(K.l);
	K.r=roundUp(K.r);	
	return(K);
    }

    public Interval invert() {
	double ll=1.0/l;
	double rr=1.0/r;
	Interval I=new Interval(Math.min(ll,rr),Math.max(ll,rr));
	return I;
    }

    public static Interval sqrt(Interval I) {
	Interval J=new Interval();
	if(I.l<0) throw new ProofException("bad sq_root");
	if(I.r<0) throw new ProofException("bad sq_root");
        J.l=Math.sqrt(I.l);
        J.r=Math.sqrt(I.r);
        J.l=roundDn(J.l);
        J.r=roundUp(J.r);
        return(J);
    }

    public static Interval negative(Interval I) {
	return new Interval(-I.r,-I.l);
    }

    /**absolute value**/

    public boolean equalsZero() {
	if(l!=0.0) return(false);
	if(r!=0.0) return(false);
	return(true);
    }

    public static  Interval ZERO() {
	return(new Interval(0.0));
    }


    /**These routines are in place to prevent overflow error.
       We make sure that we are never performing operations
       on numbers which are too large.*/

    public static void checkRangeTimes(Interval I,Interval J) {
	boolean test=true;
	double LIMIT1=Math.pow(2,25);
	double LIMIT2=Math.pow(2,25);
	if(I.r>+LIMIT1) test=false;
	if(I.l<-LIMIT1) test=false;
	if(J.r>LIMIT2) test=false;
	if(J.l<-LIMIT2) test=false;
	if(test==true) return;
	
	test=true;
	LIMIT1=Math.pow(2,40);
	LIMIT2=Math.pow(2,10);
	if(I.r>+LIMIT1) test=false;
	if(I.l<-LIMIT1) test=false;
	if(J.r>LIMIT2) test=false;
	if(J.l<-LIMIT2) test=false;
	if(test==true) return;

	test=true;
	LIMIT1=Math.pow(2,10);
	LIMIT2=Math.pow(2,40);
	if(I.r>+LIMIT1) test=false;
	if(I.l<-LIMIT1) test=false;
	if(J.r>LIMIT2) test=false;
	if(J.l<-LIMIT2) test=false;
	if(test==true) return;
        throw new ProofException("bad multiplication");
    }


    /**This returns true if we are trying to divide by a very small number < 2^{-30}.
       In this case we will multiply both intervals by 2^{10} to get them closer to
       something reasonable*/

        public static boolean smallDenominator(Interval J) {
	    double t=Math.pow(2,-40);
	    if((Math.abs(J.l)<t)&&(Math.abs(J.r)<t)) return true;
	    return false;
	}
    
    public static void checkRangeDivide(Interval I,Interval J0) {
	if(Math.abs(J0.l)<Math.pow(2,-50)) throw new ProofException("bad division");
	if(Math.abs(J0.r)<Math.pow(2,-50)) throw new ProofException("bad division");
	Interval J=J0.invert();
	boolean test=true;
	double LIMIT1=Math.pow(2,25);
	double LIMIT2=Math.pow(2,25);
	if(I.r>+LIMIT1) test=false;
	if(I.l<-LIMIT1) test=false;
	if(J.r>LIMIT2) test=false;
	if(J.l<-LIMIT2) test=false;
	if(test==true) return;
	
	test=true;
	LIMIT1=Math.pow(2,40);
	LIMIT2=Math.pow(2,10);
	if(I.r>+LIMIT1) test=false;
	if(I.l<-LIMIT1) test=false;
	if(J.r>LIMIT2) test=false;
	if(J.l<-LIMIT2) test=false;
	if(test==true) return;

	test=true;
	LIMIT1=Math.pow(2,10);
	LIMIT2=Math.pow(2,40);
	if(I.r>+LIMIT1) test=false;
	if(I.l<-LIMIT1) test=false;
	if(J.r>LIMIT2) test=false;
	if(J.l<-LIMIT2) test=false;
	if(test==true) return;


	I.print();
	J0.print();
	
        throw new ProofException("bad division");
    }




    
    

    

    public static void checkRangePlusMinus(Interval I,Interval J) {
	double LIMIT=Math.pow(2,40);
	boolean test=true;
	if(I.r>+LIMIT) test=false;
	if(I.l<-LIMIT) test=false;
	if(J.r>+LIMIT) test=false;
	if(J.l<-LIMIT) test=false;
	if(test==false) throw new ProofException("bad addition or subtraction");
    }


    
    public static Interval random() {
	double d=1-2*Math.random();
	Interval D=new Interval(d);
	return D;
    }

    /**this really means that the intervals overlap*/
    
public static int equal(Interval I1,Interval I2)
{
  if(I1.r<I2.l) return(0);
  if(I1.l>I2.r) return(0);
  return(1);
}

    
}

