import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of interval complex numbers */

public class IntervalComplex {
    Interval x,y;



    public IntervalComplex() {
	Interval ZERO=new Interval(0,0);
	this.x=new Interval(0,0);
	this.y=new Interval(0,0);
    } 

    public IntervalComplex(Interval x,Interval y) {
	this.x=new Interval(x);
	this.y=new Interval(y);
    } 
    
    public IntervalComplex(double x,double y) {
	this.x=new Interval(x);
	this.y=new Interval(y);
    } 
    
    public IntervalComplex(IntervalComplex z) {
        this.x=new Interval(z.x);
        this.y=new Interval(z.y);
    }
    
    public IntervalComplex(Complex z) {
        this.x=new Interval(z.x);
        this.y=new Interval(z.y);
    }

    public static Interval norm(IntervalComplex z) {
	return Interval.sqrt(norm2(z));
    }
    
    public static Interval dist(IntervalComplex z1,IntervalComplex z2) {
	IntervalComplex z=minus(z1,z2);
	return norm(z);
    }
    
    public static Interval norm2(IntervalComplex z) {
	Interval X=Interval.times(z.x,z.x);
	Interval Y=Interval.times(z.y,z.y);
	Interval Z=Interval.plus(X,Y);
	if(Z.l<0) Z.l=0;
	if(Z.r<0) Z.r=0;
	return Z;
    }

    public static IntervalComplex unit(IntervalComplex z) {
        Interval d=norm(z);
	Interval X=Interval.divide(z.x,d);
	Interval Y=Interval.divide(z.y,d);
        return new IntervalComplex(X,Y);
    }

    
    public static IntervalComplex plus(IntervalComplex z1,IntervalComplex z2) {
	Interval X=Interval.plus(z1.x,z2.x);
	Interval Y=Interval.plus(z1.y,z2.y);
        return new IntervalComplex(X,Y);
    }
    
    public static IntervalComplex negative(IntervalComplex z) {
	Interval X=Interval.negative(z.x);
	Interval Y=Interval.negative(z.y);
	return new IntervalComplex(X,Y);
    }
    
    public static IntervalComplex minus(IntervalComplex z1,IntervalComplex z2) {
	Interval X=Interval.minus(z1.x,z2.x);
	Interval Y=Interval.minus(z1.y,z2.y);
        return new IntervalComplex(X,Y);
    }
    
    public static IntervalComplex times(IntervalComplex z1,IntervalComplex z2) {
	Interval X=Interval.minus(Interval.times(z1.x,z2.x),Interval.times(z1.y,z2.y));
	Interval Y=Interval.plus(Interval.times(z1.x,z2.y),Interval.times(z1.y,z2.x));
        return new IntervalComplex(X,Y);
    }

    public static IntervalComplex inverse(IntervalComplex z) {
	Interval d=norm2(z);
	Interval X=Interval.divide(z.x,d);
	Interval Y=Interval.divide(z.y,d);
	Y=Interval.negative(Y);
        return new IntervalComplex(X,Y);
    }

    public static IntervalComplex divide(IntervalComplex z1,IntervalComplex z2) {
        return times(z1,inverse(z2));
    }
    
    public static IntervalComplex conjugate(IntervalComplex z) {
	Interval ZERO=new Interval(0,0);
        return new IntervalComplex(z.x,Interval.minus(ZERO,z.y));
    }

    public static IntervalComplex random() {
	Interval X=Interval.random();
	Interval Y=Interval.random();
	return new IntervalComplex(X,Y);
    }

    public static int equal(IntervalComplex z1,IntervalComplex z2) {
        if(Interval.equal(z1.x,z2.x)==0) return(0);
        if(Interval.equal(z1.y,z2.y)==0) return(0);
        return(1);
    }

    public Complex toComplex() {
	double xx=(x.l+x.r)/2;
	double yy=(y.l+y.r)/2;
	return new Complex(xx,yy);
    }

    public void print() {
	x.print();
	y.print();
    }


}

