import java.awt.event.*;
import java.awt.*;

public class IntervalComplexVector {
    IntervalComplex a,b,c;
    Code X;

    public IntervalComplexVector() {
	this.a=new IntervalComplex();
	this.b=new IntervalComplex();
	this.c=new IntervalComplex();
	this.X=new Code();
    }
    
    public IntervalComplexVector(IntervalComplex a,IntervalComplex b,IntervalComplex c) {
	this.a=new IntervalComplex(a);
	this.b=new IntervalComplex(b);
	this.c=new IntervalComplex(c);
	this.X=new Code();
    }

    public IntervalComplexVector(IntervalComplexVector V) {
	this.a=new IntervalComplex(V.a);
	this.b=new IntervalComplex(V.b);
	this.c=new IntervalComplex(V.c);
	this.X=new Code();
	this.X.l=V.X.l;
	for(int i=0;i<10;++i) {
	    this.X.a[i]=V.X.a[i];
	    this.X.b[i]=V.X.b[i];
	    this.X.c[i]=V.X.c[i];
	}
    }

    public static IntervalComplex dot(IntervalComplexVector V,IntervalComplexVector W) {
	IntervalComplex A=IntervalComplex.times(V.a,W.a);
	IntervalComplex B=IntervalComplex.times(V.b,W.b);
	IntervalComplex C=IntervalComplex.times(V.c,W.c);
	IntervalComplex D=IntervalComplex.plus(A,B);
	D=IntervalComplex.plus(D,C);
	return D;
    }


    public static IntervalComplex hermitianDot(IntervalComplexVector V,IntervalComplexVector W) {
	IntervalComplex A=IntervalComplex.times(V.a,IntervalComplex.conjugate(W.a));
	IntervalComplex B=IntervalComplex.times(V.b,IntervalComplex.conjugate(W.b));
	IntervalComplex C=IntervalComplex.times(V.c,IntervalComplex.conjugate(W.c));
	IntervalComplex D=IntervalComplex.plus(A,B);
	D=IntervalComplex.minus(D,C);
	return D;
    }


/*Hermitian lorenz cross product on C3*/
    public static IntervalComplexVector hermitianCross(IntervalComplexVector v,IntervalComplexVector w) {
	IntervalComplexVector x=new IntervalComplexVector();
	x.a=IntervalComplex.minus(IntervalComplex.times(v.b,w.c),IntervalComplex.times(v.c,w.b));
	x.b=IntervalComplex.minus(IntervalComplex.times(v.c,w.a),IntervalComplex.times(v.a,w.c));
	x.c=IntervalComplex.minus(IntervalComplex.times(v.b,w.a),IntervalComplex.times(v.a,w.b));
	x.a=IntervalComplex.conjugate(x.a);
	x.b=IntervalComplex.conjugate(x.b);
	x.c=IntervalComplex.conjugate(x.c);
	return(x);
    }


/*Hermitian lorenz cross product on C3*/
    public static IntervalComplexVector cross(IntervalComplexVector v,IntervalComplexVector w) {
	IntervalComplexVector x=new IntervalComplexVector();
	x.a=IntervalComplex.minus(IntervalComplex.times(v.b,w.c),IntervalComplex.times(v.c,w.b));
	x.b=IntervalComplex.minus(IntervalComplex.times(v.c,w.a),IntervalComplex.times(v.a,w.c));
	x.c=IntervalComplex.minus(IntervalComplex.times(v.a,w.b),IntervalComplex.times(v.b,w.a));
	x.a=IntervalComplex.conjugate(x.a);
	x.b=IntervalComplex.conjugate(x.b);
	x.c=IntervalComplex.conjugate(x.c);
	return(x);
    }

    /*vector addition*/
    
    public static IntervalComplexVector plus(IntervalComplexVector V,IntervalComplexVector W) {
	IntervalComplex A=IntervalComplex.plus(V.a,W.a);
	IntervalComplex B=IntervalComplex.plus(V.b,W.b);
	IntervalComplex C=IntervalComplex.plus(V.c,W.c);
	return new IntervalComplexVector(A,B,C);
    }

    /*vector subtraction*/
    
    public static IntervalComplexVector minus(IntervalComplexVector V,IntervalComplexVector W) {
	IntervalComplex A=IntervalComplex.minus(V.a,W.a);
	IntervalComplex B=IntervalComplex.minus(V.b,W.b);
	IntervalComplex C=IntervalComplex.minus(V.c,W.c);
	return new IntervalComplexVector(A,B,C);
    }

    public static IntervalComplexVector scale(IntervalComplex a,IntervalComplexVector v) {
	IntervalComplexVector w=new IntervalComplexVector();
	w.a=IntervalComplex.times(a,v.a);
	w.b=IntervalComplex.times(a,v.b);
	w.c=IntervalComplex.times(a,v.c);
	return(w);
    }
    
    public static IntervalComplexVector average(IntervalComplexVector V,IntervalComplexVector W) {
	IntervalComplexVector X=plus(V,W);
	Interval H=new Interval(0.5);
	Interval Z=new Interval(0.0);
	IntervalComplex H2=new IntervalComplex(H,Z);
	return scale(H2,X);
    }
    
    public static IntervalComplexVector origin() {
	Interval Z=new Interval(0.0);
	IntervalComplex Z2=new IntervalComplex(Z,Z);
	return new IntervalComplexVector(Z2,Z2,Z2);
    }
	
    public static IntervalComplexVector random() {
	IntervalComplex A=IntervalComplex.random();
	IntervalComplex B=IntervalComplex.random();
	IntervalComplex C=IntervalComplex.random();
	return new IntervalComplexVector(A,B,C);
    }

    Interval dist(IntervalComplexVector v,IntervalComplexVector w) {
	Interval[] d=new Interval[5];
       d[1]=IntervalComplex.dist(v.a,w.a);
       d[2]=IntervalComplex.dist(v.b,w.b);
       d[3]=IntervalComplex.dist(v.c,w.c);
       d[4]=new Interval(0.0);
       for(int i=1;i<=4;++i)  d[4]=Interval.plus(d[4],Interval.times(d[i],d[i]));
       d[4]=Interval.sqrt(d[4]);
       return(d[4]);
    }

    public static int equal(IntervalComplexVector v1,IntervalComplexVector v2)
{
  if(IntervalComplex.equal(v1.a,v2.a)==0) return(0);
  if(IntervalComplex.equal(v1.b,v2.b)==0) return(0);
  if(IntervalComplex.equal(v1.c,v2.c)==0) return(0);
  return(1);
}

    public ComplexVector toComplexVector() {
	ComplexVector v=new ComplexVector();
	v.a=a.toComplex();
	v.b=b.toComplex();
	v.c=c.toComplex();
	return v;
    }

	
    public void print() {
	System.out.println("----------");
	a.print();
	b.print();
	c.print();
    }
    
}




