import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Graph G1,G2;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,200,100);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      Path2D.Double p=getGraph();
      if((M.C.ZOOM.mode==1)&&(p!=null)) scaleNicely(p);
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawGraph(g);
      //drawTiling(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawGraph(Graphics2D g) {
	if(G1==null) return;
	if(G2==null) return;
	Path2D.Double p1=G1.projectivize();
	p1=transform(p1);
	Path2D.Double p2=G2.projectivize();
	p2=transform(p2);
	

	int[] tr={60,255};
	int[] w={20,2};
	Color C1=M.C.DISPLAY.M[1].C;
	Color C2=M.C.DISPLAY.M[2].C;

	int lim=1;
	if(M.C.DISPLAY.L[3].on==1) lim=0;
	for(int k=lim;k<2;++k) {
	   g.setStroke(new BasicStroke(w[k]));
	   g.setColor(makeTransparent(C1,tr[k]));
	   g.draw(p1);
	   g.setColor(makeTransparent(C2,tr[k]));
	   g.draw(p2);
	}
    }

    public void drawTilingX(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	for(int i=1;i<=393;++i) {
	    IntervalPoly P=PiecesOfZPrime.TETRA(i);
	    for(int k=-4;k<5;++k) {
		IntervalPoly Q=PolyhedronOperations.shift(k,P);
     	        p=DrawTiling.poly_mixed_draw(1,Q);
	        if(p!=null) {
	            p=transform(p);
	            g.setColor(Color.white);
	            g.draw(p);
	       }
	    }
	}
    }


    public void drawTiling(Graphics2D g) {
	Color[] COL={Color.red,Color.blue};
	Path2D.Double p=new Path2D.Double();
	for(int i=1;i<=16;++i) {
	    for(int k=-10;k<11;++k) {
		IntervalPoly P=PiecesOfZ.tetra(k,i);
     	        p=DrawTiling.poly_mixed_draw(0,P);
	        if(p!=null) {
	            p=transform(p);
	            g.setColor(COL[i%2]);
	            g.fill(p);
	       }
	    }
	}
    }

    public Path2D.Double getGraph() {
	if(G1==null) return null;
	if(G2==null) return null;
	Path2D.Double p=G1.projectivize();
	p.append(G2.projectivize(),false);
	return p;
    }

    public static Color makeTransparent(Color C,int alpha) {
	int r=C.getRed();
	int b=C.getBlue();
	int g=C.getGreen();
	return new Color(r,g,b,alpha);
    }

    
    
    public void mousePressed(MouseEvent e) { }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	SOURCE=unTransform(J.X);
	repaint();
    }

    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	repaint();
    }

    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   



}

