import java.awt.*;
import java.math.*;



/**********************************************
        This file contains the vertices
        of the complex Z
*****************************************/

public class PiecesOfZ {



/*****the vectors.  These rely on the numerical
      values from the file NumericalValues.java*/


/* apply K k times.  Actually, the matrices
K3 and K3_inverse are used when k>3, to
improve accuracy*/

 public static IntervalComplexVector pos_shift(IntervalComplexVector v,int k)  {
   int i,k1,k2;
   IntervalMatrix m1=new IntervalMatrix();
   IntervalMatrix m2=new IntervalMatrix();
  IntervalComplexVector w=new IntervalComplexVector(v);
  k1=k/3;
  k2=k-3*k1;
  m1=NumericalValues.K3();
  m2=NumericalValues.K();
  w=v;
  for(i=1;i<=k1;++i) w=IntervalMatrix.apply(m1,w);
  for(i=1;i<=k2;++i) w=IntervalMatrix.apply(m2,w);
  return(w);
}
    


/* apply K_inverse k times.  Same remarks as above.*/

    

public static IntervalComplexVector neg_shift(IntervalComplexVector v,int k)
{
  int i,k1,k2;
  IntervalMatrix m1=new IntervalMatrix();
   IntervalMatrix m2=new IntervalMatrix();
   IntervalComplexVector w=new IntervalComplexVector(v);

   
  k1=k/3;
  k2=k-3*k1;
  m1=NumericalValues.K_minus3();
  m2=NumericalValues.K_inverse();
  for(i=1;i<=k1;++i) w=IntervalMatrix.apply(m1,w);
  for(i=1;i<=k2;++i) w=IntervalMatrix.apply(m2,w);
  return(w);
}





/* neg(k) is bullet(k) from the paper and
pos(k) is circ(k). These are the vectors
comprising the vertices of the complex Z.
Compare the chart notation in the paper. */

public static IntervalComplexVector neg(int k) 
{
    IntervalComplexVector v=new IntervalComplexVector();
    IntervalMatrix m1=new IntervalMatrix();
  int i;
  int kk;
  kk=k;
  if(k<0) kk=-k;
  if(kk%2==0) 
    {
    v=NumericalValues.neg_2();
    if(k>2) 	v=pos_shift(v,(k-2)/2);
    if(k<2)     v=neg_shift(v,(2-k)/2);
    }

  if(kk%2==1) 
    {
	v=NumericalValues.neg_7();
    if(k>7)  v=pos_shift(v,(k-7)/2);  
    if(k<7)  v=neg_shift(v,(7-k)/2);
    }

  /*the code*/
  v.X.l=1;
  v.X.a[1]=0;
  v.X.b[1]=1;
  v.X.c[1]=k;
  return(v);
}
    


public static IntervalComplexVector pos(int k) 
{
  IntervalComplexVector v=new IntervalComplexVector();
  IntervalMatrix m1=new IntervalMatrix();;
  int i;
  int kk;
  kk=k;
  if(k<0) kk=-k;
  if(kk%2==0) 
    {
    v=NumericalValues.pos_0();
    if(k>0) v=pos_shift(v,k/2);
    if(k<0) v=neg_shift(v,-k/2);
    }

    if(kk%2==1) 
      {
      v=NumericalValues.pos_5();
      if(k>5) v=pos_shift(v,(k-5)/2);
      if(k<5) v=neg_shift(v,(5-k)/2);
      }

    /*the code*/
    v.X.l=1;
    v.X.a[1]=0;
    v.X.b[1]=2;
    v.X.c[1]=k;
    return(v);
}
 






/******The odd B pieces.  There are 4 tetrahedra *****/

public static IntervalPoly B_odd1(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-2);
X.v[2]=neg(n+4);
X.v[3]=neg(n+3);
X.v[4]=neg(n+2);
X.l=4;
return(X);
}

public static IntervalPoly B_odd2(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-2);
X.v[2]=neg(n+4);
X.v[3]=neg(n+2);
X.v[4]=neg(n-0);
X.l=4;
return(X);
}

public static IntervalPoly B_odd3(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-2);
X.v[2]=neg(n+4);
X.v[3]=neg(n+0);
X.v[4]=neg(n-1);
X.l=4;
return(X);
}

public static IntervalPoly B_odd4(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-2);
X.v[2]=neg(n+4);
X.v[3]=neg(n-1);
X.v[4]=neg(n+3);
X.l=4;
return(X);
}








/*the even A pieces.  there are 7 tetrahedra
the first 3 are pure negative. The other 4 are mixed. */


public static IntervalPoly A_eve1(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-3);
X.v[2]=neg(n+3);
X.v[3]=neg(n-7);
X.v[4]=neg(n-2);
X.l=4;
return(X);
}


public static IntervalPoly A_eve2(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-3);
X.v[2]=neg(n+3);
X.v[3]=neg(n-2);
X.v[4]=neg(n+2);
X.l=4;
return(X);
}


public static IntervalPoly A_eve3(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-3);
X.v[2]=neg(n+3);
X.v[3]=neg(n+2);
X.v[4]=neg(n+7);
X.l=4;
return(X);
}

public static IntervalPoly A_eve4(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-3);
X.v[2]=neg(n+3);
X.v[3]=neg(n+7);
X.v[4]=pos(n+5);
X.l=4;
return(X);
}

public static IntervalPoly A_eve5(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;

X.v[1]=neg(n-3);
X.v[2]=neg(n+3);
X.v[3]=pos(n+5);
X.v[4]=pos(n+0);
X.l=4;
return(X);
}

public static IntervalPoly A_eve6(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-3);
X.v[2]=neg(n+3);
X.v[3]=pos(n+0);
X.v[4]=pos(n-5);
X.l=4;
return(X);
}

public static IntervalPoly A_eve7(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-3);
X.v[2]=neg(n+3);
X.v[4]=pos(n-5);
X.v[3]=neg(n-7);
X.l=4;
return(X);
}

/*the even B pieces.  there are 4 tetrahedra */

public static IntervalPoly B_eve1(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[4]=pos(n-8);
X.v[2]=pos(n+3);
X.v[3]=pos(n-3);
X.v[1]=neg(n-5);
X.l=4;
return(X);
}

public static IntervalPoly B_eve2(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n-5);
X.v[2]=neg(n+5);
X.v[3]=pos(n-3);
X.v[4]=pos(n+3);
X.l=4;
return(X);
}

public static IntervalPoly B_eve3(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[1]=neg(n+5);
X.v[2]=pos(n-3);
X.v[3]=pos(n+3);
X.v[4]=pos(n+8);
X.l=4;
return(X);
}







/*the odd A pieces. There are 2 tetrahedra ***/



public static IntervalPoly A_odd1(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[3]=pos(n-2);
X.v[2]=pos(n+4);
X.v[1]=neg(n+1);
X.v[4]=pos(n-7);
X.l=4;
return(X);
}

public static IntervalPoly A_odd2(int n)
{
IntervalPoly X=new IntervalPoly();
X.l=4;
X.v[3]=pos(n-2);
X.v[2]=pos(n+4);
  X.v[1]=neg(n+1);
X.v[4]=pos(n+9);
X.l=4;
return(X);
}



/*this function collects all the pieces into 1 unit*/
/*(group element,piece)*/
public static IntervalPoly tetra(int n,int k)
{
  IntervalPoly X=new IntervalPoly();
  
if(k==1)  X=B_odd1(2*n);
if(k==2)  X=B_odd2(2*n);
if(k==3)  X=B_odd3(2*n);
if(k==4)  X=B_odd4(2*n);

if(k==5)  X=A_eve1(2*n); 
if(k==6)  X=A_eve2(2*n);
if(k==7)  X=A_eve3(2*n);
if(k==8)  X=A_eve4(2*n);
if(k==9)  X=A_eve5(2*n);
if(k==10) X=A_eve6(2*n);
if(k==11) X=A_eve7(2*n);

if(k==12) X=B_eve1(2*n);
if(k==13) X=B_eve2(2*n);
if(k==14) X=B_eve3(2*n);

if(k==15) X=A_odd1(2*n);
if(k==16) X=A_odd2(2*n);
 
 return(X);
}



}

