import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


/**This is wrapper class for a list of points in the
   plane.  The main routine in this class is
   taking the convex hull of a finite set of points.
**/


public class PolygonWrapper {
    Complex[] z=new Complex[600];
    int count;

    /**Constructors**/
    public PolygonWrapper() {}

    public PolygonWrapper(PolygonWrapper P) {
	for(int i=0;i<P.count;++i) z[i]=new Complex(P.z[i]);
	count=P.count;
    }


    public PolygonWrapper(int cc,Complex[] zz) {
	this.count=cc;
	for(int i=0;i<cc;++i) {
             z[i]=new Complex(zz[i]);
	}
    }


    /**converting to a path*/

    public Path2D.Double toPath() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(z[0].x,z[0].y);
	for(int i=0;i<count;++i) {
	    gp.lineTo(z[i].x,z[i].y);
	}
	gp.closePath();
	return(gp);
    }

    public Path2D.Double toPathOpen() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(z[0].x,z[0].y);
	for(int i=0;i<count;++i) {
	    gp.lineTo(z[i].x,z[i].y);
	}
	return(gp);
    }


    /**printout**/

    public void print() {
	System.out.println("count "+count);
	for(int i=0;i<count;++i) z[i].print();
    }

}

