import java.awt.*;
import java.math.*;


/*these are the routines which generate the pseudorandom
linear projection C^3 --> C^3 called L_n.  See Ch. 10 of
the paper.  The notation here somewhat matches that
in the paper.*/


public class Projection {

public static double d(double r)
{
double s;
s=r-Math.floor(r);
s=2.0*s-1.0;
return(s);
}



public static IntervalComplex z(int p,int q,int n) {
    IntervalComplex zz=new IntervalComplex();
    double nn,pp,qq;
    nn=n;pp=p;qq=q;
    zz=new IntervalComplex(d(nn*Math.sqrt(pp)),d(nn*Math.sqrt(qq)));
    return(zz);
}



public static IntervalComplexVector L(int n,IntervalComplexVector v)
{
    IntervalComplexVector w=new IntervalComplexVector();
  w.a=IntervalComplex.plus(IntervalComplex.times(z(2,3,n),v.a),IntervalComplex.times(z(5,7,n),v.b));
  w.b=new IntervalComplex(0,0);
  w.c=v.c;
  return(w);
}


/*Take a segment in C3 and pseudorandomly project it into
  C2.  This makes an edge, in our terminology.*/

public static Edge create_edge(int n,IntervalComplexVector v,IntervalComplexVector w)
{
    IntervalComplexVector vv=new IntervalComplexVector(L(n,v));
    IntervalComplexVector ww=new IntervalComplexVector(L(n,w));
    Edge e= new Edge();
    e.s[1][1]=vv.a;
    e.s[1][2]=vv.c;
    e.s[2][1]=ww.a;
    e.s[2][2]=ww.c;
    return(e);
}
 


/*This creates and edge whose projectivization is
  a ray connecting the projectivized barycenter to
  infinity.*/

 public static Edge create_last_edge(int n,IntervalPoly P)
{
    IntervalComplexVector vv=new IntervalComplexVector();
    Edge e=new Edge();
    vv=PolyhedronOperations.barycenter(P);
    vv=L(n,vv);
    e.s[1][1]=vv.a;
    e.s[1][2]=vv.c;
    e.s[2][1]=new IntervalComplex(1.0,0.0);
    e.s[2][2]=new IntervalComplex(0.0,0.0);
  return(e);
}
 





public static Graph create_graph(int n,IntervalPoly P) {
    Graph G=new Graph();
    int i,j,count;
    count=1;
    for(i=1;i<=4;++i) {
	for(j=i+1;j<=4;++j)  {
             G.e[count]=create_edge(n,P.v[i],P.v[j]);
	     ++count;
	}
    }
    G.e[7]=create_last_edge(n,P);
    G.l=6;
    return(G);
}




/*This computes the number of intersections of
the last edge of G1 with three edges of 
G2.  It is only meaningful topologically when
the three edges in connection make a circuit.*/

public static int interior_test(Graph G1,Graph G2,int a,int b,int c) {
  int total,test;
  total=0;
   test=EdgeIntersection.generic_intersection_number(G1.e[7],G2.e[a]);
  if(test==-1) return(-1);
  total=total+test;
  test=EdgeIntersection.generic_intersection_number(G1.e[7],G2.e[b]);
  if(test==-1) return(-1);
  total=total+test;
  test=EdgeIntersection.generic_intersection_number(G1.e[7],G2.e[c]);
  if(test==-1) return(-1);
  total=total+test;
  return(total%2);
}




/*return of 1 indicates success */

public static int projection_test(int n,IntervalPoly P1,IntervalPoly P2)
{

  int test,i,j;  
  IntegerList L=new IntegerList();
  Graph G1=create_graph(n,P1);
  Graph G2=create_graph(n,P2);
  
  for(i=1;i<=6;++i) 
    {
      for(j=1;j<=6;++j)
	{ 
 	  test=EdgeIntersection.edge_projection_test(G1.e[i],G2.e[j]);
	  if(test<1) return(-1);
	}
    }
  
  /*the triples of numbers, 1,2,4. etc, label the
    circuits of G2.  Compare the remark following
    the previous routine.*/

  test=interior_test(G1,G2,1,2,4);
  if(test!=0) return(-1);
  test=interior_test(G1,G2,1,3,5);
  if(test!=0) return(-1);
  test=interior_test(G1,G2,4,5,6);
  if(test!=0) return(-1);
  test=interior_test(G1,G2,2,3,6);
  if(test!=0) return(-1);

  test=interior_test(G2,G1,1,2,4);
  if(test!=0) return(-1);
  test=interior_test(G2,G1,1,3,5);
  if(test!=0) return(-1);
  test=interior_test(G2,G1,4,5,6);
  if(test!=0) return(-1);
  test=interior_test(G2,G1,2,3,6);
  if(test!=0) return(-1);
  return(1);
}



    


public static int multiple_projection_test(IntervalPoly P1,IntervalPoly P2,int lim)
{
  int n;
   for(n=1;n<=lim;++n)
    {
      if(projection_test(n,P1,P2)==1) return(n);
    }
  return(-1);
}

}


