import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SelectCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    ListenSquare X0,X1,Y0,Y1;
    int[] PAIR=new int[2];
    ListenSquare[] SHIFT=new ListenSquare[9];
    ListenSquare[] SHIFT2=new ListenSquare[9];
    int[] TEST_DATA=new int[2];
    int SH=0;

     public SelectCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,200,100);
	 X0=new ListenSquare(0,30,30,0);
	 Y0=new ListenSquare(30,0,0,30);
	 X1=new ListenSquare(470,30,30,0);
	 Y1=new ListenSquare(30,470,0,30);
	 for(int i=0;i<9;++i) SHIFT[i]=new ListenSquare(32+30*i,2,26,26);
	 for(int i=0;i<9;++i) SHIFT2[i]=new ListenSquare(40+30*i,10,10,10);
	 PAIR[0]=1;
	 PAIR[1]=1;
	 TEST_DATA[0]=0;
	 TEST_DATA[1]=0;
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawTestData(g);
      drawPair(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(100,200,255));
        g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawControls(Graphics2D g) {
	X0.h=getHeight()-65;
	X0.render(g,new Color(100,120,140));
	X1.h=getHeight()-65;
	X1.x=getWidth()-32;
	X1.render(g,new Color(100,120,140));
	Y0.w=getWidth()-62;
	Y0.render(g,new Color(100,120,140));
	Y1.w=getWidth()-62;;
	Y1.y=getHeight()-35;
	Y1.render(g,new Color(100,120,140));
	
	Color COL[]={Color.white,Color.yellow,Color.orange,Color.red,new Color(80,100,120)};
	for(int i=0;i<9;++i) {
	    IntervalPoly[] P=getPair(PAIR[0],PAIR[1],i);
	    int match=PolyhedronOperations.numerical_match(P[0],P[1]);
	    SHIFT[i].render(g,COL[match]);
	}
	SHIFT2[SH].render(g,Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.setColor(Color.black);
	g.drawString("click in the grey rectangles",40,53);
	g.drawString("to increment the pair index",40,80);
	
    }

    public void drawTestData(Graphics2D g) {
	g.setFont(new Font("Helvetica",Font.PLAIN,30));
	g.setColor(Color.white);
	
	g.drawString("test used:",80,175);
	
	if(TEST_DATA[0]==1) {
	    Integer I=new Integer(TEST_DATA[1]);
	    g.drawString("projection "+I.toString(),80,210);
	}
	if(TEST_DATA[0]==2) {
	    g.drawString("edge smash ",80,210);
	}
	
	if(TEST_DATA[0]==3) {
            Integer I=new Integer(TEST_DATA[1]);
	    g.drawString("triple smash"+I.toString(),80,210);
	}
	
	if(TEST_DATA[0]==4) {
	    g.drawString("degenerate smash ",80,210);
	}
    }
    

    public static IntervalPoly[] getPair(int i,int j,int k) {
	IntervalPoly P1=PiecesOfZPrime.TETRA(i);
        IntervalPoly P2=PiecesOfZPrime.TETRA(j);
        for(int q=0;q<k;++q) {
            if(q%2==0) P1=PolyhedronOperations.negative_shift(P1);
            if(q%2==1) P2=PolyhedronOperations.positive_shift(P2);
	}
	IntervalPoly[] P={P1,P2};
	return P;
    }
    
    public void drawPair(Graphics2D g) {
	Path2D.Double p = new Path2D.Double();
        g.setFont(new Font("Helvetica",Font.PLAIN,40));
	Integer I=new Integer(PAIR[0]);
	g.setColor(new Color(50,100,255));
	g.drawString(I.toString(),80,140);
	I=new Integer(PAIR[1]);
	g.drawString(I.toString(),180,140);
	I=new Integer(SH);
	g.drawString(I.toString(),280,140);
	
	double d0=1.0*PAIR[0]/393;
	double d1=1.0*PAIR[1]/393;
	double x=(40)*(1-d0) + (getWidth()-40)*d0;
	double y=(40)*(1-d1) + (getHeight()-40)*d1;
	g.setStroke(new BasicStroke(8));
	p.moveTo(x,y);
	p.lineTo(x,y);
	g.setColor(Color.black);
	g.draw(p);
	g.setStroke(new BasicStroke(5));
	g.setColor(Color.white);
	g.draw(p);
    }


    public Path2D.Double getBox(int i,int j) {

	double d0=1.0*(i-.5)/393;
	double e0=1.0*(j-.5)/393;
	double x0=(40)*(1-d0) + (getWidth()-40)*d0;
	double y0=(40)*(1-e0) + (getHeight()-40)*e0;

	double d1=1.0*(i+.5)/393;
	double e1=1.0*(j+.5)/393;
	double x1=(40)*(1-d1) + (getWidth()-40)*d1;
	double y1=(40)*(1-e1) + (getHeight()-40)*e1;

	Path2D.Double p=new Path2D.Double();
	p.moveTo(d0,e0);
	p.lineTo(d0,e1);
	p.lineTo(d1,e1);
	p.lineTo(d1,e0);
	p.closePath();
	return p;
    }

    
    public void selectPair(Point X,int mode) {

	for(int i=0;i<9;++i) {
	    if(SHIFT[i].inside(X)==1) {
		SH=i;
		return;
	    }
	}
	boolean used=false;

	if(X0.inside(X)==1) {
	    --PAIR[0];
	    used=true;
	}
	if(Y0.inside(X)==1) {
	    --PAIR[1];
	    used=true;
	}

	if(X1.inside(X)==1) {
	    used=true;
	    ++PAIR[0];
	}
	if(Y1.inside(X)==1) {
	    used=true;
	    ++PAIR[1];
	}

	
	if(PAIR[0]<1) PAIR[0]=1;
	if(PAIR[1]<1) PAIR[1]=1;
	if(PAIR[0]>393) PAIR[0]=393;
	if(PAIR[1]>393) PAIR[1]=393;

	if(used==true) return;


    if(mode!=1) PAIR[0]=(int)(393*(X.x-40)/(getWidth()-80));
    if(mode!=3) PAIR[1]=(int)(393*(X.y-40)/(getHeight()-80));

		      
	if(PAIR[0]<1) PAIR[0]=1;
	if(PAIR[1]<1) PAIR[1]=1;
	if(PAIR[0]>393) PAIR[0]=393;
	if(PAIR[1]>393) PAIR[1]=393;
    }

    /**These routines let you see the disjointness algorithm in action.
       They are static routines and can be called even if the window is not open*/
    
    public static void sendToPicture(PictureCanvas X,int i,int j,int k) {
	IntervalPoly[] P=getPair(i,j,k);
	int m=PolyhedronOperations.numerical_match(P[0],P[1]);
	if(m<=1) sendToPicture1(X,P);
	if(m==2) sendToPicture2(X,P);
	if(m==3) sendToPicture3(X,P);
    }

    public static void sendToPicture1(PictureCanvas X,IntervalPoly[] P) {
	int choice=Projection.multiple_projection_test(P[0],P[1],100);
	X.G1=Projection.create_graph(choice,P[0]);
        X.G2=Projection.create_graph(choice,P[1]);
        X.repaint();
    }

    public static void sendToPicture2(PictureCanvas X,IntervalPoly[] P) {
	int choice=InjectivityTest.computational_kernal2(P[0],P[1]);
	if(choice>9999) {
	    int c=choice-10000;
	    X.G1=Projection.create_graph(c,P[0]);
            X.G2=Projection.create_graph(c,P[1]);
            X.repaint();
	    return;
	}
        X.G2=EdgeSmash.edge_smash_graph(P[1],P[0]);
        X.G1=EdgeSmash.edge_smash_graph(P[0],P[1]);
	X.repaint();
	return;
    }
    
    public static void sendToPicture3(PictureCanvas X,IntervalPoly[] P) {
	int choice=TripleSmash.triple_smash_test(P[0],P[1]);
        if(choice>0) {
   	   X.G2=TripleSmash.triple_smash_graph(1,choice,P[0],P[1]);
	   X.G1=TripleSmash.triple_smash_graph(2,choice,P[0],P[1]);
           X.repaint();
           return;
	}
           choice=DegenerateSmash.degenerate_triple_smash_test(P[0],P[1]);
	   if(choice>0) {
   	   X.G2=TripleSmash.triple_smash_graph(1,choice,P[0],P[1]);
	   X.G1=TripleSmash.triple_smash_graph(2,choice,P[0],P[1]);
           X.repaint();
           return;
	}
    }



    public  void getTestResults(int i,int j,int k) {
	IntervalPoly[] P=getPair(i,j,k);
	int m=PolyhedronOperations.numerical_match(P[0],P[1]);
	if(m<=1) getTestResults1(P);
	if(m==2) getTestResults2(P);
	if(m==3) getTestResults3(P);
    }

    public  void getTestResults1(IntervalPoly[] P) {
	int choice=Projection.multiple_projection_test(P[0],P[1],100);
	TEST_DATA[0]=1;
	TEST_DATA[1]=choice;
    }

    public  void getTestResults2(IntervalPoly[] P) {
	int choice=InjectivityTest.computational_kernal2(P[0],P[1]);
	if(choice>9999) {
	    int c=choice-10000;
            TEST_DATA[0]=1;
	    TEST_DATA[1]=c;
	    return;
	}
        TEST_DATA[0]=2;
	TEST_DATA[1]=0;
    }
    
    public  void getTestResults3(IntervalPoly[] P) {
	int choice=TripleSmash.triple_smash_test(P[0],P[1]);
        if(choice>0) {
          TEST_DATA[0]=3;
	  TEST_DATA[1]=choice;
           return;
	}
           choice=DegenerateSmash.degenerate_triple_smash_test(P[0],P[1]);
           TEST_DATA[0]=4;
	   TEST_DATA[1]=choice;
    }

    
    public void mousePressed(MouseEvent e) { }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
 	selectPair(J.X,J.mode);
    	sendToPicture(M.P,PAIR[0],PAIR[1],SH);
    	getTestResults(PAIR[0],PAIR[1],SH);
	doTest();
	repaint();
    }


    public void doTest() {
	for(int i=1;i<=393;++i) {
	    IntervalPoly P=PiecesOfZPrime.TETRA(i);
	    int k=PolyhedronOperations.type(P);
	    System.out.print(k+",");
	}
	System.out.println("");
    }

    public static int[] getType() {
	int[] t={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,0,1,2,1,0,1,2,1,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,4,4,4,3,2,3,4,2,1,2,3,3,2,3,4,2,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,4,4,4,3,2,3,4,2,1,2,3,3,2,3,4,2,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,0,1,2,1,0,1,2,1,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,0,1,2,2,1,2,3,2,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,1,0,1,2,1,0,1,2,1,0,1,2,1,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,0,1,2,2,1,2,3,2,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,0,1,2,2,1,2,3,2,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,1,0,1,2,2,1,2,3,2,1,2,3};
	return t;
    }

    
    
    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	selectPair(J.X,J.mode);
	sendToPicture(M.P,PAIR[0],PAIR[1],SH);
    	getTestResults(PAIR[0],PAIR[1],SH);
	repaint();
    }

    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   



}

