
/*This file contains the routines which test if the
faces of a simplex are pure.  The method is described
in Ch 10 of the paper.   No other files call
the routines in this file. */

public class SubdivisionTests {


public static IntervalPoly subdivide(int j,IntervalPoly P)
{
    IntervalPoly Q=new IntervalPoly();
    IntervalComplexVector v=new IntervalComplexVector();
    int i,k;
    k=P.l; 
    Q.v[1]=IntervalComplexVector.average(P.v[k-1],P.v[k]);
    Q.l=P.l;
    for(i=1;i<=k-1;++i) Q.v[1+i]=new IntervalComplexVector(P.v[i]);
    Q.v[k]=new IntervalComplexVector(P.v[k+j-2]);
    return(Q);
}



public static Interval radius2(int j,IntervalPoly P)
{
    IntervalComplexVector v=new IntervalComplexVector();
    Interval max=new Interval();
    Interval dist=new Interval();
    int i;
    v=PolyhedronOperations.barycenter(P);
    max=new Interval(0);
    for(i=1;i<=P.l;++i)  
	{
        if(j==1) dist=IntervalComplex.dist(v.a,P.v[i].a);
        if(j==2) dist=IntervalComplex.dist(v.b,P.v[i].b);
        if(j==3) dist=IntervalComplex.dist(v.c,P.v[i].c);
        if(max.r<dist.l) max=dist;
	}
return(max);
}
  


public static int negative_test(IntervalPoly P)
{
  Interval max1=new Interval();
  Interval max2=new Interval();
  Interval min3=new Interval();
  Interval pos=new Interval();
  Interval neg=new Interval();
  IntervalComplexVector v=new IntervalComplexVector();
  v=PolyhedronOperations.barycenter(P);
  max1=Interval.plus(IntervalComplex.norm(v.a),radius2(1,P));
  max2=Interval.plus(IntervalComplex.norm(v.b),radius2(2,P));
  min3=Interval.minus(IntervalComplex.norm(v.c),radius2(3,P));
  pos=Interval.plus(Interval.times(max1,max1),Interval.times(max2,max2));
  neg=Interval.times(min3,min3);
  if(pos.r<neg.l) return(1);
  return(0);
}

public static int positive_test(IntervalPoly P)
{
  Interval min1=new Interval();
  Interval min2=new Interval();
  Interval max3=new Interval();
  Interval pos=new Interval();
  Interval neg=new Interval();
  IntervalComplexVector v=new IntervalComplexVector();
  v=PolyhedronOperations.barycenter(P);
  min1=Interval.minus(IntervalComplex.norm(v.a),radius2(1,P));
  min2=Interval.minus(IntervalComplex.norm(v.b),radius2(2,P));
  max3=Interval.plus(IntervalComplex.norm(v.c),radius2(3,P));
  pos=Interval.plus(Interval.times(min1,min1),Interval.times(min2,min2));
  neg=Interval.times(max3,max3);
  if(pos.l>neg.r) return(1);
  return(0);
}


public static int negative_subdivision_test(IntervalPoly P)
{
    IntervalPoly[] X=new IntervalPoly[50];
    IntervalPoly Q=new IntervalPoly();
    int l=1;
    X[1]=new IntervalPoly(P);
  while(l>0)
   {
   int test=0;
   Q=new IntervalPoly(X[l]);
   test=negative_test(Q);
   if(test==1) --l;
   if(test==0)
     {
     X[l+0]=subdivide(1,Q);
     X[l+1]=subdivide(2,Q);
     ++l;
     }
   if(l>50) return(0);
   }
return(1);
}

    
public static int positive_subdivision_test(IntervalPoly P)
{
    IntervalPoly[] X=new IntervalPoly[50];
    IntervalPoly Q=new IntervalPoly();
    int l=1;
    X[1]=new IntervalPoly(P);
  while(l>0)
   {
   int test=0;
   Q=new IntervalPoly(X[l]);
   test=positive_test(Q);
   if(test==1) --l;
   if(test==0)
     {
     X[l+0]=subdivide(1,Q);
     X[l+1]=subdivide(2,Q);
     ++l;
     }
   if(l>50) return(0);
   }
return(1);
}




/*The routine first enumerates all the positive
and negative faces and then checks that each one
is pure.  This means that all vectors in a positive
face are positive and all vectors in a negative
face are negatice.  Here `positive face' is defined
as one whose vertices being positive.  Likewise
for `negative face'.  This test takes a half hour
or so to run, because some of the pure faces
come quite close to the null vector set.*/

public static int purity_test(IntervalPoly P)
{
    IntervalPoly Q1=new IntervalPoly();
    IntervalPoly Q2=new IntervalPoly();
    int count=0;
    int pos=0;
    int neg=0;
    
    IntervalComplex test=new IntervalComplex();
    count=0;
    for(int i=1;i<=4;++i)
	{
         test=IntervalComplexVector.hermitianDot(P.v[i],P.v[i]);
         if(test.x.r<0.0) {++count;Q1.v[count]=P.v[i];}
	}
    Q1.l=count;
    count=0;
   for(int i=1;i<=4;++i)
    {
     test=IntervalComplexVector.hermitianDot(P.v[i],P.v[i]);
     if(test.x.l>0.0) {++count;Q2.v[count]=P.v[i];}
    }
    Q2.l=count;
    if(Q1.l<2) neg=1;
    if(Q1.l>1) neg=negative_subdivision_test(Q1);
    if(Q2.l<2) pos=1;
    if(Q2.l>1) pos=positive_subdivision_test(Q2);
    if(pos*neg==1) return(1);
    return(-1);
}

    

/**these routines perform the tests to show that 
certain tetrahedra are contained in the affine patch
of C^(2,1).   The method is described in Ch 10 of the
paper.*/


public static int affine_test(IntervalPoly P)
{
    Interval min=new Interval();
IntervalComplexVector v=new IntervalComplexVector();
v=PolyhedronOperations.barycenter(P);
min=Interval.minus(IntervalComplex.norm(v.c),radius2(3,P));
if(min.l>0.0) return(1);
return(0);
}



public static int affine_subdivision_test(IntervalPoly P)
{
    IntervalPoly[] X=new IntervalPoly[30];
    IntervalPoly Q=new IntervalPoly();
    int test;
    int l=1;
    X[1]=P;
    while(l>0)
      {
      test=0;
      Q=new IntervalPoly(X[l]);
      test=affine_test(Q);
      if(test==1) --l;
      if(test==0)
	  {
	      X[l+0]=subdivide(1,Q);
	      X[l+1]=subdivide(2,Q);;
	      ++l;
	  }
          if(l>30) return(0);
      }
      return(1);
}


    





/*These routines take care of the computation at the end
of Ch 8.  Roughly, we check that the vectors from the 
third stage of our subdivision process are all positive
and the vectors from the first and second stages are 
negative.   The test is based on analyzing the code of
each vertex.   If the first digits of each triple in
the code are all "3" then the vector should be
positive.  If the first digits are all less than
3 than the vector should be negative.  We say nothing
about the vectors whose codes do not have this form.*/


public static int check_for_threes(IntervalComplexVector v) {
  int i,test;
  test=1;
  for(i=1;i<=v.X.l;++i)
    {
      if(v.X.a[i]<3) test=0;
    }
  return(test);
}


public static int check_for_sub_threes(IntervalComplexVector v) {
  int i,test;
  test=1;
  for(i=1;i<=v.X.l;++i)
    {
      if(v.X.a[i]==3) test=0;
    }
  return(test);
}


//return of 1 here means success

public static int vector_norm_consistent(IntervalComplexVector v) {
    IntervalComplex z=new IntervalComplex();
   int check1,check2;
  check1=check_for_threes(v);
  check2=check_for_sub_threes(v);
  if((check1==0)&&(check2==0)) return(1);
  z=IntervalComplexVector.hermitianDot(v,v);
  if(check1==1) 
    {
      if(z.x.l>0) return(1);
      return(0);
    }

 if(check2==1) 
    {
      if(z.x.r<0) return(1);
      return(0);
    }
 return(0); //shouldn't get to here
}

public static int poly_norm_consistent(IntervalPoly P)
{
  int i;
  for(i=1;i<=4;++i)
    {
      if(vector_norm_consistent(P.v[i])==0) return(0);
    }
  return(1);
}


    
}
