import java.awt.*;
import java.math.*;


public class Tests implements Runnable {
    ControlCanvas C;
    boolean HALT;


    public Tests() {
	HALT=true;
    }
    
    public Tests(ControlCanvas c) {
	C=c;
	HALT=true;
    }

    public void run() {
	int mode=C.TESTS.mode;
      	if(mode==0) test012(0);
	if(mode==1) test012(1);
	if(mode==2) test2();
	if(mode==3) test012(2);
	if(mode==4) injectivity();
       }

    

    /**Here is the norm consistency test*/

    public void test012(int mode)
{
  HALT=false;
  IntervalPoly P=new IntervalPoly();
  boolean fail=false;
  int test=0;
  if(mode==0) sendHeader("norm test running");
  if(mode==1) sendHeader("purity test running");
  if(mode==2) sendHeader("cutoff test running");

  int j=1;
  while(HALT==false) {
        delay(System.currentTimeMillis());
	P=PiecesOfZPrime.TETRA(j);
	if(mode==0) test=SubdivisionTests.poly_norm_consistent(P);
	if(mode==1) test=SubdivisionTests.purity_test(P);  
	if(mode==2) test=CutoffTest.main_test(P);  
        if(test==0) {
	    HALT=true;
	    fail=true;
	}
	else {
	    int[] X={j};
	   sendRunning(X);
	}
	if(j<393) ++j;
	else HALT=true;
  }
  
  sendResult(fail);
}



    public void test2() {
      HALT=false;
      boolean fail=false;
      int test=0;
      IntervalPoly P=new IntervalPoly();
  
      sendHeader("affine test running");
  
      test=1;
      int j=1;
       while(HALT==false) {
	   delay(System.currentTimeMillis());
	  P=PiecesOfZPrime.TETRA(j);
	  for(int k=1;k<=6;++k)
	    {
	     test=test*SubdivisionTests.affine_subdivision_test(P);
	     if(test==0) {
		 fail=true;
		 HALT=true;
	     }
             P=PolyhedronOperations.positive_shift(P);
	    }

	  P=PiecesOfZPrime.TETRA(j);
	  for(int k=1;k<=6;++k)
	    {
	     test=test*SubdivisionTests.affine_subdivision_test(P);
             if(test==0) {
		 fail=true;
		 HALT=true;
	     }
             P=PolyhedronOperations.negative_shift(P);
	    }
	  int[] X={j};
	  sendRunning(X);
	  if(j<393) ++j;
	  else HALT=true;
       }
       sendResult(fail);
    }


    /**here is the injectivity test.  At the same time we check that the way of
computing the number of common vertices is the same whether we use the integer codes
or whether we check the matching directly and numerically.*/

public void injectivity()
{
    HALT=false;
    int mode=1;
    boolean fail=false;

    int test=0;
    int max=0;
    int i=1;
    int j=1;
    sendHeader("injectivity test running");

    int[] c=new int[5]; c[4]=1;
    for(int ii=0;ii<4;++ii) c[ii]=C.FILTER.L[ii].on;


    
    while(HALT==false) {
      IntervalPoly P1=PiecesOfZPrime.TETRA(i); /*pick tetrahedron from 1st list*/
      IntervalPoly P2=PiecesOfZPrime.TETRA(j); /*pick tetrahedrom from 2nd list*/
      int k=0;
      while((HALT==false)&&(k<9)) {
              for(int ii=0;ii<4;++ii) c[ii]=C.FILTER.L[ii].on;
	      
	      int match=PolyhedronOperations.code_match(P1,P2);  /*# of common vertices*/
              int match2=PolyhedronOperations.numerical_match(P1,P2);
	      if(match!=match2) throw new ProofException("match fails");

	      test=1;
	      boolean filter=false;
	    
	      if(c[match]==1) {
		  delay(System.currentTimeMillis());
	         if(match==0) test=Projection.multiple_projection_test(P1,P2,100);
	         if(match==1) test=Projection.multiple_projection_test(P1,P2,100);
                 if(match==2) test=InjectivityTest.computational_kernal2(P1,P2);
	         if(match==3) test=InjectivityTest.computational_kernal3(P1,P2);
	         int[] X={i,j,k,match};
	     
	         sendRunning(X);
	         SelectCanvas.sendToPicture(C.M.P,i,j,k);
	  
	          try {
	             C.M.S.PAIR[0]=i;
	             C.M.S.PAIR[1]=j;
	             C.M.S.SH=k;
	             C.M.S.repaint();
		  }
		  catch(Exception e) {}
	      }
	      if(k%2==0) P1=PolyhedronOperations.negative_shift(P1);
	      if(k%2==1) P2=PolyhedronOperations.positive_shift(P2);

	      if(test==0) {
		  HALT=true;
		  fail=true;
	      }
              ++k;

	  }

      if(j<393) ++j;
      else {
	  if(i<393) {
	      j=1;
	      ++i;
	  }
	  else{HALT=true;
	  }
      }
      C.repaint();
    }
    sendResult(fail);
}


    public void sendHeader(String S) {
       C.MESSAGE[0]=S;
       C.MESSAGE[1]="";
       C.MESSAGE[2]="";
       C.repaint();
    }

    public void sendRunning(int[] X) {
	String S="";
	for(int i=0;i<X.length;++i) {
	  Integer J=new Integer(X[i]);
	  S=S+J.toString()+" ";
	}
	C.MESSAGE[1]=S;
	C.repaint();
    }

    public void sendResult(boolean fail) {
	if(fail==true) C.MESSAGE[2]="fail";
        if(fail==false) C.MESSAGE[2]="pass";
        C.repaint();
       C.repaint();
    }

    public void delay(long f) {
	int t=C.DELAY.val;
	if(t==0) return;
	long val=(long)(Math.pow(2,1.0*t/2));
	boolean test=false;
	while(test==false) {
	    long f2=System.currentTimeMillis();
	    f2=f2-f;
	    if(f2>val) test=true;
	}
    }

    
    
}





