import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class TilingCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Animator AN;
    ListenSquare GO,HALT;

     public TilingCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,200,100);
	 AN=new Animator();
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTiling(g);
      drawTilingPrime(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawTiling(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	int t=M.C.TILING.L[9].on;
	int r=M.C.TILING_RANGE.val;
	for(int i=8;i<=16;++i) {
	    for(int k=-r;k<=r;++k) {
		IntervalPoly P=PiecesOfZ.tetra(k,i);
     	        p=DrawTiling.poly_mixed_draw(0,P);
	        if(p!=null) {
	            p=transform(p);
		    int c=16*i;
		    if(c>255) c=255;
	            g.setColor(M.C.TILING.M[i-8].C);
	            g.fill(p);
		    if(t==1)   g.setColor(M.C.TILING.M[9].C);
	            g.draw(p);
	       }
	    }
	}
    }

    public void drawTilingPrime(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	int r=M.C.TILING_RANGE.val;
	int out=M.C.TILING.L[10].on;
	for(int i=1;i<=393;++i) {
	    int t=PiecesOfZPrime.getIndex(i);
	    if(i>=8) {
 		if(M.C.TILING.L[t-8].on==1) {
	          IntervalPoly P=PiecesOfZPrime.TETRA(i);
	          for(int k=-r;k<=r;++k) {
		    IntervalPoly Q=PolyhedronOperations.shift(k,P);
     	            p=DrawTiling.poly_mixed_draw(0,Q);
	            if(p!=null) {
	               p=transform(p);
		       g.setColor(M.C.TILING.M[t-8].C);
		       g.setColor(randomWhite());
		       g.fill(p);
	               if(out==1)   {
			   g.setColor(M.C.TILING.M[10].C);
	                   g.draw(p);
		       }
		    }
		  }
		}
	    }}
    }


    public Color randomWhite() {
	int k=M.C.SHADER.val*10;
	int d=(int)(k*Math.random());
	return new Color(255,255,255,d);
    }


    
    public void mousePressed(MouseEvent e) { }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
   	SOURCE=unTransform(J.X);
	repaint();
    }

    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	repaint();
    }

    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   



}

