import java.awt.*;
import java.math.*;

public class TripleSmash {

/*P1 and P2 are kept in the same order
  when both graphs are constructed during
  the test.  See the line labelled with an
  X in the routine below.  This routine 
  really does the same thing as the edge_smash_graph
  routine.

  order is between 1 and 2
  choice is 1,2,3 and determines the edge*/



    public static Graph triple_smash_graph(int order,int choice,IntervalPoly P1,IntervalPoly P2) {
      int a=0;
      int b=0;
      int c=0;
      int d=0;
      int count=0;
      IntegerList l=new IntegerList();
      Graph G=new Graph();
      Edge ee=new Edge();
      IntervalComplexVector v0=new IntervalComplexVector();
      IntervalComplexVector v1=new IntervalComplexVector();
      IntervalComplexVector v2=new IntervalComplexVector();
      IntervalComplexVector v3=new IntervalComplexVector();
      IntervalComplexVector v4=new IntervalComplexVector();
      IntervalComplexVector v5=new IntervalComplexVector();

  l=PolyhedronOperations.code_special_common_vertices(P1,P2); 
  if(choice==1)
    {
    a=l.n[3*order-2];
    b=l.n[3*order-1];
    }
  if(choice==2)
    {
    a=l.n[3*order-1];
    b=l.n[3*order-0];
    }
  if(choice==3)
    {
    a=l.n[3*order-0];
    b=l.n[3*order-2];
    }
  if(a*b==2)  {c=3;d=4;}
  if(a*b==3)  {c=2;d=4;}
  if(a*b==4)  {c=2;d=3;} 
  if(a*b==6)  {c=1;d=4;}
  if(a*b==8)  {c=1;d=3;}
  if(a*b==12) {c=1;d=2;}

  if(order==1)
    {
    v0=IntervalComplexVector.minus(P1.v[a],P1.v[b]);
    v1=IntervalComplexVector.hermitianCross(v0,P1.v[b]);
    v2=IntervalComplexVector.hermitianCross(v0,P1.v[c]);
    v3=IntervalComplexVector.hermitianCross(v0,P1.v[d]);
    }

  if(order==2)
    {
    v0=IntervalComplexVector.minus(P2.v[a],P2.v[b]);
    v1=IntervalComplexVector.hermitianCross(v0,P2.v[b]);
    v2=IntervalComplexVector.hermitianCross(v0,P2.v[c]);
    v3=IntervalComplexVector.hermitianCross(v0,P2.v[d]);
    }



   G.e[1]=Projection.create_edge(1,v1,v2);
   G.e[2]=Projection.create_edge(1,v2,v3);
   G.e[3]=Projection.create_edge(1,v3,v1);

 if(order==1)
  v4=IntervalComplexVector.plus(IntervalComplexVector.plus(P1.v[b],P1.v[c]),P1.v[d]);

 if(order==2)
  v4=IntervalComplexVector.plus(IntervalComplexVector.plus(P2.v[b],P2.v[c]),P2.v[d]);


  v5=IntervalComplexVector.hermitianCross(v0,v4);
  G.e[4]=Projection.create_edge(1,v5,v5);
  G.l=3;
  return(G);
}





    public static int choice_triple_smash_test(int choice,IntervalPoly P1,IntervalPoly P2) {
	Edge ee=new Edge();
        int test,i,j;
        Graph G1=triple_smash_graph(1,choice,P1,P2); 
        Graph G2=triple_smash_graph(2,choice,P1,P2); 

        for(i=1;i<=3;++i) {
	    for(j=3;j<=3;++j) {

	       test=EdgeIntersection.edge_projection_test(G1.e[i],G2.e[j]);
               if((test!=1)&&(test!=4)) return(-1);
	    }
	}
        ee=EdgeSmash.join_smash_barycenters(G1,G2);
        test=EdgeSmash.smash_interior_test(ee,G1);
        if(test!=1) return(-1);
        test=EdgeSmash.smash_interior_test(ee,G2);
        if(test!=1) return(-1);
        return(1);
    }


    public static int triple_smash_test(IntervalPoly P1,IntervalPoly P2) {
     int test;
     test=choice_triple_smash_test(1,P1,P2);
     if(test==1) return(1);
     test=choice_triple_smash_test(2,P1,P2);
     if(test==1) return(2);
     test=choice_triple_smash_test(3,P1,P2);
     if(test==1) return(3);
     return(-1);
    }

}
