
/*The routines in this file play a relatively
minor role in the paper.  For this reason,
the routines are rather lightly documented.*/


/*this routine defines the relevant
edges of our tiling.  Each edge is stored as
a vector.  The first coordinate is the first
endpoint;  the second coordinate is the second
endpoint; the third coordinate tells if the
edge is vertical, horizontal, or diagonal.
The routing tiling_draw lets you see the
edges defined*/

tiling ORB()
{
tiling Q;
int i,j;
Q.l=40;
/*******************frame*************/
Q.v[0].a=cxconvert(-30.0,-6.0);
Q.v[0].b=cxconvert(60.0,12.0);
Q.v[0].c=cxconvert(1.0,0.0); 
Q.v[1].a=cxconvert(0.0,0.0);
Q.v[1].b=cxconvert(60.0,12.0);
Q.v[1].c=cxconvert(1.0,0.0);
Q.v[2].a=cxconvert(0.0,0.0);
Q.v[2].b=cxconvert(-8.0,16.0);
Q.v[2].c=cxconvert(0.0,0.0);
Q.v[3].a=cxplus(Q.v[1].b,Q.v[2].a);
Q.v[3].b=cxplus(Q.v[1].b,Q.v[2].b);
Q.v[3].c=cxconvert(0.0,0.0);
Q.v[4].a=cxplus(Q.v[2].b,Q.v[0].a);
Q.v[4].b=cxplus(Q.v[2].b,Q.v[0].b);
Q.v[4].c=cxconvert(0.0,0.0);

/*********edges************************/

Q.v[5].a=cxconvert(-4.0,4.0);
Q.v[5].b=cxconvert(-4.0,12.0);
Q.v[5].c=cxconvert(2.0,0.0);
Q.v[6].a=cxconvert(4.0,4.0);
Q.v[6].b=cxconvert(4.0,12.0);
Q.v[6].c=cxconvert(2.0,0.0);
Q.v[7].a=cxconvert(-4.0,4.0);
Q.v[7].b=cxconvert(12.0,4.0);
Q.v[7].c=cxconvert(2.0,0.0);
Q.v[8].a=cxconvert(-12.0,12.0);
Q.v[8].b=cxconvert(4.0,12.0);
Q.v[8].c=cxconvert(1.0,0.0);
Q.v[9].a=cxconvert(12.0,4.0);
Q.v[9].b=cxconvert(16.0,8.0);
Q.v[9].c=cxconvert(2.0,0.0);
Q.v[10].a=cxconvert(4.0,12.0);
Q.v[10].b=cxconvert(8.0,16.0);
Q.v[10].c=cxconvert(1.0,0.0);
Q.v[11].a=cxconvert(4.0,20.0);
Q.v[11].b=cxconvert(8.0,16.0);
Q.v[11].c=cxconvert(1.0,0.0);
Q.v[12].a=cxconvert(12.0,4.0);
Q.v[12].b=cxconvert(16.0,0.0);
Q.v[12].c=cxconvert(1.0,0.0);
Q.v[13].a=cxconvert(-12.0,20.0);
Q.v[13].b=cxconvert(4.0,20.0);
Q.v[13].c=cxconvert(1.0,0.0);

/*the pattern repeats 3 times*/

for(i=0;i<=9;++i)
  {
  for(j=5;j<=25;j=j+9)
    {
    Q.v[j+9+i].a=cxplus(cxconvert(20.0,4.0),Q.v[j+i].a);
    Q.v[j+9+i].b=cxplus(cxconvert(20.0,4.0),Q.v[j+i].b);
    Q.v[j+9+i].c=Q.v[j+i].c;
    }
  }

return(Q);
}





/*This routine finds the bottom point of the
t-th fiber.  The point in question is a
convex combination of the endpoints of
the frame constructed in the previous routine */


complex initiate(t)
double t;
{
tiling Q;
complex z[10];
Q=ORB();
z[1]=cxconvert(1.0-t,0.0);
z[2]=cxconvert(t,0.0);
z[3]=Q.v[1].a;
z[4]=Q.v[1].b;
z[5]=cxplus(cxtimes(z[1],z[3]),cxtimes(z[2],z[4])); 
return(z[5]);
}






/*These routines tells where a fiber intersects a
  a given edge.  there are two routines because
  the foliation on our tiling has two kinds segments:
  vertical and diagonal.  The first one deals with the
  vertical segments and the second one deals with the
  diagonal ones*/


complex collide1(z,v)
complex z;
vector v;
{
complex w;
double s[10];
int test;
test=1;
if((z.x<v.a.x)&&(z.x<v.b.x)) test=0;
if((z.x>v.a.x)&&(z.x>v.b.x)) test=0;
 if(test==0) {w.x=0.0;w.y=50.0;return(w);}
s[1]=fabs(z.x-v.a.x);
s[2]=fabs(z.x-v.b.x);
s[3]=s[2]/(s[1]+s[2]);
s[4]=s[3]*v.a.y+(1.0-s[3])*v.b.y;
if(s[4]<z.y) {w.x=0.0;w.y=50.0;return(w);}
w.x=z.x;
w.y=s[4];
return(w);
}




complex collide2(zz,vv)
complex zz;
vector vv;
{
complex z,w,rot;
vector v;
double s[10];
int test;
test=1;
rot.x=cos(-Pi/4.0);
rot.y=sin(-Pi/4.0); 
 v.a=cxtimes(rot,vv.a);
 v.b=cxtimes(rot,vv.b);
 v.c=cxtimes(rot,vv.c);
z=cxtimes(rot,zz);
if((z.x<v.a.x)&&(z.x<v.b.x)) test=0;
if((z.x>v.a.x)&&(z.x>v.b.x)) test=0;
 if(test==0) {w.x=0.0;w.y=50.0;return(w);}
s[1]=fabs(z.x-v.a.x);
s[2]=fabs(z.x-v.b.x);
s[3]=s[2]/(s[1]+s[2]);
s[4]=s[3]*v.a.y+(1.0-s[3])*v.b.y;
if(s[4]<z.y) {w.x=0.0;w.y=50.0;return(w);}
w.x=z.x;
w.y=s[4];
w=cxdivide(w,rot);
return(w);
}


/*a spot is a spot on the tiling.  The integer
encodes the edge and the complex number encodes
the location on the tile.  Starting with a spot
on a fiber we loop through all edges, and determine
the spot which the fiber encounters next, as
it travels upwards through the tiling. */

spot succ(s)
spot s;
{
spot ss;
tiling Q;
double choice;
int i;
complex z;
Q=ORB();
ss.z=s.z;
ss.z.y=100.0;
ss.n=0;
/*here we tell the type of the edge and hence
  the type of the foliation line*/
choice=Q.v[s.n].c.x;
/*loop through the edges*/
for(i=5;i<=Q.l;++i)
  {
  if(choice<1.5)  z=collide1(s.z,Q.v[i]); 
  if(choice>1.5)  z=collide2(s.z,Q.v[i]);
  if((i!=s.n)&&(z.y<ss.z.y))
    {
    ss.z=z;
    ss.n=i;
    }
  }
return(ss);
}



/*This routine computes the position of a
point relative to the top edge of the
frame of the tiling.*/


double rise(z)
complex z;
{
tiling Q;
complex w[6];
Q=ORB();
w[1]=Q.v[1].b;
w[2]=Q.v[2].b;
w[3]=cxdivide(w[2],w[1]);
w[4]=cxdivide(z,w[1]);
return(w[4].y/w[3].y);
}


/*At first, our pictures are drawn on an 
abstract circle.  This routine embeds the circle
into R^3 and then projects back into the plane.
The variable d1 just determines the
width of the circle in R^3.  The variable
d2 is the important one.*/

complex re_embed(d1,d2)
double d1,d2;
{
complex z;
z.x=3.0+2.0*d1*cos(2.0*Pi*d2);
z.y=2.0*d1*sin(2.0*Pi*d2);
return(z);
}


/*This routine computes the triple of points
where a fiber slices the braid.   This triple is
really given as a triple of reals (encoded as
a vector.  The routine triple2 below re-embeds
this triple into the plane, so as to get an
actual picture.*/

vector triple1(t,phase,twist)
double t;
double phase;
int twist;
{
spot S[5];
int i;
vector v;
double d[15];
S[1].z=initiate(t);
S[1].n=1;
for(i=2;i<=4;++i)
  {
  S[i]=succ(S[i-1]); 
  d[i-1]=rise(S[i].z);
  }
d[4]=1.0+d[1];
for(i=1;i<=3;++i)
  {
  d[4+i]=d[1+i]-d[i];
  d[7+i]=.5*(d[1+i]+d[i]);
  }

  d[8]=phase+d[8]+twist*t;
  d[9]=phase+d[9]+twist*t;
  d[10]=phase+d[10]+twist*t;

v.a=re_embed(d[5],d[8]);
v.b=re_embed(d[6],d[9]);
v.c=re_embed(d[7],d[10]);
return(v);
}



/*This routine stores the triple of
points obtained by slicing our braid
by a single fiber.  */

plainpoly triple2(t,phase,twist)
double t;
double phase;
  int twist;
{
vector v;
complex z;
plainpoly P;
v=triple1(t,phase,twist);
P.v[1].a=re_embed(v.a.x,t);
P.v[1].b=cxconvert(v.a.y,0.0);
P.v[1].c=P.v[1].b;
P.v[2].a=re_embed(v.b.x,t);
P.v[2].b=cxconvert(v.b.y,0.0);
P.v[2].c=P.v[2].b;
P.v[3].a=re_embed(v.c.x,t);
P.v[3].b=cxconvert(v.c.y,0.0);
P.v[3].c=P.v[3].b;
P.l=3;
return(P);
}



/*This routine lets you plot the edges
defined in the routine ORB.  In this way,
you can see that the picture matches the
one shown in Ch 5.5.  Not all edges of the 
tiling appear; only the ones which are relevant
to our calculation.*/

tiling_draw(color,file,T)
int color;
FILE *file;
tiling T;
{
int i;
for(i=1;i<=T.l;++i)
  {
  edge_write(color,file,T.v[i]);
  }
}




/*e is the tolerance.  This routine tells which
  strand of the braid lies over which other strand,
  and blocks out the strands which lie underneath.
  The tolerance tells how much of the lower
  strands to block out.*/


int blocked(P,n,e)
plainpoly P;
int n;
double e;
{
int i,test;
double d[5];
test=1;
for(i=1;i<=P.l;++i)
  {
  d[1]=cxnorm(cxminus(P.v[n].a,P.v[i].a));
  d[2]=P.v[n].b.x-P.v[i].b.x;
  if((i!=n)&&(d[1]<e)&&(d[2]<0.0)) test=0;
  }
return(test);
}


/*This routine draws a slice of the braid
  corresponding to a single fiber.*/

braid_fiber_draw(file,P)
FILE *file;
plainpoly P;
{
int test;
int j;
for(j=1;j<=P.l;++j)
  {
  test=blocked(P,j,.20);
  if(test==1)  point_write(j,file,P.v[j].a);
  }
}



/*This routine samples 1000 fibers*/

braid_draw(name,phase,twist)
     double phase;
     int twist;
     FILE *name;
{
  int i;
  double t;
  for(i=1;i<=1000;++i) 
   {
     t=i;
     t=t/1000.0;
     braid_fiber_draw(name,triple2(t,phase,twist));
   }
}
