
/*********************************
   This file contains the
   basic algebraic manipulations
   between our structures
*********************************/





/*******************************
    complex numbers
*******************************/


/*converts from two doubles to a complex interval.
Here a complex interval is like a complex number,
but where the components are intervals rather than
doubles */

interval_complex cx_convert(x,y)
double x,y;
{
interval_complex z;
z.x=double_to_interval(x);
z.y=double_to_interval(y);
return(z);
}


interval_complex cx_plus(p,q)
interval_complex p,q;
{
interval_complex r;
r.x=plus(p.x,q.x);
r.y=plus(p.y,q.y);
return(r);
}

interval_complex cx_minus(p,q)
interval_complex p,q;
{
interval_complex r;
 r.x=minus(p.x,q.x);
 r.y=minus(p.y,q.y);
return(r);
}

interval_complex cx_times(p,q)
interval_complex p,q;
{
interval_complex r;
r.x=minus(times(p.x,q.x),times(p.y,q.y));
r.y=plus(times(p.x,q.y),times(p.y,q.x));
return(r);
}

interval_complex cx_inverse(z)
interval_complex z;
{
interval_complex w;
interval n;
n=plus(times(z.x,z.x),times(z.y,z.y));
w.x=divide(z.x,n);
w.y=divide(minus(ZERO(),z.y),n);
return(w);
}


interval_complex cx_divide(p,q)
interval_complex p,q;
{
interval_complex r;
r=cx_times(p,cx_inverse(q));
return(r);
}

interval_complex cx_conjugate(z)
interval_complex z;
{
interval_complex w;
w.x= z.x;
w.y=minus(ZERO(),z.y);
return(w);
}


interval cx_norm(z)
interval_complex z;
{
interval_complex w;
interval d;
w=cx_times(z,cx_conjugate(z));
d=w.x;
d=sq_root(d);
return(d);
}


interval cx_dist(z,w)
     interval_complex z,w;
{
  return(cx_norm(cx_minus(z,w)));
}




interval_vector vec_r(E)
interval_vector E;
{
interval_vector F;
F.a=E.c;
F.b=E.b;
F.c=E.a;
return(F);
}


interval_vector vec_inverse(E)
interval_vector E;
{
interval_vector F;
F.a=cx_inverse(E.a);
F.b=cx_inverse(E.b);
F.c=cx_inverse(E.c);
return(F);
}




interval_complex hermitian_dot(v,w)
interval_vector v,w;
{
interval_complex c1,c2,c3,c;
c1=cx_times(v.a,cx_conjugate(w.a));
c2=cx_times(v.b,cx_conjugate(w.b));
c3=cx_times(v.c,cx_conjugate(w.c));
c=cx_minus(cx_plus(c1,c2),c3);
return(c);
}


/*Hermitian lorenz cross product on C3*/
interval_vector hermitian_cross(v,w)
interval_vector v,w;
{
interval_vector x;
x.a=cx_minus(cx_times(v.b,w.c),cx_times(v.c,w.b));
x.b=cx_minus(cx_times(v.c,w.a),cx_times(v.a,w.c));
x.c=cx_minus(cx_times(v.b,w.a),cx_times(v.a,w.b));
x.a=cx_conjugate(x.a);
x.b=cx_conjugate(x.b);
x.c=cx_conjugate(x.c);
return(x);
}



interval_vector vec_cross(v,w)
interval_vector v,w;
{
interval_vector x;
x.a=cx_minus(cx_times(v.b,w.c),cx_times(v.c,w.b));
x.b=cx_minus(cx_times(v.c,w.a),cx_times(v.a,w.c));
x.c=cx_minus(cx_times(v.a,w.b),cx_times(v.b,w.a));
return(x);
}



interval_vector vec_plus(v,w)
interval_vector v,w;
{
interval_vector x;
x.a=cx_plus(v.a,w.a);
x.b=cx_plus(v.b,w.b);
x.c=cx_plus(v.c,w.c);
return(x);
}



interval_vector vec_minus(v,w)
interval_vector v,w;
{
interval_vector x;
x.a=cx_minus(v.a,w.a);
x.b=cx_minus(v.b,w.b);
x.c=cx_minus(v.c,w.c);
return(x);
}


interval_vector vec_scale(a,v)
interval_complex a;
interval_vector v;
{
interval_vector w;
w.a=cx_times(a,v.a);
w.b=cx_times(a,v.b);
w.c=cx_times(a,v.c);
return(w);
}



interval_vector vec_average(v,w)
interval_vector v,w;
{
interval_vector x;
interval_complex half;
half=cx_convert(0.5,0.0);
x.a=cx_plus(v.a,w.a);
x.b=cx_plus(v.b,w.b);
x.c=cx_plus(v.c,w.c);
x=vec_scale(half,x);
return(x);
}





interval_vector origin()
{
interval_vector v;
v.a=cx_convert(0.0,0.0);
v.b=cx_convert(0.0,0.0);
v.c=cx_convert(0.0,0.0);
return(v);
}




interval vec_dist(v,w)
     interval_vector v,w;
{
  interval d[5];
  int i;
  d[1]=cx_dist(v.a,w.a);
  d[2]=cx_dist(v.b,w.b);
  d[3]=cx_dist(v.c,w.c);
  d[4]=ZERO();
  for(i=1;i<=4;++i)
    {
      d[4]=plus(d[4],times(d[i],d[i]));
    }
  d[4]=sq_root(d[4]);
  return(d[4]);
}




interval_complex dot(v,w)
interval_vector v,w;
{
interval_complex d;
d=cx_plus(cx_plus(cx_times(v.a,w.a),cx_times(v.b,w.b)),cx_times(v.c,w.c));
return(d);
}



interval_vector apply(m,v)
interval_matrix m;
interval_vector v;
{
interval_vector w;
w.a=dot(m.a,v);
w.b=dot(m.b,v);
w.c=dot(m.c,v);
return(w);
}
