
/*
These are the main tests for the paper.
*/


/***********************************************
Here are the computational kernals.  There are
4 of them, depending on the number of common vertices.
When the number of common vertices is 2 or 3, the
return distinguishes between passing the usual
test, or passing the degenerate version. In
all cases, 0=fail and 1=pass and 2=degenerate pass
********************************************/


/* 0 vertices in common*/
int computational_kernal0(P1,P2)
     poly P1,P2;
{
  int test;
  /*this test takes the longest to run, but is
  also the most obvious.   If you want to
  run a quicker test, bypassing this case,
  just uncomment the following command */
  /*return(1);*/
  test=multiple_projection_test(P1,P2,10000);
  if(test>=1) return(1);
  return(0);
}



/* 1 vertex in common*/
int computational_kernal1(P1,P2)
     poly P1,P2;
{
  int test;
  test=multiple_projection_test(P1,P2,10000);
  if(test>=1) return(1);
  return(0);
}



/* 2 vertices in common*/
int computational_kernal2(P1,P2)
     poly P1,P2;
{
  int test;
  test=edge_smash_test(P1,P2);
  if(test==1) return(1);
  test=multiple_projection_test(P1,P2,10000);
  if(test>=1) return(1);
  test=degenerate_edge_smash_test(P1,P2);
  if(test==1) return(2);
  return(0);
}



/* 3 vertices in common*/
int computational_kernal3(P1,P2)
     poly P1,P2;
{
  int test;
  test=triple_smash_test(P1,P2);
  if(test>=1) return(1);
  test=degenerate_triple_smash_test(P1,P2);
  if(test>=1) return(2);
  return(0);
}






/************************************************
Here is the main test.  The basic idea of the
test is that it lists out all the pairs of 
tetrahedra and, for each pair, does the following:
1. compute the number of common vertices
2. apply the corresponding disjointness test
3. keep a running tally of the pairs which pass
4. write the degenerate cases to auxilliary files. 
The mode parameter determines if a running tally
is printed out.  Without the tally, the test does
nothing visible for 12 hours and then returns a 1.
***************************************************/

int injectivity_test(mode)
     int mode;   /*mode=1 prints the running total*/
{
  poly_list X1,X2;
  poly P1,P2;
  FILE *out1,*out2,*fopen();
  int a,b,i,j,k,kk,test,match;
  int pass[5],deg[5];

  /*output files*/
  out1=fopen("degenerate_list1","w");
  out2=fopen("degenerate_list2","w");

  /*set the counters equal to 0*/
  for(i=0;i<=3;++i) 
    {
      pass[i]=0;
      deg[i]=0;
    }

  /*the main loop*/
  for(a=1;a<=2;++a) 
    {
      for(b=1;b<=2;++b)  
	{
        X1=TETRA(a); /*pick first list of tetrahedra*/
        X2=TETRA(b); /*pick second list of tetrahedra*/
        for(i=1;i<=X1.l;++i)
	  {
          for(j=1;j<=X2.l;++j)
	    {
	      P1=X1.P[i]; /*pick tetrahedron from 1st list*/
	      P2=X2.P[j]; /*pick tetrahedrom from 2nd list*/

            for(k=0;k<=8;++k)
	      {
		match=code_match(P1,P2);  /*# of common vertices*/

	      if(match==0) 
		{
                test=computational_kernal0(P1,P2);
		if(test==1) ++pass[0];
		}

	      if(match==1) 
		{
                test=computational_kernal1(P1,P2);
		if(test==1) ++pass[1];
		}

	      if(match==2) 
		{
		  test=computational_kernal2(P1,P2);
		  if(test==1) ++pass[2];
		  if(test==2)
		    {
		      ++pass[2];
		      ++deg[2];
		      fprintf(out1,"%d %d %d %d %d\n",a,i,k,j,b);
		    }
		}


	      if(match==3) 
		{
		  test=computational_kernal3(P1,P2);
		  if(test==1) ++pass[3];
		  if(test==2)
		    {
		      ++pass[3];
		      ++deg[3];
		      fprintf(out2,"%d %d %d %d %d\n",a,i,k,j,b);
		    }
		}

	      /*shift the polyhedra, according to the parity of k*/
	      kk=k%2;
              if(kk==0) P1=negative_shift(P1);
              if(kk==1) P2=positive_shift(P2);

	      /*print out running total*/
	      if(mode==1) 
		{
                 printf("%d %d %d %d %d: ",a,i,k,j,b);
		 printf("(0) %d  (1) %d  (2) %d %d  (3) %d %d \n",
			pass[0],pass[1],pass[2],deg[2],pass[3],deg[3]);
		}
	      if((match<4)&(test==0)) return(0);
	      }
	    }
	  }
	}
    }
  return(1);
}



