
/*This file contains the routines which test if the
faces of a simplex are pure.  The method is described
in Ch 10 of the paper.   No other files call
the routines in this file. */




poly subdivide(j,P)
int j;
poly P;
{
poly Q;
interval_vector v;
int i,k;
 k=P.l; 
v=vec_average(P.v[k-1],P.v[k]);
Q.v[1]=v;
Q.l=P.l;
for(i=1;i<=k-1;++i) Q.v[1+i]=P.v[i];
Q.v[k]=P.v[k+j-2];
return(Q);
}



interval radius2(j,P)
int j;
poly P;
{
interval_vector v;
interval max,dist;
int i;
v=barycenter(P);
max=ZERO();
for(i=1;i<=P.l;++i)  
  {
  if(j==1) dist=cx_dist(v.a,P.v[i].a);
  if(j==2) dist=cx_dist(v.b,P.v[i].b);
  if(j==3) dist=cx_dist(v.c,P.v[i].c);
  if(max.r<dist.l) max=dist;
  }
return(max);
}
  


int negative_test(P)
poly P;
{
interval max1,max2,min3,pos,neg;
interval_vector v;
v=barycenter(P);
max1=plus(cx_norm(v.a),radius2(1,P));
max2=plus(cx_norm(v.b),radius2(2,P));
min3=minus(cx_norm(v.c),radius2(3,P));
pos=plus(times(max1,max1),times(max2,max2));
neg=times(min3,min3);
if(pos.r<neg.l) return(1);
return(0);
}



int positive_test(P)
poly P;
{
interval min1,min2,max3,pos,neg;
interval_vector v;
v=barycenter(P);
min1=minus(cx_norm(v.a),radius2(1,P));
min2=minus(cx_norm(v.b),radius2(2,P));
max3=plus(cx_norm(v.c),radius2(3,P));
pos=plus(times(min1,min1),times(min2,min2));
neg=times(max3,max3);
if(pos.l>neg.r) return(1);
return(0);
}






int negative_subdivision_test(P)
poly P;
{
poly_list X;
poly Q;
int test;
X.l=1;
X.P[1]=P;
while(X.l>0)
   {
   test=0;
   Q=X.P[X.l];
   test=negative_test(Q);
   if(test==1) --X.l;
   if(test==0)
     {
     X.P[X.l+0]=subdivide(1,Q);
     X.P[X.l+1]=subdivide(2,Q);
     ++X.l;
     }
   if(X.l>50) return(0);
   }
return(1);
}


int positive_subdivision_test(P)
poly P;
{
poly_list X;
poly Q;
int test;
X.l=1;
X.P[1]=P;
while(X.l>0)
   {
   test=0;
   Q=X.P[X.l];
   test=positive_test(Q);
   if(test==1)  --X.l;
   if(test==0)
     {
     X.P[X.l+0]=subdivide(1,Q);
     X.P[X.l+1]=subdivide(2,Q);
     ++X.l;
     }
   if(X.l>50) return(0);
   }
return(1);
}



/*The routine first enumerates all the positive
and negative faces and then checks that each one
is pure.  This means that all vectors in a positive
face are positive and all vectors in a negative
face are negatice.  Here `positive face' is defined
as one whose vertices being positive.  Likewise
for `negative face'.  This test takes a half hour
or so to run, because some of the pure faces
come quite close to the null vector set.*/

int purity_test(P)
poly P;
{
poly Q1,Q2;
int i,count,neg,pos;
interval_complex test;
count=0;
for(i=1;i<=4;++i)
  {
  test=hermitian_dot(P.v[i],P.v[i]);
  if(test.x.r<0.0) {++count;Q1.v[count]=P.v[i];}
  }
Q1.l=count;
count=0;
for(i=1;i<=4;++i)
  {
  test=hermitian_dot(P.v[i],P.v[i]);
  if(test.x.l>0.0) {++count;Q2.v[count]=P.v[i];}
  }
Q2.l=count;
if(Q1.l<2) neg=1;
if(Q1.l>1) neg=negative_subdivision_test(Q1);
if(Q2.l<2) pos=1;
if(Q2.l>1) pos=positive_subdivision_test(Q2);

if(pos*neg==1) return(1);
return(-1);
}





/*This routine just applies the previous routine to
  a whole bunch of tetrahedra.*/

 
int final_purity_test(mode)
     int mode;
{
  int i,j,test;
  poly_list X;
  test=1;
  for(i=1;i<=2;++i)
    {
      X=TETRA(i);
      for(j=1;j<=X.l;++j)
	{
	  test=purity_test(X.P[j]);  
	  if(test==-1) return(0);
	  if(mode==1) printf("purity test: %d %d:  %d\n",i,j,test);
	}
    }
  return(1);
}






/**these routines perform the tests to show that 
certain tetrahedra are contained in the affine patch
of C^(2,1).   The method is described in Ch 10 of the
paper.*/



int affine_test(P)
poly P;
{
interval min;
interval_vector v;
v=barycenter(P);
min=minus(cx_norm(v.c),radius2(3,P));
if(min.l>0.0) return(1);
return(0);
}



int affine_subdivision_test(P)
poly P;
{
poly_list X;
poly Q;
int test;
X.l=1;
X.P[1]=P;
while(X.l>0)
   {
   test=0;
   Q=X.P[X.l];
   test=affine_test(Q);
   if(test==1) --X.l;
   if(test==0)
     {
     X.P[X.l+0]=subdivide(1,Q);
     X.P[X.l+1]=subdivide(2,Q);
     ++X.l;
     }
   if(X.l>50) return(0);
   }
return(1);
}




/*return of 1 indicates success.  Actually, the
test halts if a failure is encountered.  No
failure is encountered when the test is run.*/
 
int final_affine_test(mode)
     int mode;
{
  int i,j,k,test;
  poly_list X;
  poly P;
  test=1;
  for(i=1;i<=2;++i)
    {
      X=TETRA(i);
      for(j=1;j<=X.l;++j)
	{
	  P=X.P[j];
	  for(k=1;k<=6;++k)
	    {
	     test=test*affine_subdivision_test(P);
	     if(mode==1) printf("affine test: %d %d %d:  %d\n",i,j,k,test); 
	     if(test==0) return(0);
             P=positive_shift(P);
	    } 
          P=X.P[j];
	  for(k=1;k<=6;++k)
	    {
	     test=test*affine_subdivision_test(P);
	     if(mode==1) printf("%d %d %d:  %d\n",i,j,-k,test); 
	     if(test==0) return(0);
             P=negative_shift(P);
	    }
	}
    }
  return(1);
}



/*These routines take care of the computation at the end
of Ch 8.  Roughly, we check that the vectors from the 
third stage of our subdivision process are all positive
and the vectors from the first and second stages are 
negative.   The test is based on analyzing the code of
each vertex.   If the first digits of each triple in
the code are all "3" then the vector should be
positive.  If the first digits are all less than
3 than the vector should be negative.  We say nothing
about the vectors whose codes do not have this form.*/


int check_for_threes(v)
     interval_vector v;
{
  int i,test;
  test=1;
  for(i=1;i<=v.X.l;++i)
    {
      if(v.X.a[i]<3) test=0;
    }
  return(test);
}



int check_for_sub_threes(v)
     interval_vector v;
{
  int i,test;
  test=1;
  for(i=1;i<=v.X.l;++i)
    {
      if(v.X.a[i]==3) test=0;
    }
  return(test);
}



//return of 1 here means success

int vector_norm_consistent(v)
     interval_vector v;
{
  interval_complex z;
  int check1,check2;
  check1=check_for_threes(v);
  check2=check_for_sub_threes(v);
  if((check1==0)&&(check2==0)) return(1);
  z=hermitian_dot(v,v);
  if(check1==1) 
    {
      if(z.x.l>0) return(1);
      return(0);
    }

 if(check2==1) 
    {
      if(z.x.r<0) return(1);
      return(0);
    }
 return(0); //shouldn't get to here
}


int poly_norm_consistent(P)
     poly P;
{
  int i;
  for(i=1;i<=4;++i)
    {
      if(vector_norm_consistent(P.v[i])==0) return(0);
    }
  return(1);
}




int final_norm_consistent_test(mode)
     int mode;
{
  
  int i,j,test;
  
  poly_list X;
  
  test=1;
  
  for(i=1;i<=2;++i)
    {
      
      X=TETRA(i);

  printf("running6 \n");
      
      for(j=1;j<=X.l;++j)

  printf("running7 \n");
	
	{

  printf("running8 \n");
	  
	  test=poly_norm_consistent(X.P[j]);

  printf("running9 \n");
	  
	  if(test==0) return(0);

  printf("running10 \n");
	  
	  if(mode==1) printf("consistency test: %d %d:  %d\n",i,j,test);

  printf("running11 \n");
	  
	}
    }


  printf("running12 \n");
  
  return(1);
}
