

/*the routines in this file are only used
for plotting purposes.  They mirror some
of the functions in Computations/algebra.c.*/


double arg(z)
complex z;
{
double d;
 double atan2();
d=atan2(z.y,z.x);
if(z.y<0.0)
   d=d+2.0*+Pi;
return(d);
}

guided_arg(j,z)
     int j;
     complex z;
{
double d;
 double atan2();
d=atan2(z.y,z.x);
if(z.y<0.0)   d=d+2.0*+Pi;
 if((j==0)&&(d<-Pi)) d=d+2*Pi;
 if((j==1)&&(d<Pi)) d=d+2*Pi;
return(d);
}


double new_atan(x,y)
double x,y;
{
double p;
double atan2();
p=atan2(y,x);
if (p<0) p=p+2*Pi;
return(p);
}





/*euclidean norm function*/
double dist(z1,z2)
     complex z1,z2;
{
  double d;
  d=(z1.x-z2.x)*(z1.x-z2.x);
  d=d+(z1.y-z2.y)*(z1.y-z2.y);
  return(d);
}


complex cxconvert(r,s)
     double r,s;
{
  complex z;
  z.x=r;
  z.y=s;
  return(z);
}


/*basic arithmetic functions*/

complex cxtimes(z,w)
     complex z,w;
{
  complex y;
  y.x=z.x*w.x-z.y*w.y;
  y.y=z.x*w.y+z.y*w.x;
  return(y);
}

complex cxplus(z,w)
     complex z,w;
{
  complex y;
  y.x=z.x+w.x;
  y.y=z.y+w.y;
  return(y);
}

complex cxminus(z,w)
     complex z,w;
{
  complex y;
  y.x=z.x-w.x;
  y.y=z.y-w.y;
  return(y);
}


complex cxinverse(z)
complex z;
{
complex w;
w.x= z.x/(z.x*z.x+z.y*z.y);
w.y=-z.y/(z.x*z.x+z.y*z.y);
return(w);
}


complex cxdivide(p,q)
complex p,q;
{
complex r;
r=cxtimes(p,cxinverse(q));
return(r);
}

complex cxconjugate(z)
complex z;
{
complex w;
w.x= z.x;
w.y=-z.y;
return(w);
}



double cxnorm(z)
complex z;
{
complex w;
double d, sqrt();
w=cxtimes(z,cxconjugate(z));
d=w.x;
d=sqrt(d);
return(d);
}





/**converting to and from intervals**/

interval_vector plain_to_interval(v)
     vector(v);
{
  interval_vector w;
  w.a=cx_convert(v.a.x,v.a.y);
  w.b=cx_convert(v.b.x,v.b.y);
  w.c=cx_convert(v.c.x,v.c.y);
  return(w);
}

vector interval_to_plain(v)
     interval_vector(v);
{
  vector w;
  w.a.x=v.a.x.l;
  w.a.y=v.a.y.l;
  w.b.x=v.b.x.l;
  w.b.y=v.b.y.l;
  w.c.x=v.c.x.l;
  w.c.y=v.c.y.l;
  return(w);
}


complex cx_interval_to_plain(zz)
     interval_complex zz;
{
  complex z;
  z.x=zz.x.l;
  z.y=zz.y.l;
  return(z);

}







