
/*this file contains the basic I/O routines used
  by the other C files.*/




/*plot a complex number, together with some color,
  determined by the value of k*/

plot(k,file,c)
int k;
FILE *file;
complex c;
{
fprintf(file,"%d\n",k);
fprintf(file,"%lf \n %lf \n",c.x,c.y);
}









/*these routines plot simple objects in a way
  which can be read by the file interface.t. */



simple_point_write(file,c)
FILE *file;
complex c;
{
fprintf(file,"%lf \n %lf \n",c.x,c.y);
}


point_write(k,file,c)
int k;
FILE *file;
complex c;
{
  /*this 2 here indicates that the data
    type is a point.  Other numbers indicate
    different data types*/
  fprintf(file,"2\n");
  plot(k,file,c);
}




edge_write(color,file,v)
int color;
FILE *file;
vector v;
{
fprintf(file,"3\n");
plot(color,file,v.a);
plot(color,file,v.b);
}


arc_write(color,file,a)
int color;
FILE *file;
tcl_arc a;
{
if(a.line==0)
  {
  fprintf(file,"1\n%d\n",color);
  fprintf(file,"%lf%\n%lf\n%lf\n%lf\n%lf\n%lf\n",
  a.corner1.x,
  a.corner1.y,
  a.corner2.x,  
  a.corner2.y,
  a.start,
  a.extent);
  }
if(a.line==1)
  {
  fprintf(file,"3\n");
  plot(color,file,a.z[1]); 
  plot(color,file,a.z[2]); 
  fprintf(file,"3\n");
  plot(color,file,a.z[3]); 
  plot(color,file,a.z[4]); 
  }
}










/*These two routines print out our combinatorial
  code for the tetrahedra in our complex.*/

print_code(joe,v,x,y)
     FILE *joe;
     interval_vector v;
     int x,y;
{
  int i;
  for(i=1;i<=v.X.l;++i)
    {
    fprintf(joe,"5\n6\n");
    fprintf(joe,"%d\n%d\n",x,y+15*i);
    fprintf(joe,"(%d,%d,%d)\n ",v.X.a[i],v.X.b[i],v.X.c[i]);
    }
}


print_tetra_code(joe,P)
     FILE *joe;
     poly P;
{
  print_code(joe,P.v[1], 40,180);
  print_code(joe,P.v[2],110,180);
  print_code(joe,P.v[3],180,180);
  print_code(joe,P.v[4],250,180);

}

