
###############postscript###########################
proc postscript_setup {} {
global POSTSCRIPT_SIZE FRAME
set POSTSCRIPT_SIZE 400
set FRAME 1
.control2 create rectangle 240 390 300 450  \
-fill black -outline white -tag ps_frame
.control2 create rectangle 250 400 290 440  \
-fill blue  -tag ps 
.control2 bind ps <Button-2> do_postscript
.control2 bind ps <Button-1> postscript_up
.control2 bind ps <Button-3> postscript_down
.control2 bind ps_frame <Any-Button> toggle_frame
}


proc toggle_frame {} {
global FRAME
set temp [expr 1-$FRAME]
if {$temp==0} {.control2 itemconfigure ps_frame -outline black}
if {$temp==1} {.control2 itemconfigure ps_frame -outline white}
set FRAME $temp
}


proc postscript_up {} {
global POSTSCRIPT_SIZE
set temp [expr $POSTSCRIPT_SIZE/.95]
if {$temp<600} {
set POSTSCRIPT_SIZE $temp
.control2 scale ps 270 420 [expr 1/.95] [expr 1/.95]
}
}

proc postscript_down {} {
global POSTSCRIPT_SIZE
set temp [expr $POSTSCRIPT_SIZE*.95]
if {$temp>60} {
set POSTSCRIPT_SIZE $temp
.control2 scale ps 270 420 .95 .95
}
}


proc do_postscript {} {
global POSTSCRIPT_SIZE FRAME COL COLOR
if {$FRAME==1} {
.plot2 create line 0 0 0 600 -fill black -tag temp
.plot2 create line 0 0 600 0 -fill black -tag temp
.plot2 create line 600 600 0 600 -fill black -tag temp
.plot2 create line 600 600 600 0 -fill black -tag temp
update idletasks
}
.plot2 postscript  -file "temp.ps" -pageheight $POSTSCRIPT_SIZE \
 -height 600 -width 600 \
-colormode color
update idletasks
.plot2 delete temp
}




##################################################





################board set_up#######################
proc board_setup {} {
canvas .plot2 -width 600 -height 600  
canvas .control2 -width 300 -height 450  
pack .plot2  -in .f1
pack .control2 -in .f2
.plot2 create rectangle -200 -200 800 800 -fill white -tag backg
.control2 create rectangle 0 0 300 450 -fill black
}
##################################################

proc panel_setup {} {
global PIECE LIMIT SCALE COLOR CLEAR
set PIECE(1) 1
set PIECE(2) 1
set PIECE(3) 1
set PIECE(4) 1
set PIECE(5) 1
set PIECE(6) 1
set PIECE(7) 1
set LIMIT(1) 2
set LIMIT(1,2) 215
set LIMIT(2,2) 178
set LIMIT(3) 9
set LIMIT(1,4) 215
set LIMIT(2,4) 178
set LIMIT(5) 2
set LIMIT(6) 10000
set LIMIT(7) 2
set SCALE 200
set COLOR(1) 8
set COLOR(2) 10
set COLOR(3) 6
set CLEAR 0

.control2 create rectangle  50 5 65 20 -fill magenta -tag b11
.control2 create rectangle  70 5 85 20 -fill magenta -tag b12
.control2 create text 200 25  -text "tetrahedron 1" -anchor w -fill white

for {set i 1} {$i<=6} {incr i} {
set a1 [expr 30+20*$i]
set a2 [expr 45+20*$i]
set a3 [expr $i+2]
.control2 create rectangle  $a1 25 $a2 40 -fill magenta -tag b1${a3}
}

.control2 create rectangle  50 65 65 80 -fill magenta -tag b31
.control2 create rectangle  70 65 85 80 -fill magenta -tag b32
.control2 create text 200 70  -text "shift" -anchor w -fill white

.control2 create rectangle  50 165 65 180 -fill blue -tag b41
.control2 create rectangle  70 165 85 180 -fill blue -tag b42
.control2 create text 200 175 -text "pseudorandom projection" -fill white

.control2 create rectangle  50 205 65 220 -fill blue -tag b51
.control2 create rectangle  70 205 85 220 -fill blue -tag b52
.control2 create text 200 215 -text "smash test" -fill white


.control2 create rectangle  10 245 25 260 -fill red -tag b61
.control2 create rectangle  10 265 25 280 -fill red -tag b62
.control2 create rectangle  10 285 25 300 -fill red -tag b63
.control2 create rectangle  200 285 215 300 -fill blue -tag b64

.control2 create text 40 252 -text "projection test" \
-anchor w -fill white

.control2 create text 40 272 -text "smash test" \
 -anchor w -fill white

.control2 create text 40 292 -text "automatic test" \
 -anchor w -fill white

.control2 create text 230 292 -text "clear mode" \
 -anchor w -fill white




for {set i 1} {$i<=6} {incr i} {
set a1 [expr 30+20*$i]
set a2 [expr 45+20*$i]
set a3 [expr $i+2]
.control2 create rectangle  $a1 105 $a2 120 -fill magenta -tag b2${a3}
}

.control2 create rectangle  50 125 65 140 -fill magenta -tag b21
.control2 create rectangle  70 125 85 140 -fill magenta -tag b22
.control2 create text 200 120  -text "tetrahedron 2" -anchor w -fill white


.control2 create text 10 5 -text $PIECE(1) \
 -anchor nw -fill yellow -tag t1

.control2 create text 10 25 -text $PIECE(2) \
 -anchor nw -fill yellow -tag t2

.control2 create text 10 65 -text [expr -1+$PIECE(3)] \
 -anchor nw -fill yellow -tag t3

.control2 create text 10 105 -text $PIECE(4) \
 -anchor nw -fill yellow -tag t4

.control2 create text 10 125 -text $PIECE(5) \
 -anchor nw -fill yellow -tag t5

.control2 create text 10 165 -text $PIECE(6) \
 -anchor nw -fill yellow -tag t6

.control2 create text 10 205 -text $PIECE(7) \
 -anchor nw -fill yellow -tag t7

.control2 bind b11 <Any-Button> {t_change 1 -1}
.control2 bind b12 <Any-Button> {t_change 1 1}

.control2 bind b21 <Any-Button> {t_change 5 -1}
.control2 bind b22 <Any-Button> {t_change 5 1}

.control2 bind b31 <Any-Button> {t_change 3 -1}
.control2 bind b32 <Any-Button> {t_change 3 1}

.control2 bind b41 <Any-Button> {t_change 6 -1}
.control2 bind b42 <Any-Button> {t_change 6 1}

.control2 bind b51 <Any-Button> {t_change 7 -1}
.control2 bind b52 <Any-Button> {t_change 7 1}

.control2 bind b13 <Any-Button> {tt_change 2 $PIECE(1) -1}
.control2 bind b14 <Any-Button> {tt_change 2 $PIECE(1) -5}
.control2 bind b15 <Any-Button> {tt_change 2 $PIECE(1) -20}
.control2 bind b16 <Any-Button> {tt_change 2 $PIECE(1) 20}
.control2 bind b17 <Any-Button> {tt_change 2 $PIECE(1) 5}
.control2 bind b18 <Any-Button> {tt_change 2 $PIECE(1) 1}


.control2 bind b23 <Any-Button> {tt_change 4 $PIECE(5) -1}
.control2 bind b24 <Any-Button> {tt_change 4 $PIECE(5)  -5}
.control2 bind b25 <Any-Button> {tt_change 4 $PIECE(5) -20}
.control2 bind b26 <Any-Button> {tt_change 4 $PIECE(5) 20}
.control2 bind b27 <Any-Button> {tt_change 4 $PIECE(5)  5}
.control2 bind b28 <Any-Button> {tt_change 4 $PIECE(5) 1}

.control2 bind b61 <Any-Button> {pair_test 1}
.control2 bind b62 <Any-Button> {pair_test 2}
.control2 bind b63 <Any-Button> {pair_test 3}
.control2 bind b64 <Any-Button> {clear_toggle}

.control2 create rectangle 0 50 300 50 -fill #456 -outline #456
.control2 create rectangle 0 95 300 95 -fill #456 -outline #456
.control2 create rectangle 0 150 300 150 -fill white -outline white
.control2 create rectangle 0 235 300 235 -fill white -outline white
.control2 create rectangle 2 305 300 380 -fill white -outline black
}









#################change constants##########################
proc t_change {n x} {
global PIECE LIMIT
if {([expr $PIECE($n) + $x>0]) && ([expr $PIECE($n) + $x<=$LIMIT($n)]) } {
incr PIECE($n) $x
if {$n!=3} {
.control2 itemconfigure t$n -text $PIECE($n)
}
if {$n==3} {
.control2 itemconfigure t$n -text [\expr -1+$PIECE($n)]
}

if {$n == 1} {
set PIECE(2) 1
.control2 itemconfigure t2 -text 1
}
if {$n == 5} {
set PIECE(4) 1
.control2 itemconfigure t4 -text 1
}
}
}

proc tt_change {n p x} {
global PIECE LIMIT
if {([expr $PIECE($n) + $x>0]) && ([expr $PIECE($n) + $x<=$LIMIT(${p},$n)]) } {
incr PIECE($n) $x
.control2 itemconfigure t$n -text $PIECE($n)
}
}
#############################################



proc clear {} {
.plot2 delete image
update idletasks
.control2 delete labels
.plot2 create oval 300 300 300 300 -tag origin
.plot2 addtag image withtag origin
}


proc clear_toggle {} {
global CLEAR
set temp [expr 1- $CLEAR]
if {$temp == 1} {.control2 itemconfigure b64 -fill yellow}
if {$temp == 0} {.control2 itemconfigure b64 -fill blue}
set CLEAR $temp
}


##############call to C routine#############
proc pair_test {k} {
global PIECE SCALE COLOR CLEAR
if {$CLEAR==1} {clear}
update idletasks
set outfile [open Graphics/Data/in w]
puts $outfile $PIECE(1)
puts $outfile $PIECE(2)
puts $outfile [expr $PIECE(3)-1]
puts $outfile $PIECE(4)
puts $outfile $PIECE(5)
puts $outfile $PIECE(6)
puts $outfile $PIECE(7)
puts $outfile $k
puts $outfile $COLOR(1)
puts $outfile $COLOR(2)
close $outfile
set outfile [open Graphics/Data/option w]
puts $outfile 3 
close $outfile
catch {exec Graphics/interface.o}
.control2 delete labels
file_read .plot2 
text_read .control2
.plot2 scale new 0 0 $SCALE $SCALE
set x [.plot2 coords origin]
set MOVE_X [lindex $x 0]
set MOVE_Y [lindex $x 1]
.plot2 move new $MOVE_X $MOVE_Y
.plot2 addtag image withtag new
.plot2 dtag new
}





##################################################
proc color_select {} {
global COLOR COL COORD
set x [.control2 gettags current]
set x [lindex $x 0]
set xx [lindex $x 1]
set y [string range $x 1 1]
set l [string length $x]
incr l -1
set x [string range $x 3 $l]
for {set i 1} {$i<18} {incr i} {
.control2 itemconfigure C$y,$i -outline black }
.control2 itemconfigure C$y,$x -outline white
set COLOR($y) $x
if {$y==3} {.plot2 itemconfigure backg -fill $COL($x)}
}
##################################################




###########make color boxes##################################
proc make_color_boxes {} {
global COL

.control2 create rectangle 0 313 300 450 -fill #456
for {set k 1} {$k<=3} {incr k} {
for {set i 1} {$i<17} {incr i} {
.control2 create rectangle  \
 [expr 3.5*$i] [expr 4*$k-3] [expr 3+3.5*$i]  [expr 4*$k] \
-fill $COL($i) -tag C${k},$i
.control2 addtag C$k withtag C${k},$i 
}
.control2 addtag C withtag C$k
.control2 itemconfigure C${k},1  -outline white
}

.control2 scale C 0 0 4 4
.control2 move C -10 395
.control2 bind C <Any-Button> {color_select}

}
###########################################################










###########################SCALING####################
proc scale_setup {} {

.plot2 create oval 300 300 300 300 -tag origin
.plot2 addtag image withtag origin

bind .plot2 <Button-1> {location %x %y
                        scale_up}
bind .plot2 <Button-3> {location %x %y
                        scale_down}
}

proc location {x y} {
global X_POS Y_POS
set X_POS $x
set Y_POS $y
}


proc scale_up {} {
global X_POS Y_POS SCALE
set sc [expr 1/.9]
if {$SCALE<10000} \
{set SCALE [expr $SCALE*$sc]
.plot2 scale image $X_POS $Y_POS $sc $sc}
}

proc scale_down {} {
global X_POS Y_POS SCALE 
set sc [expr .9]
if {$SCALE>.001} \
{set SCALE [expr $SCALE*$sc]
.plot2 scale image $X_POS $Y_POS $sc $sc}
}
####################################################





source Graphics/interface.t

board_setup
make_color_boxes
postscript_setup
panel_setup
scale_setup

