#! /usr/local/bin/wish8.3  -f




###########variables######################
proc variable_reset {} {
global PIECE LAYER
set PIECE(piece) 0
set PIECE(stage) 0
set PIECE(face) 0
set PIECE(final) 0
set PIECE(group) G0
set LAYER 1
.control2 create rectangle 0 0 300 185 -fill #456
}
##################################




##############the group element################
proc create_group_selector {} {

for {set i -10} {$i<10} {incr i} {
.control2 create rectangle $i 0 [expr $i+1] 1 \
-fill #579 -tag G$i -outline white
.control2 addtag G withtag G$i 
}

.control2 scale G 0 0 15 15
.control2 move   G 150 10
.control2 bind G <Any-Button> {group_element_select}
.control2 itemconfigure G0 -fill yellow 
.control2 create text 156 72 -text "0" -fill white
}
############################################################





############SUBDIVISION LEVEL################
proc create_subdivision_level_selector {} {
foreach i {1 2 3 4 5} {
.control2 create rectangle $i 0 [expr $i+1] 1 \
-fill #579 -tag X$i -outline white
.control2 addtag X withtag X$i }
.control2 scale X 0 0 15 15
.control2 bind X <Any-Button> {subdivision_level_select}
global SUBDIVISION_LEVEL
set SUBDIVISION_LEVEL 1
.control2 itemconfigure X1 -fill yellow
.control2 create text 295 128 -text "chunking" \
-fill white -anchor e
.control2 move X 209 32
}
###################################################





##########################################################
proc define_A0 {} {
.control2 create text -28 -28 -text "A0" -fill white -tag A0
set PI 3.14159265
for {set i 1} {$i<= 7} {incr i} {
set j [expr $i-1]
if {$j==0} {set j 7}
set x1 0
set y1 0
set x2 [expr 30*cos(2*$PI*$i/7)] 
set y2 [expr 30*sin(2*$PI*$i/7)] 
set x3 [expr 30*cos(2*$PI*(1+$i)/7)] 
set y3 [expr 30*sin(2*$PI*(1+$i)/7)] 
.control2 create polygon $x1 $y1 $x2 $y2 $x3 $y3 -tag A0$j
}

foreach name {A01 A02 A03}      {.control2 addtag A0m withtag $name}
foreach name {A04 A05 A06 A07}   {.control2 addtag A0p withtag $name}
foreach name {A0m A0p} {.control2 addtag A0 withtag $name }
.control2 addtag P withtag A0
.control2 itemconfigure A0m -fill #234 -outline white
.control2 itemconfigure A0p -fill #579 -outline white
}
##########################################################




################################################################
proc define_B0 {} {
.control2 create text -34 -28 -text "B0" -fill white -tag B0
set PI 3.14159265
for {set i 1} {$i<= 3} {incr i} {
set x1 0
set y1 0
set x2 [expr 30*cos(2*$PI*$i/5)] 
set y2 [expr 30*sin(2*$PI*$i/5)] 
set x3 [expr 30*cos(2*$PI*(1+$i)/5)] 
set y3 [expr 30*sin(2*$PI*(1+$i)/5)] 
.control2 create polygon $x1 $y1 $x2 $y2 $x3 $y3 -tag B0$i
}
foreach name {B01 B02 B03}      {.control2 addtag B0p withtag $name}
.control2 addtag B0 withtag B0p
.control2 addtag P withtag B0
.control2 itemconfigure B0p -fill #579 -outline white
}
################################################################




################################################################
proc define_A1 {} {
.control2 create text -22 -28 -text "A1" -fill white -tag A1
set PI 3.14159265
for {set i 1} {$i<= 2} {incr i} {
set j [expr $i-.5]
set x1 0
set y1 0
set x2 [expr 30*cos(2*$PI*$j/3)] 
set y2 [expr 30*sin(2*$PI*$j/3)] 
set x3 [expr 30*cos(2*$PI*(1+$j)/3)] 
set y3 [expr 30*sin(2*$PI*(1+$j)/3)] 
.control2 create polygon $x1 $y1 $x2 $y2 $x3 $y3 -tag A1$i
}
foreach name {A11 A12}      {.control2 addtag A1p withtag $name}
.control2 addtag A1 withtag A1p
.control2 addtag P withtag A1
.control2 itemconfigure A1p -fill #579 -outline white
}
################################################################



################################################################
proc define_B1 {} {
.control2 create text -22 -28 -text "B1" -fill white -tag B1
set PI 3.14159265
for {set i 1} {$i<= 4} {incr i} {
set x1 0
set y1 0
set x2 [expr 30*cos(2*$PI*$i/4)] 
set y2 [expr 30*sin(2*$PI*$i/4)] 
set x3 [expr 30*cos(2*$PI*(1+$i)/4)] 
set y3 [expr 30*sin(2*$PI*(1+$i)/4)] 
.control2 create polygon $x1 $y1 $x2 $y2 $x3 $y3 -tag B1$i
}
foreach name {B11 B12 B13 B14}      {.control2 addtag B1m withtag $name}
.control2 addtag B1 withtag B1m
.control2 addtag P withtag B1
.control2 itemconfigure B1m -fill #234 -outline white
}
################################################################




#########################
proc position_pieces {} {
.control2 move B1 40 -30
.control2 move A0 120 -30
.control2 move B0 200 -30
.control2 move A1 260 -30
foreach name {A0m A0p B0p A1p B1m} {.control2 addtag P withtag $name}
.control2 bind P <Any-Button> {piece_select}
}
###############################






####################layer selector#############
proc create_layer_selector {} {
.control2 create rectangle 95 45 115 55  -tag T21
.control2 create rectangle 95 55 115 65  -tag T22
.control2 create rectangle 95 65 115 75  -tag T23

.control2 create polygon 105 45 100 55 110 55 -tag T11
.control2 create polygon 100 55 110 55 115 65 95 65  -tag T12
.control2 create polygon 95 65 115 65 120 75 90 75 -tag T13

.control2 create polygon 90 45  120 45 115 55 95 55 -tag T31
.control2 create polygon 115 55 95 55 100 65 110 65 -tag T32
.control2 create polygon 110 65 100 65 105 75 -tag T33

foreach name {T11 T12 T13} {.control2 addtag T1 withtag $name}
foreach name {T21 T22 T23} {.control2 addtag T2 withtag $name}
foreach name {T31 T32 T33} {.control2 addtag T3 withtag $name}
foreach name {T1 T2 T3} {.control2 addtag T withtag $name}

.control2 move T -75 -10
.control2 lower T
.control2 bind T <Any-Button> {layer_select}
}
#############################################################




##########################face selector##################
proc create_face_selector {} {

.control2 create polygon 190 50 130 50 160 85 -tag Z11

.control2 create polygon 160 25 150 40 170 40 -tag Z21
.control2 create polygon 190 50 130 50 160 80 -tag Z22
.control2 create polygon 150 40 170 40 190 50 130 50 -tag Z25
.control2 create polygon 160 10 160 25 150 40 130 50 -tag Z23
.control2 create polygon 160 10 160 25 170 40 190 50 -tag Z24

.control2 create polygon 150 40 170 40 170 20 150 20 -tag Z31 
.control2 create polygon 130 50 190 50 190 80 130 80 -tag Z32 
.control2 create polygon 170 20 170 40 190 50 190 10 -tag Z33 
.control2 create polygon 150 40 170 40 190 50 130 50 -tag Z34 
.control2 create polygon 150 20 150 40 130 50 130 10 -tag Z35 
.control2 create polygon 150 20 170 20 190 10 130 10 -tag Z36 

.control2 create polygon 150 30 130 50 130 10        -tag Z41 
.control2 create polygon 170 30 190 50 190 10        -tag Z42
.control2 create polygon 130 50 190 50 190 80 130 80 -tag Z44
.control2 create polygon 150 30 170 30 190 50 130 50 -tag Z45
.control2 create polygon 150 30 170 30 190 10 130 10 -tag Z43  

foreach j {1 2 3 4} {
foreach i {1 2 3 4 5 6} {
.control2 addtag Z$j withtag Z${j}$i }}

foreach j {1 2 3 4} {
.control2 addtag Z withtag Z$j }

.control2 lower Z
.control2 bind Z <Button> {face_select}
.control2 move Z -70 25
}
####################################################################




##################final subdivision selector#########################
proc create_final_selector {} {
.control2 create polygon 0 0 2 0 1 1  -tag Q1
.control2 create polygon 2 0 2 2 1 1  -tag Q2
.control2 create polygon 2 2 0 2 1 1  -tag Q3
.control2 create polygon 0 2 0 0 1 1  -tag Q4
foreach name {Q1 Q2 Q3 Q4} {.control2 addtag Q withtag $name}
.control2 scale Q 0 0 15 15
.control2 move Q 15 75
.control2 bind Q <Any-Button> {final_select}
.control2 lower Q
}
######################################################################




###############################################
proc piece_setup {posx posy} {
variable_reset
define_A0
define_A1
define_B0
define_B1
position_pieces
create_group_selector
create_subdivision_level_selector
create_layer_selector
create_face_selector
create_final_selector
foreach name {bak P T Z Q G X} {.control2 addtag stuff withtag $name }
.control2 move stuff $posx $posy
}
#########################################





##########coloring the pieces#######################
proc piece_recolor {j} {
foreach name {A0m B1m} {
.control2 itemconfigure $name -fill #234 }
foreach name {A1p A0p B0p} {
.control2 itemconfigure $name -fill #579 }
if {$j<=2} {
foreach name {A0m B1m A1p A0p B0p} {
.control2 itemconfigure $name -outline white }
}
if {$j>=3} {
foreach name {A1p A0p B0p} {
.control2 itemconfigure $name -outline #579 }
foreach name {A0m B1m} {
.control2 itemconfigure $name -outline #234 }
}
}
##########################################################3





#######################color level selector###########
proc layer_selector_recolor {} {
global PIECE
.control2 itemconfigure T   -fill #234 -outline white
.control2 itemconfigure T13 -fill #579 -outline white
.control2 itemconfigure T23 -fill #579 -outline white
.control2 itemconfigure T33 -fill #579 -outline white
foreach name {stage face final} {set PIECE($name) 0} 
}
##########################################################





##########################color face selector##############
proc face_selector_recolor {} {
global LAYER
set cc #234
if {$LAYER == 3} {set cc #579}
.control2 itemconfigure Z -fill $cc -outline white
foreach name {face final} {set PIECE($name) 0} 
}
##########################################################




##########################color final selector##############
proc final_selector_recover {} {
global PIECE
.control2 itemconfigure Q -fill #579 -outline white
set PIECE(final) 0
}
##########################################################




#############################################
proc group_element_select {} {
global PIECE 
.control2 lower SEND
set x [.control2 gettags current]
set x [lindex $x 0]
set PIECE(group) $x
.control2 itemconfigure G -fill #579 -outline white 
.control2 itemconfigure $x -fill yellow 
}
###############################################





##########################################################
proc piece_select {} {
global PIECE SUBDIVISION_LEVEL RENDER COLOR COL
piece_recolor $SUBDIVISION_LEVEL
layer_selector_recolor
face_selector_recolor 
final_selector_recover
.control2 lower Z
.control2 lower Q
.control2 lower SEND
set x [.control2 gettags current]


if {$SUBDIVISION_LEVEL ==1 } {
set x [lindex $x 0] 
.control2 itemconfigure $x -fill yellow 
.control2 lower T
foreach name {A04 A07} {
if {$x==$name} { .control2 raise T3
.control2 raise T0} }
foreach name {A05 A06 B02} {
if {$x==$name} { .control2 raise T2
.control2 raise T0 } }
foreach name {B01 B03 A11 A12} {
if {$x==$name} { .control2 raise T1
.control2 raise T0} }
foreach name {B11 B12 B13 B14 A01 A02 A03} {
if { $x == $name } {
.control2 raise SEND
set file [open Graphics/Data/in w]
puts $file 1
set g $PIECE(group)
set g [string trim $g G]
puts $file $g
if {$x=="B11"} {set x 1}
if {$x=="B12"} {set x 2}
if {$x=="B13"} {set x 3}
if {$x=="B14"} {set x 4}
if {$x=="A01"} {set x 5}
if {$x=="A02"} {set x 6}
if {$x=="A03"} {set x 7}
puts $file $x
close $file } }
set PIECE(piece) $x 
}


if {$SUBDIVISION_LEVEL == 2} {
set x [lindex $x 0] 
.control2 itemconfigure $x -fill yellow
.control2 raise SEND
set file [open Graphics/Data/in w]
puts $file 2
set g $PIECE(group)
set g [string trim $g G]
puts $file $g
if {$x=="B11"} {set x 1}
if {$x=="B12"} {set x 2}
if {$x=="B13"} {set x 3}
if {$x=="B14"} {set x 4}
if {$x=="A01"} {set x 5}
if {$x=="A02"} {set x 6}
if {$x=="A03"} {set x 7}
if {$x=="A04"} {set x 8}
if {$x=="A05"} {set x 9}
if {$x=="A06"} {set x 10}
if {$x=="A07"} {set x 11}
if {$x=="B01"} {set x 12}
if {$x=="B02"} {set x 13}
if {$x=="B03"} {set x 14}
if {$x=="A11"} {set x 15}
if {$x=="A12"} {set x 16}
puts $file $x
close $file 
update idletasks
}


if {$SUBDIVISION_LEVEL == 3} {
set x [lindex $x 1] 
.control2 itemconfigure $x -fill yellow -outline yellow
.control2 raise SEND
set file [open Graphics/Data/in w]
puts $file 3
set g $PIECE(group)
set g [string trim $g G]
puts $file $g
if {$x == "A0p"} {puts $file 0}
if {$x == "A1p"} {puts $file 1}
if {$x == "B0p"} {puts $file 2}
if {$x == "A0m"} {puts $file 3}
if {$x == "B1m"} {puts $file 4}
close $file }



if {$SUBDIVISION_LEVEL == 4} {
.control2 itemconfigure A0p -fill yellow -outline yellow 
.control2 itemconfigure B0p -fill yellow -outline yellow  
.control2 itemconfigure A1p -fill yellow -outline yellow 
if {$RENDER==3} {
.control2 itemconfigure A0m -fill yellow -outline yellow 
.control2 itemconfigure B1m -fill yellow -outline yellow  
}
.control2 raise SEND
set file [open Graphics/Data/in w]
puts $file 4
set g $PIECE(group)
set g [string trim $g G]
puts $file $g
close $file }
}
#########################################################





###############################################
proc layer_select {} {
global PIECE SUBDIVISION_LEVEL LAYER
layer_selector_recolor 
final_selector_recover
.control2 lower SEND
set x [.control2 gettags current]
set x [lindex $x 0]
set PIECE(stage) $x
set xx [string range $x 2 2]
set LAYER $xx
face_selector_recolor
.control2 lower Z
.control2 lower Q

foreach name {T11} {
if {$x == $name} {.control2 raise Z1 }}

foreach name {T22 T23} {
if {$x == $name} {.control2 raise Z3 }}

foreach name {T21} {
if {$x == $name} {.control2 raise Z4 }}

foreach name {T13 T12 T32 T31 T33} {
if {$x == $name} {.control2 raise Z2 } }

.control2 itemconfigure $x -fill yellow

}
###############################################




###############################################
proc face_select {} {
global PIECE LAYER COLOR COL
face_selector_recolor
final_selector_recover
set x [.control2 gettags current]
set y [lindex $x 1]
set x [lindex $x 0]
.control2 lower Q
.control2 lower SEND
.control2 itemconfigure $x -fill yellow
foreach name {Z23 Z24 Z25 Z31 Z32 Z33 Z34 Z35 Z36 Z43 Z44 Z45} {
if {$name == $x} {.control2 raise Q} } 
set PIECE(face) $x 
foreach name {Z11 Z21 Z22 Z41 Z42} {
if {$x==$name} {.control2 raise SEND 
.control2 itemconfigure $x -fill yellow
set file [open Graphics/Data/in w]
puts $file 1
set g $PIECE(group)
set g [string trim $g G]
puts $file $g
set z $PIECE(piece)
if {$z=="B11"} {set z 1}
if {$z=="B12"} {set z 2}
if {$z=="B13"} {set z 3}
if {$z=="B14"} {set z 4}
if {$z=="A01"} {set z 5}
if {$z=="A02"} {set z 6}
if {$z=="A03"} {set z 7}
if {$z=="A04"} {set z 8}
if {$z=="A05"} {set z 9}
if {$z=="A06"} {set z 10}
if {$z=="A07"} {set z 11}
if {$z=="B01"} {set z 12}
if {$z=="B02"} {set z 13}
if {$z=="B03"} {set z 14}
if {$z=="A11"} {set z 15}
if {$z=="A12"} {set z 16}
puts $file $z
set x [string range $x 2 2]
set y $PIECE(stage)
set y1 [string range $y 1 1]
set y1 [expr 4-$y1]
set y2 [string range $y 2 2]
puts $file $y1
puts $file $y2
puts $file $x
close $file
}
} 
}
###############################################





###############################################
proc final_select {} {
global PIECE COLOR COL  
final_selector_recover
.control2 raise SEND
set x [.control2 gettags current]
set x [lindex $x 0]
set PIECE(final) $x
.control2 itemconfigure $x -fill yellow
set file [open Graphics/Data/in w]
puts $file 1
set g $PIECE(group)
set g [string trim $g G]
puts $file $g
set z $PIECE(piece)
if {$z=="B11"} {set z 1}
if {$z=="B12"} {set z 2}
if {$z=="B13"} {set z 3}
if {$z=="B14"} {set z 4}
if {$z=="A01"} {set z 5}
if {$z=="A02"} {set z 6}
if {$z=="A03"} {set z 7}
if {$z=="A04"} {set z 8}
if {$z=="A05"} {set z 9}
if {$z=="A06"} {set z 10}
if {$z=="A07"} {set z 11}
if {$z=="B01"} {set z 12}
if {$z=="B02"} {set z 13}
if {$z=="B03"} {set z 14}
if {$z=="A11"} {set z 15}
if {$z=="A12"} {set z 16}
puts $file $z
set x [string range $x 1 1]    
set y $PIECE(stage)
set y1 [string range $y 1 1]
set y1 [expr 4-$y1]
set y2 [string range $y 2 2]
puts $file $y1
puts $file $y2
set z $PIECE(face)
set z1 [string range $z 1 1]
set z2 [string range $z 2 2]
if {$z1 != 3} {
set z3 [expr 4*$z2 - 10 + $x] 
puts $file $z3 }
if {$z1 == 3} {
set z3 [expr 4*$z2 - 4 + $x] 
puts $file $z3 }
close $file
}
###############################################





###############################################
proc subdivision_level_select {} {
global PIECE SUBDIVISION_LEVEL
.control2 lower SEND
.control2 lower T
.control2 lower Z
.control2 lower Q
set x [.control2 gettags current]
set x [lindex $x 0]
set y [string trim $x X]
.control2 itemconfigure X -fill #579 -outline white
.control2 itemconfigure $x -fill yellow 
set x [string trim $x X]
set SUBDIVISION_LEVEL $x
piece_recolor $x
layer_selector_recolor
face_selector_recolor
final_selector_recover
.control2 raise P
if {$y==5} {.control2 lower P
set file [open Graphics/Data/in w]
puts $file 5
set g $PIECE(group)
set g [string trim $g G]
puts $file $g
close $file
.control2 raise SEND }
}
###############################################
