#include <stdio.h>
#include <math.h>
#define Pi 3.141592653589
#include "Computations/list.c"


/*this file contains the computational tests for my
  paper "Real Hyperbolic on the Outside, Complex Hyperbolic
  on the Inside.  In the paper there are 8 computations
  and here there are 8 tests. 

  Only one computation is slow.  The computations have
  several modes:  Mode 1 gives a steady printout of the
                  results of the test. 
                  Mode 0 just prints out the
                  final result of the test. 

  A return of 1 indicates that the test has passed. You
  should examine the source code to see the flow of logic. 
  Most of the tests are commented out right now. Uncomment
  to run them.   We run the tests in mode 1, to mark their
  progress.  We print the result of the test in the file
  test_log.   All the results should be 1.   We did not run
  the tests all at once, so we have not bothered to list the
  file test_log.  If you re-run the code, it will be
  created automatically*/



int main() {
  int n;
  FILE *out, *fopen();


  printf("test 0\n");

  out=fopen("test_log","w");


  /*Computation 0: This does the computation from
    the end of Ch 8, checking the types certain of
    our vertices in our subdivision construction.*/

   n=final_norm_consistent_test(0);
   fprintf(out,"norm_consistent test: %d\n",n);
   if(n==0) {printf("fail/n");return(0);}



  /*computation 1:  This test shows that all the vectors
    in a pure positive simplex are positive and that all
    the vectors in a pure negative simplex are negative.
    The text is contained in the file 
    Computations/subdivision_test.c.  It takes about
    an hour. */
  
     n=final_purity_test(1);
     fprintf(out,"purity test: %d\n",n);
     if(n==0) {printf("fail/n");return(0);}

  /*computation 2: This computation shows that all the
    tetrahedra of the form K^a(T) are affinely bounded, when
    -6<=k<=6.  The computation is contained in the file
    Computations/subdivision_test.c.  It is quick.*/  

  //    n=final_affine_test(1);
  //    fprintf(out,"affine test: %d\n",n);
  //    if(n==0) {printf("fail\n");return(0);}

  /*computation 3:  This computation shows that the
    numerical method of matching vertices coincides with
    the combinatorial one.  As a byproduct it takes care
    of computation 3 in the paper.  This test is contained in
    the file Computations/matching_test.c.  
    It takes about an hour.*/

  //   n=code_versus_numerical_test(1);
  //    fprintf(out,"matching test: %d\n",n);
  //    if(n==0) {printf("fail\n");return(0);}

    /*computation 4:  This is subsumed by Computation 7 below.*/


  /*Computations 5-6:   Ths is the big one.  
    It takes about 12 hours.*/

    /* 
      n=injectivity_test(1);
      fprintf(out,"injectivity test: %d\n",n);
      if(n==0) {printf("fail\n");exit(0);}
    */

  /*computation 7: This computation shows that all
    simplices of the form K^a(T) and K^b(T) are disjoint
    when |a-b|>8.  As a byproduct, it takes care of 
    Computation 4 in the paper.  The test is contained
    in the file Computations/cutoff_test.c. It is quick*/

  //    n=final_cutoff_test(1);   
  //    fprintf(out,"cutoff test: %d\n",n);
  //    if(n==0) {printf("fail/n");return(0);}

  fclose(out);
  return(0);

}





