#! /usr/local/bin/wish8.3  -f

#this is a tcl plotter.  It is very similar to the
#file tcl_plotter.t, contained in the directory
#RealHyp.  Click on the picture to rescale it. 

frame .f
pack .f
canvas .plot -width 800 -height 800
pack .plot 
.plot create rectangle 0 0 800 800 -fill white -tag back
.plot create oval 400 400 400 400 -fill white -outline white -tag im
.plot addtag im withtag oval
.plot scale oval 0 0 50 50
.plot move oval 400 400

bind .plot <Button-1> {location1 %x %y
                       plan_up_scale}
bind .plot <Button-3> {location1 %x %y
                       plan_dn_scale}

bind .plot <Button-2> {post}
proc post {} {
}

set wall [expr 400-100*3.1415926]
#.plot create rectangle $wall -200 400 800 -fill black -tag im


proc post {} {
.plot create rectangle -200 0 1000 -200 -fill black -tag temp
.plot create rectangle 0 -200 -200 1000 -fill black -tag temp
.plot create rectangle 800 800 0 1000  -fill black -tag temp
.plot create rectangle 800 800 1000 0 -fill black -tag temp
update idletasks
.plot postscript  -file "temp.ps" -pageheight 250 \
 -height 800 -width 800 \
-colormode color
update idletasks
.plot delete temp

}


##########################################



set ACOORD1 0
set BCOORD1 0
set SCALE1 1

set COL(1) black
set COL(2) black
set COL(3) black
set COL(4) white
set COL(5) red
set COL(6) black
set COL(7) #ff0
set COL(8) #db0
set COL(9) #06f
set COL(10) #00f
set COL(11) #f00
set COL(12) #b00
set COL(13) #0f2
set COL(14) #0a0
set COL(15) #f0d
set COL(16) #b08
set COL(17) #906




##########################FILE READ######
proc file_read {} {
global infile ACOORD1 BCOORD1 SCALE1
set ACOORD1 0
set BCOORD1 0
set SCALE1 1
set infile [open out0 r]
while {[gets $infile line] >= 0} {
set type $line

if {$type == 2} {point_write}
if {$type == 3} {segment_write}
}
close $infile
}



proc point_write {} {
global COL infile 
foreach name {s1 p1 p2} {
gets $infile line
set w .05
set $name $line }
set pp1 [expr 300 + 100*$p1]
set pp2 [expr 300 - 100*$p2]
.plot create oval [expr $pp1-$w] [expr $pp2-$w] \
[expr $pp1 +$w] [expr $pp2+$w] \
-fill $COL($s1) -outline $COL($s1) -tag im2
.plot addtag im withtag im2
}


proc segment_write {} {
global COL infile 
foreach name {s1 p1 p2 s2 q1 q2} {
gets $infile line
set $name $line }
set pp1 [expr 400 + 100*$p1]
set pp2 [expr 400 - 100*$p2]
set qq1 [expr 400 + 100*$q1]
set qq2 [expr 400 - 100*$q2]

.plot create line $pp1 $pp2 $qq1 $qq2 \
-fill $COL($s1)  -tag im -width 1
}




proc location1 {a b} {
global ACOORD1 BCOORD1
set ACOORD1 $a
set BCOORD1 $b
}


proc plan_up_scale {} {
global ACOORD1 BCOORD1 SCALE1 SCALE1
set sc [expr 1/.9]
if {$SCALE1<10000} \
{set SCALE1 [expr $SCALE1*$sc]
.plot scale im $ACOORD1 $BCOORD1 $sc $sc}
}
###
proc plan_dn_scale {} {
global ACOORD1 BCOORD1 SCALE1 SCALE1
set sc [expr .9]
if {$SCALE1>.001} \
{set SCALE1 [expr $SCALE1*$sc]
.plot scale im $ACOORD1 $BCOORD1 $sc $sc}
}






file_read 


