

/*projection onto negative eigenspace*/


/*both endpoints of the edge are the same.  The
edge just serves as a useful structure for
storing two values, the coefficients of E0K and EiK.*/

edge Pi1(v)
     interval_vector v;
{
  edge e1,e2,e3;
  interval_vector v1,v2;
  v1=E0K();
  v2=EiK();
  e1.s[1][1]=v1.a;
  e1.s[1][2]=v1.b; 
  e1.s[2][1]=v2.a;
  e1.s[2][2]=v2.b;
  e2.s[1][1]=v.a;
  e2.s[1][2]=v.b; 
  e2.s[2][1]=v.a;
  e2.s[2][2]=v.b;
  e3=normal_position(e1,e2);
  return(e3);
}


interval_vector Pi2(v)
interval_vector v;
{
  interval_vector x;
  interval_complex z[5];
  x=EpK();
  z[1]=hermitian_dot(v,x);
  z[2]=hermitian_dot(x,x);
  z[3]=cx_divide(z[1],z[2]);
  x=vec_minus(v,vec_scale(z[3],x));
  return(x);
}






graph cutoff_graph(P)
poly P;
{
graph G;
int i,j,count;
edge e1,e2,e3;
count=1;
for(i=1;i<=4;++i)
  {
  for(j=i+1;j<=4;++j)
    {
      e1=Pi1(Pi2(P.v[i]));
      e2=Pi1(Pi2(P.v[j]));
      e3.s[1][1]=e1.s[1][1];
      e3.s[1][2]=e1.s[1][2];
      e3.s[2][1]=e2.s[2][1];
      e3.s[2][2]=e2.s[2][2];
      G.e[count]=e3;
    ++count;
    }
  }
G.l=6;
return(G);
}




/*an edge is a collection of 2 points in C2.  Here
  we make a graph with 6 edges*/

graph unit_circle_graph()
{
graph G;
 G.l=2;
 G.e[1].s[1][1]=cx_convert(1.0,0.0);
 G.e[1].s[1][2]=cx_convert(1.0,0.0);
 G.e[1].s[2][1]=cx_convert(0.0,1.0);
 G.e[1].s[2][2]=cx_convert(0.0,-1.0);

 G.e[2].s[1][1]=cx_convert(1.0,0.0);
 G.e[2].s[1][2]=cx_convert(1.0,0.0);
 G.e[2].s[2][1]=cx_convert(0.0,-1.0);
 G.e[2].s[2][2]=cx_convert(0.0,1.0);
 return(G);
}



int inside_unit_circle(P)
     poly P;
{
  graph G1,G2;
  interval_complex value;
  interval norm;
  int i,j,test;
  G1=cutoff_graph(P);
  G2=unit_circle_graph();
  for(i=1;i<=6;++i)
    {
      for(j=1;j<=2;++j)
	{
	  test=generic_intersection_number(G1.e[i],G2.e[j]);
	  if(test!=0) return(0);
	}
    }
  value=cx_divide(G1.e[1].s[1][1],G1.e[1].s[1][2]);
  norm=cx_norm(value);
  if(norm.r<1) return(1);
  return(0);
}




int outside_unit_circle(P)
     poly P;
{
  graph G1,G2;
  interval_complex value;
  interval norm;
  int i,j,test;
  G1=cutoff_graph(P);
  G2=unit_circle_graph();
  for(i=1;i<=6;++i)
    {
      for(j=1;j<=2;++j)
	{
	  test=generic_intersection_number(G1.e[i],G2.e[j]);
	  if(test!=0) return(0);
	}
    }
  value=cx_divide(G1.e[1].s[1][1],G1.e[1].s[1][2]);
  norm=cx_norm(value);
  if(norm.l>1) return(1);
  return(0);
}




int first_good_negative_shift(P)
poly P;
{
int i,test;
interval val;
poly Q;
graph GQ;
Q=P;
for(i=0;i<=6;++i)
  {
  test=inside_unit_circle(Q);
  if(test==1) return(i);
  Q=negative_shift(Q);
  }
return(1000);
}
  

int first_good_positive_shift(P)
poly P;
{
int i,test;
interval val;
poly Q;
graph GQ;
Q=P;
for(i=0;i<=6;++i)
  {
  test=outside_unit_circle(Q);
  if(test==1) return(i);
  Q=positive_shift(Q);
  }
return(1000);
}
  

/**we are computing the maximum good negative shift*/

int final_negative_cutoff_test(mode)
     int mode;
{
  int j,test,max;
  max=0;
  poly P;

      for(j=1;j<=393;++j)
	{
	  P=TETRA(j);
	  test=first_good_negative_shift(P);
	  if(max<test) max=test;
	  {
	    if(mode==1)	  printf("negative cutoff test: %d:  %d %d\n",j,test,max); 
	  }
	}
        return(max);
}



int final_positive_cutoff_test(mode)
     int mode;
{
  int j,test,max;
  poly P;
  max=0;
      for(j=1;j<=393;++j)
	{
	  P=TETRA(j);
	  
	  printf("length %d\n",P.l);
	  
	  test=first_good_positive_shift(P);
	  if(max<test) max=test;
	  {
	  if(mode==1) printf("positive cutoff test %d:  %d %d\n",j,test,max); 
	  }
	}
        return(max);
}


int final_cutoff_test(mode)
     int mode;
{
  int n1,n2;
  n1=final_positive_cutoff_test(mode);
  if(n1!=4) return(0);
  n2=final_negative_cutoff_test(mode);
  if(n2!=5) return(0);
  return(1);
}
