


/*******************************************
    This file contains the subroutines which
convert the complex Z to the computex Z'.
********************************************/

/**This merges together two lists of polyhedra*/



/*this is the perturbation data.  See Ch. 8 of the paper*/

interval_complex mu(k)
int k;
{
if(k==1) return(cx_convert(0.23,-0.11));
if(k==2) return(cx_convert(0.3,0.0));
if(k==3) return(cx_convert(0.45,0.0));
if(k==4) return(cx_convert(0.55,0.0));  
if(k==5) return(cx_convert(0.92,0.0));
 return(cx_convert(0.85,0.0)); //when k=6.

}


/*Here R is a polyhedron with possibly more than
  4 vertices.  This routine just selects 4 of them.*/

poly tetra_make(R,a,b,c,d)
poly R;
int a,b,c,d;
{
poly Q;
Q.l=4; 
Q.v[1]=R.v[a];
Q.v[2]=R.v[b];
Q.v[3]=R.v[c];
Q.v[4]=R.v[d];
return(Q);
}




/*This operation subdivides a pyramid-with-square-base
into a union of 4 tetrahedra.  It first subdivides
the square base into 4 triangles, in an X pattern, and
then cones to the apex.  It is part of the conservative
barycentric subdivision defined in Ch. 9 of the paper*/

/**The index here is 1,2,3,4*/
poly pyramid(R,a,b,c,d,e,INDEX)
     poly R;
     int a,b,c,d,e;
     int INDEX;
{
poly RR;
int i;
int cc,dd,ee;
RR=R;
RR.v[0]=average(4,R,b,c,d,e,1,1,1,1);
 if(INDEX==1) return tetra_make(RR,0,a,b,e);
 if(INDEX==2) return tetra_make(RR,0,a,c,b);
 if(INDEX==3) return tetra_make(RR,0,a,d,c);
 if(INDEX==4) return tetra_make(RR,0,a,e,d);
 return R;
}




/*We need to assign perturbation data to each
mixed edge in the complex.  These come in
3 types, modulo the action of PU(2,1).  This
routine identifies the edge type, by
computing a hermitian dot product.  Following
this, the routine assigns the perturbation
data and constructs the vertices.  Here
j is 1,2, or 3, accounting for the three
vertices.*/


interval_vector crook0(v1,v2,j)
interval_vector v1,v2;
int j;
{
interval_complex u1,u2;
interval_complex z[10],a[3],nu1,nu2,one;
interval close;
interval_vector w;
u1=mu(2*j-1);
u2=mu(2*j);
z[3]=cx_convert(-.937506,1.500335);
z[4]=cx_conjugate(z[3]);
z[5]=cx_convert(-1.103127,0.0);
z[6]=cx_conjugate(z[5]);
z[7]=hermitian_dot(v1,v2);
 nu1.x=cx_norm(u1);
 nu1.y=ZERO();
 nu2.x=cx_norm(u2);
 nu2.y=ZERO();
 one=cx_convert(1.0,0.0);
close=cx_dist(z[7],z[3]);
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu1);
  a[2]=u1;
  }
 close=cx_dist(z[7],z[4]); 
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu1);
  a[2]=cx_conjugate(u1);
  }
 close=cx_dist(z[7],z[5]);
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu2);
  a[2]=u2;
  }
 close=cx_dist(z[7],z[6]);  
if(close.r<.01)
  {
  a[1]=cx_minus(one,nu2);
  a[2]=cx_conjugate(u2);
  }
w=vec_plus(vec_scale(a[1],v1),vec_scale(a[2],v2));
 w.X.l=1;
 w.X.a[1]=j;
 w.X.b[1]=v1.X.c[1];
 w.X.c[1]=v2.X.c[1];
return(w);
}




/*the type of the polyhedron is the number of
  positive vertices.  There are three stages to
  the perturbation construction, and these are
  indexed by the stage variable*/


poly crook11(P,INDEX)
     poly P;
     int INDEX;
{
         poly R;
         R=P;
         R.v[4] =crook0(P.v[1],P.v[4],1);
         R.v[5] =crook0(P.v[2],P.v[4],1);
         R.v[6] =crook0(P.v[3],P.v[4],1);
         R.v[7]=average(6,R,1,2,3,4,5,6,1,1);
         if(INDEX==1) return tetra_make(R,7,1,2,3); 
         if(INDEX==2) return tetra_make(R,7,4,5,6);
	 if(INDEX<=6) return pyramid(R,7,1,2,5,4,INDEX-2);
	 if(INDEX<=10) return pyramid(R,7,2,3,6,5,INDEX-6);
	 return pyramid(R,7,3,1,4,6,INDEX-10);
}


poly crook12(P,INDEX)
     poly P;
     int INDEX;
{
         poly R;
         R=P;
         R.v[1] =crook0(P.v[1],P.v[4],1);
         R.v[2] =crook0(P.v[2],P.v[4],1);
         R.v[3] =crook0(P.v[3],P.v[4],1);
         R.v[4] =crook0(P.v[1],P.v[4],2);
         R.v[5] =crook0(P.v[2],P.v[4],2);
         R.v[6] =crook0(P.v[3],P.v[4],2);
         R.v[7]= average(6,R,1,2,3,4,5,6,1,1);   
         if(INDEX==1) return tetra_make(R,7,1,2,3); 
         if(INDEX==2) return tetra_make(R,7,4,5,6);
	 if(INDEX<=6) return pyramid(R,7,1,2,5,4,INDEX-2);
	 if(INDEX<=10) return pyramid(R,7,2,3,6,5,INDEX-6);
	 return pyramid(R,7,3,1,4,6,INDEX-10);
}


poly crook13(P,INDEX)
     poly P;
     int INDEX;
{
         poly R;
         R=P;
         R.v[1] =crook0(P.v[1],P.v[4],2);
         R.v[2] =crook0(P.v[2],P.v[4],2);
         R.v[3] =crook0(P.v[3],P.v[4],2);
         R.v[4] =crook0(P.v[1],P.v[4],3);
         R.v[5] =crook0(P.v[2],P.v[4],3);
         R.v[6] =crook0(P.v[3],P.v[4],3);
         R.v[7]= average(6,R,1,2,3,4,5,6,1,1);
         if(INDEX==1) return tetra_make(R,7,1,2,3);
         if(INDEX==2) return tetra_make(R,7,4,5,6);
	 if(INDEX<=6) return pyramid(R,7,1,2,5,4,INDEX-2);
	 if(INDEX<=10) return pyramid(R,7,2,3,6,5,INDEX-6);
	 return pyramid(R,7,3,1,4,6,INDEX-10);
}

poly crook21(P,INDEX)
     poly P;
     int INDEX;
{
         poly R;
	 
         R.v[1]=P.v[1];
         R.v[2]=P.v[2];
         R.v[3]= crook0(P.v[2],P.v[3],1);
         R.v[4]= crook0(P.v[2],P.v[4],1);  
         R.v[5]= crook0(P.v[1],P.v[4],1);
         R.v[6]= crook0(P.v[1],P.v[3],1);
         R.v[7]= average(6,R,1,2,3,4,5,6,1,1);
	 if(INDEX==1) return tetra_make(R,7,1,5,6); 
         if(INDEX==2) return tetra_make(R,7,2,3,4);
	 if(INDEX<=6) return pyramid(R,7,1,2,4,5,INDEX-2);
	 if(INDEX<=10) return pyramid(R,7,1,2,3,6,INDEX-6);
	 return pyramid(R,7,3,4,5,6,INDEX-10);
	 /*14 pieces*/
}


poly crook22(P,INDEX)
     poly P;
     int INDEX;
    {
      poly R;
      R.v[1]= crook0(P.v[2],P.v[3],1);
      R.v[2]= crook0(P.v[2],P.v[4],1);  
      R.v[3]= crook0(P.v[1],P.v[4],1);
      R.v[4]= crook0(P.v[1],P.v[3],1);
      R.v[5]= crook0(P.v[2],P.v[3],2);
      R.v[6]= crook0(P.v[2],P.v[4],2);  
      R.v[7]= crook0(P.v[1],P.v[4],2);
      R.v[8]= crook0(P.v[1],P.v[3],2);
      R.v[9]= average(8,R,1,2,3,4,5,6,7,8); 
      if(INDEX<=4) return(pyramid(R,9,1,2,3,4,INDEX-0)); 
      if(INDEX<=8) return(pyramid(R,9,5,6,7,8,INDEX-4));
      if(INDEX<=12) return(pyramid(R,9,1,2,6,5,INDEX-8));
      if(INDEX<=16) return(pyramid(R,9,2,3,7,6,INDEX-12));
      if(INDEX<=20) return(pyramid(R,9,3,4,8,7,INDEX-16));
      return(pyramid(R,9,4,1,5,8,INDEX-20));
      /*24 pieces*/
    }

poly crook23(P,INDEX)
     poly P;
     int INDEX;
    {
      poly R;
      R.v[1]= crook0(P.v[2],P.v[3],2);
      R.v[2]= crook0(P.v[2],P.v[4],2);  
      R.v[3]= crook0(P.v[1],P.v[4],2);
      R.v[4]= crook0(P.v[1],P.v[3],2);
      R.v[5]= crook0(P.v[2],P.v[3],3);
      R.v[6]= crook0(P.v[2],P.v[4],3);  
      R.v[7]= crook0(P.v[1],P.v[4],3);
      R.v[8]= crook0(P.v[1],P.v[3],3);
      R.v[9]= average(8,R,1,2,3,4,5,6,7,8); 
      if(INDEX<=4) return(pyramid(R,9,1,2,3,4,INDEX-0)); 
      if(INDEX<=8) return(pyramid(R,9,5,6,7,8,INDEX-4));
      if(INDEX<=12) return(pyramid(R,9,1,2,6,5,INDEX-8));
      if(INDEX<=16) return(pyramid(R,9,2,3,7,6,INDEX-12));
      if(INDEX<=20) return(pyramid(R,9,3,4,8,7,INDEX-16));
      return(pyramid(R,9,4,1,5,8,INDEX-20));
      /*24 pieces*/
    }


poly crook31(P,INDEX)
     poly P;
int INDEX;
    {
      poly R;
      R.v[1]=P.v[1];
      R.v[2] =crook0(P.v[1],P.v[2],1);
      R.v[3] =crook0(P.v[1],P.v[3],1);
      R.v[4] =crook0(P.v[1],P.v[4],1);
      if(INDEX!=1) printf("bad indexing\n");
      return tetra_make(R,1,2,3,4);
    }


poly crook32(P,INDEX)
     poly P;
     int INDEX;
{
         poly R;
         R=P;
         R.v[1] =crook0(P.v[1],P.v[2],1);
         R.v[2] =crook0(P.v[1],P.v[3],1);
         R.v[3] =crook0(P.v[1],P.v[4],1);
         R.v[4] =crook0(P.v[1],P.v[2],2);
         R.v[5] =crook0(P.v[1],P.v[3],2);
         R.v[6] =crook0(P.v[1],P.v[4],2);
         R.v[7]= average(6,R,1,2,3,4,5,6,1,1); 
         if(INDEX==1) return tetra_make(R,7,1,2,3); 
         if(INDEX==2) return tetra_make(R,7,4,5,6);
	 if(INDEX<=6) return pyramid(R,7,1,2,5,4,INDEX-2);
	 if(INDEX<=10) return pyramid(R,7,2,3,6,5,INDEX-6);
	 return pyramid(R,7,3,1,4,6,INDEX-10);
}


poly crook33(P,INDEX)
     poly P;
     int INDEX;
{
         poly R;
         R=P;
	 R.v[1] =crook0(P.v[1],P.v[2],2);
         R.v[2] =crook0(P.v[1],P.v[3],2);
         R.v[3] =crook0(P.v[1],P.v[4],2);
         R.v[4] =crook0(P.v[1],P.v[2],3);
         R.v[5] =crook0(P.v[1],P.v[3],3);
         R.v[6] =crook0(P.v[1],P.v[4],3);
         R.v[7]= average(6,R,1,2,3,4,5,6,1,1); 
         if(INDEX==1) return tetra_make(R,7,1,2,3); 
         if(INDEX==2) return tetra_make(R,7,4,5,6);
	 if(INDEX<=6) return pyramid(R,7,1,2,5,4,INDEX-2);
	 if(INDEX<=10) return pyramid(R,7,2,3,6,5,INDEX-6);
	 return pyramid(R,7,3,1,4,6,INDEX-10);
}


/**INDEX 1,...,42*/

poly CROOK1(P,INDEX)
poly P;
int INDEX;
{
  if(INDEX<1) printf("bad indexing CROOK1\n");
  if(INDEX>42) printf("bad indexing CROOK1\n");

  
  if(INDEX<=14) return crook11(P,INDEX-0);
  if(INDEX<=28) return crook12(P,INDEX-14);
  return crook13(P,INDEX-28);
}

/**INDEX 1,...,62*/

poly CROOK2(P,INDEX)
poly P;
int INDEX;
{

  if(INDEX<1) printf("bad indexing (<1) CROOK2\n");
  if(INDEX>62) printf("bad indexing (>62)  CROOK2\n");
  
  if(INDEX<=14) return crook21(P,INDEX-0);
  if(INDEX<=38) return crook22(P,INDEX-14);
  return crook23(P,INDEX-38);
}

poly CROOK3(P,INDEX)
poly P;
int INDEX;
{

  if(INDEX<1) printf("bad indexing (<1) CROOK3\n");
  if(INDEX>29) printf("bad indexing (>29)  CROOK3: index = %d\n",INDEX);

  
  if(INDEX<=1) return crook31(P,INDEX-0);
  if(INDEX<=15) return crook32(P,INDEX-1);
  return crook33(P,INDEX-15);
}



/**393 total*/

poly  TETRA(INDEX)
     int INDEX;
{
  if(INDEX<1) printf("bad indexing TETRA1");
  if(INDEX>393) printf("bad indexing TETRA1");
  if(INDEX<=7) return tetra(0,INDEX);
  if(INDEX<=49)  return CROOK1(tetra(0,8),INDEX-7);
  if(INDEX<=111) return CROOK2(tetra(0,9),INDEX-49);
  if(INDEX<=173) return CROOK2(tetra(0,10),INDEX-111);
  if(INDEX<=215) return CROOK1(tetra(0,11),INDEX-173);
  if(INDEX<=244) return CROOK3(tetra(0,12),INDEX-215);
  if(INDEX<=306) return CROOK2(tetra(0,13),INDEX-244);
  if(INDEX<=335) return CROOK3(tetra(0,14),INDEX-306);
  if(INDEX<=364) return CROOK3(tetra(0,15),INDEX-335);
  return CROOK3(tetra(0,16),INDEX-364);

}






/**This routine is just used for graphics*/

poly crook(P,typ,stage,INDEX) 
  poly P;
  int typ;
  int stage;
  int INDEX;
  {
    poly Q;
    if((typ==1)&&(stage==1)) Q=crook11(P,INDEX);
    if((typ==1)&&(stage==2)) Q=crook12(P,INDEX);
    if((typ==1)&&(stage==3)) Q=crook13(P,INDEX);
    if((typ==2)&&(stage==1)) Q=crook21(P,INDEX);
    if((typ==2)&&(stage==2)) Q=crook22(P,INDEX);
    if((typ==2)&&(stage==3)) Q=crook23(P,INDEX);
    if((typ==3)&&(stage==1)) Q=crook31(P,INDEX);
    if((typ==3)&&(stage==2)) Q=crook32(P,INDEX);
    if((typ==3)&&(stage==3)) Q=crook33(P,INDEX);
    return Q;
  }


int number_of_pieces_in_crook(typ,stage)
  int typ;
  int stage;
{
  int q;
  if((typ==1)&&(stage==1)) q=14;
  if((typ==1)&&(stage==2)) q=14;
  if((typ==1)&&(stage==3)) q=14;
  if((typ==2)&&(stage==1)) q=14;
  if((typ==2)&&(stage==2)) q=24;
  if((typ==2)&&(stage==3)) q=24;
  if((typ==3)&&(stage==1)) q=1;
  if((typ==3)&&(stage==2)) q=14;
  if((typ==3)&&(stage==3)) q=14;
  return q;
}
