


/*these are the routines which generate the pseudorandom
linear projection C^3 --> C^3 called L_n.  See Ch. 10 of
the paper.  The notation here somewhat matches that
in the paper.*/


double d(r)
double r;
{
double s,floor();
s=r-floor(r);
s=2.0*s-1.0;
return(s);
}



interval_complex z(p,q,n)
int p,q,n;
{
interval_complex zz;
double sqrt();
double nn,pp,qq;
nn=n;pp=p;qq=q;
zz=cx_convert(d(nn*sqrt(pp)),d(nn*sqrt(qq)));
return(zz);
}



interval_vector L(n,v)
int n;
interval_vector v;
{
  interval_vector w;
  w.a=cx_plus(cx_times(z(2,3,n),v.a),cx_times(z(5,7,n),v.b));
  w.b=cx_convert(0.0,0.0);
  w.c=v.c;
  return(w);
}




/*Take a segment in C3 and pseudorandomly project it into
  C2.  This makes an edge, in our terminology.*/

edge create_edge(n,v,w)
interval_vector v,w;
int n;
{
  interval_vector vv,ww;
  edge e;
  vv=L(n,v);
  ww=L(n,w);
  e.s[1][1]=vv.a;
  e.s[1][2]=vv.c;
  e.s[2][1]=ww.a;
  e.s[2][2]=ww.c;
  return(e);
}
 


/*This creates and edge whose projectivization is
  a ray connecting the projectivized barycenter to
  infinity.*/

edge create_last_edge(n,P)
     poly P;
     int n;
{
  interval_vector vv;
  edge e;
  vv=barycenter(P);
  vv=L(n,vv);
  e.s[1][1]=vv.a;
  e.s[1][2]=vv.c;
  e.s[2][1]=cx_convert(1.0,0.0);
  e.s[2][2]=cx_convert(0.0,0.0);
  return(e);
}
 





graph create_graph(n,P)
poly P;
int n;
{
graph G;
int i,j,count;
count=1;
for(i=1;i<=4;++i)
  {
  for(j=i+1;j<=4;++j)
    {
    G.e[count]=create_edge(n,P.v[i],P.v[j]);
    ++count;
    }
  }
 G.e[7]=create_last_edge(n,P);
G.l=6;
return(G);
}




/*This computes the number of intersections of
the last edge of G1 with three edges of 
G2.  It is only meaningful topologically when
the three edges in connection make a circuit.*/

int interior_test(G1,G2,a,b,c)
     graph G1,G2;
     int a,b,c;
{
  int total,test;
  total=0;
  test=generic_intersection_number(G1.e[7],G2.e[a]);
  if(test==-1) return(-1);
  total=total+test;
  test=generic_intersection_number(G1.e[7],G2.e[b]);
  if(test==-1) return(-1);
  total=total+test;
  test=generic_intersection_number(G1.e[7],G2.e[c]);
  if(test==-1) return(-1);
  total=total+test;
  return(total%2);
}




/*return of 1 indicates success */

int projection_test(n,P1,P2)
     int n;
     poly P1,P2;
{
  int test,i,j;  
  graph G1,G2;    
  integer_list L;
  G1=create_graph(n,P1);
  G2=create_graph(n,P2);
  for(i=1;i<=6;++i) 
    {
      for(j=1;j<=6;++j)
	{ 
	  test=edge_projection_test(G1.e[i],G2.e[j]);
	  //printf("%d %d %d\n",i,j,test);
	  if(test<1) return(-1);
	}
    }

  /*the triples of numbers, 1,2,4. etc, label the
    circuits of G2.  Compare the remark following
    the previous routine.*/

  test=interior_test(G1,G2,1,2,4);
  if(test!=0) return(-1);
  test=interior_test(G1,G2,1,3,5);
  if(test!=0) return(-1);
  test=interior_test(G1,G2,4,5,6);
  if(test!=0) return(-1);
  test=interior_test(G1,G2,2,3,6);
  if(test!=0) return(-1);

  test=interior_test(G2,G1,1,2,4);
  if(test!=0) return(-1);
  test=interior_test(G2,G1,1,3,5);
  if(test!=0) return(-1);
  test=interior_test(G2,G1,4,5,6);
  if(test!=0) return(-1);
  test=interior_test(G2,G1,2,3,6);
  if(test!=0) return(-1);
  return(1);
}








int multiple_projection_test(P1,P2,lim)
     poly P1,P2;
     int lim;
{
  int n;
  for(n=1;n<=lim;++n) 
    {
      if(projection_test(n,P1,P2)==1) return(n);
    }
  return(-1);
}



