
/***************************
****************************
This file contains the basic
structures.
******************************
******************************/




/**interval structures**/

typedef struct
{int a,b;} exact;

typedef struct
{double l,r;
  int bad;}
interval;






/*the code structure encodes the combinatorial
information about a particular vertex of our
complex*/

typedef struct
{int l,a[10],b[10],c[10];}
code;






/**algebraic structures*/

typedef struct
{interval x,y;}
interval_complex;

typedef struct 
{interval_complex a,b,c;
  code X;}
interval_vector;

typedef struct 
{interval_vector a,b,c;}
interval_matrix;

typedef struct
{interval_complex s[3][3];}
edge;






/*polyhedra*/

/*typically a poly is a tetrahedron.  Occasionally,
  we use polyhedra which have to 10 vectors. */

typedef struct
{interval_vector v[10];
 int l;}
poly;


/*I would like to have made the list go up to 400, but
this overloads my sparc ultra 10, and causes a
segmentation fault.  The result is that I have to
break up the final list of tetrahedra into 3 sets.

[Added 1-29-2030:  On my 2016 IMAC the damned thing
won't run unless the array size is set to 35  This
is too small to work without changing the code.].*/

typedef struct
{poly P[50];
int l;}
poly_list;



/*structures related to graphs*/

typedef struct
{int l;
  edge e[8];}
graph;

typedef struct
{
  int l;
  int n[8];
}
integer_list;







/**These structures are used only for the
   purposes of drawing pictures*/

typedef struct 
{double x,y;}
complex;

typedef struct 
{complex a,b,c;}
vector;

typedef struct 
{vector a,b,c;}
matrix;

typedef struct
{vector v[10];
 int l;}
plainpoly;

/*an arc is an arc of a circle*/

typedef struct
{complex center;
double radius;
int line;
complex z[5];
double angle1,angle2;}
arc;


/*a tcl_arc is an arc designed to be plotted by
  a tcl plotter*/

typedef struct
{complex corner1,corner2;
int line;
complex z[5];
double start,extent;}
tcl_arc;



/*structure for drawing the braid*/

typedef struct
{vector v[555];
 int l;}
tiling;

typedef struct
{int n;
 complex z;}
spot;


