#! /usr/local/bin/wish8.3  -f




####################GLOBAL VARIABLES################
proc variables {} {
global SELECT PosX PosY  TEST
for {set i 1} {$i<7} {incr i} {
set SELECT($i) 0
set PosX($i) 0
set PosY($i) 0 }
set TEST 0 
}
########################################################



#######################instructions#################
proc write_instructions {} {
.control1 create line 0 45 300 45 -fill white
.control1 create text 5 60  \
-text "Instructions:" -fill white -anchor w
.control1 create text 5 75  \
-text "1. Click either the 0 or 1 button." -fill white -anchor w
.control1 create text 5 90  \
-text "2. Click the white screen 6 or 5 times to specify" \
 -fill white -anchor w
.control1 create text 5 105 \
-text "two circular arcs, sharing 0 or 1 endpoints." -fill white -anchor w
.control1 create text 5 120 \
-text "3. Click one of the green squares to select a" -fill white -anchor w
.control1 create text 5 135 \
-text "control point on one of the arcs." -fill white -anchor w
.control1 create text 5 150 \
-text "4. Click the white screen again to move the" -fill white -anchor w
.control1 create text 5 165 \
-text "control point and thereby the arc." -fill white -anchor w
.control1 create text 5 180 \
-text "5. Repeat these steps in any order." -fill white -anchor w
.control1 create text 5 215 \
-text "Screen stays white if the arcs are disjoint." -fill white -anchor w
.control1 create text 5 230 \
-text "Screen turns yellow if the arcs intersect once."  \
-fill white -anchor w
.control1 create text 5 245 \
-text "Screen turns orange if the arcs intersect twice."  \
-fill white -anchor w
.control1 create text 5 270 \
-text "In this way we check that our circular arc test" -fill white \
-anchor w
.control1 create text 5 285 \
-text "works as claimed in the paper." -fill white -anchor w
}
####################################################




############BOARD SETUP##########################
proc board_setup {} {
canvas .plot1 -width 600 -height 600  
canvas .control1 -width 300 -height 450  
pack .plot1  -in .f1
pack .control1 -in .f2
.plot1 create rectangle 0 0 600 600 -fill white -tag backg
.control1 create rectangle 0 0 300 450 -fill #666
bind .plot1 <Any-Button> {
   disk %x %y
   update idletasks
   go }
}
########################################################





###########buttons##############################
proc make_buttons {} {
.control1 create rectangle 5 20 25 40  -fill blue -tag test1
.control1 create text 5 10 -text "common endpoints" \
-fill white -tag test11 -anchor w
.control1 create rectangle 85 20 105 40 \
  -fill blue -tag test2
.control1 create text 35 30 -text "0" -fill white
.control1 create text 75 30 -text "1" -fill white
.control1 bind test1 <Any-Button> {test_option 1}
.control1 bind test2 <Any-Button> {test_option 2}
}

proc test_option {x} {
global TEST SELECT
set TEST $x
.plot1 itemconfigure backg -fill white
.plot1 delete new
.control1 lower squares
for {set i 1} {$i<=9} {incr i} {
.plot1 delete temp$i
.control1 itemconfigure test$i -fill blue
.control1 itemconfigure p$i -fill green
set SELECT($i) 0 }
.control1 itemconfigure test$x -fill yellow
}
####################################################





###################################################
proc make_squares {} {
.control1 create rectangle 140 5 155 20 -fill green -tag p1
.control1 create rectangle 160 5 175 20 -fill green -tag p2
.control1 create rectangle 180 5 195 20 -fill green -tag p3
.control1 create rectangle 140 25 155 40 -fill green -tag p4
.control1 create rectangle 160 25 175 40 -fill green -tag p5
.control1 create rectangle 180 25 195 40 -fill green -tag p6
foreach name  {p1 p2 p3 p4 p5 p6} {
.control1 addtag squares withtag $name}
.control1 lower squares
for {set i 1} {$i<7} {incr i} {
.control1 bind p$i <Any-Button> {select} }
}
###################################################






#############main routine######################
proc arc_setup {} {
board_setup
variables
write_instructions
make_buttons
make_squares
}
###########################3#########################





#####################################################
proc select {} {
global SELECT
set a [.control1 gettags current]
set a [lindex $a 0]
for {set i 1} {$i<7} {incr i} {
.control1 itemconfigure p$i -fill green
.plot1 itemconfigure temp$i -fill green 
}
.control1 itemconfigure $a -fill magenta 
set a [string trim $a p]
set SELECT(2) $a
.plot1 itemconfigure temp$a -fill magenta
}
##########################################################






#################CREATE DISKS####################
proc disk {x y} {
global X Y TEST  SELECT PosX PosY UPDATE
set X $x
set Y $y
set UPDATE 0
if {$SELECT(1)==6} {set UPDATE 1}

if {$TEST==1} {
if {$SELECT(1)<=5} {
incr SELECT(1)
set col $SELECT(1)
.control1 raise p$col
set PosX($col) $X
set PosY($col) $Y
set x1 [expr $X-3]
set y1 [expr $Y-3]
set x2 [expr $X+3] 
set y2 [expr $Y+3]
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp$col
}

if {($SELECT(1)>=6)&&($SELECT(2)>0)} {
set col $SELECT(2) 
.plot1 delete temp${SELECT(2)}
set PosX($col) $X
set PosY($col) $Y
set x1 [expr $X-3]
set y1 [expr $Y-3]
set x2 [expr $X+3] 
set y2 [expr $Y+3]
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp$col
}}




if {$TEST==2} {
if {($SELECT(1)>0)&&($SELECT(1)<=5)} {
incr SELECT(1)
set col $SELECT(1)
.control1 raise p$col
set PosX($col) $X
set PosY($col) $Y
set x1 [expr $X-3]
set y1 [expr $Y-3]
set x2 [expr $X+3] 
set y2 [expr $Y+3]
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp$col
}

if {$SELECT(1)==0} {
set SELECT(1) 1
.control1 raise p1
set PosX(1) $X
set PosY(1) $Y
set PosX(4) $X
set PosY(4) $Y
set x1 [expr $X-3]
set y1 [expr $Y-3]
set x2 [expr $X+3] 
set y2 [expr $Y+3]
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp4
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp1
}

if {$SELECT(1)==3} {incr SELECT(1)}
set BASE 0
if {($SELECT(2)==1)||($SELECT(2)==4)} {set BASE 1}
if {($SELECT(1)>=6)&&($SELECT(2)>0)&&($BASE==0)} {
set col $SELECT(2) 
.plot1 delete temp${SELECT(2)}
set PosX($col) $X
set PosY($col) $Y
set x1 [expr $X-3]
set y1 [expr $Y-3]
set x2 [expr $X+3] 
set y2 [expr $Y+3]
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp$col
}

if {($SELECT(1)>=6)&&($SELECT(2)>0)&&($BASE==1)} {
set col $SELECT(2) 
.plot1 delete temp1
.plot1 delete temp4
set PosX(1) $X
set PosY(1) $Y
set PosX(4) $X
set PosY(4) $Y
set x1 [expr $X-3]
set y1 [expr $Y-3]
set x2 [expr $X+3] 
set y2 [expr $Y+3]
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp4
.plot1 create oval $x1 $y1 $x2 $y2 \
-fill green  -tag temp1
}}}
#########################################################







#############plot routine########################
proc go {} {
global SELECT UPDATE TEST  PosX PosY
if {$SELECT(1)>=6} {
.plot1 delete new
set outfile [open Graphics/Data/option w]
puts $outfile 1
close $outfile
set outfile [open Graphics/Data/in w]
puts $outfile $TEST
for {set i 1} {$i<7} {incr i} {
puts $outfile  $PosX($i)
puts $outfile  $PosY($i) }
close $outfile
update idletasks 
catch {exec Graphics/interface.o}
update idletasks
file_read .plot1 
if {$UPDATE == 1} {
for {set i 1} {$i<=6} {incr i} {
.plot1 itemconfigure temp$i -fill green  }
.plot1 itemconfigure temp${SELECT(2)} -fill magenta 
}}}
#############################################################


