

/*This file contains routines which start with a
triple of complex numbers (encoded as a vector)
and end with data for the circular arc which
is defined by this triple.   The first and third
points of the vector are the endpoints of the arc
and the second point is some point in the interior
of the arc.*/


/*first compute the denominator of the center of the
  circle containing the arc*/

interval denominator(v)
interval_vector v;
{
interval x1,x2,y1,y2,x3,y3;
interval S;
x1=v.a.x;
y1=v.a.y;
x2=v.b.x;
y2=v.b.y;
x3=v.c.x;
y3=v.c.y;
S=ZERO();
S=plus(S,times(x2,y1));
S=plus(S,times(x3,y2));
S=plus(S,times(x1,y3));
S=minus(S,times(y2,x1));
S=minus(S,times(y3,x2));
S=minus(S,times(y1,x3));
S=plus(S,S);
return(S);
}


/*now compute the numerator of the first coordinate*/


interval x_numerator(v)
interval_vector v;
{
interval x1,y1,x2,y2,x3,y3;
interval S;
x1=v.a.x;
y1=v.a.y;
x2=v.b.x;
y2=v.b.y;
x3=v.c.x;
y3=v.c.y;
S=ZERO();
S=plus(S,times(times(x2,x2),y1));
S=plus(S,times(times(x3,x3),y2));
S=plus(S,times(times(x1,x1),y3));
S=minus(S,times(times(x2,x2),y3));
S=minus(S,times(times(x3,x3),y1));
S=minus(S,times(times(x1,x1),y2));
S=plus(S,times(times(y2,y2),y1));
S=plus(S,times(times(y3,y3),y2));
S=plus(S,times(times(y1,y1),y3));
S=minus(S,times(times(y2,y2),y3));
S=minus(S,times(times(y3,y3),y1));
S=minus(S,times(times(y1,y1),y2));
return(S);
}

/*now compute the numerator of the second
  coordinate*/

interval y_numerator(v)
interval_vector v;
{
interval x1,y1,x2,y2,x3,y3;
interval S;
x1=v.a.x;
y1=v.a.y;
x2=v.b.x;
y2=v.b.y;
x3=v.c.x;
y3=v.c.y;
S=ZERO();
S=plus(S,times(times(x2,x2),x3));
S=plus(S,times(times(x3,x3),x1));
S=plus(S,times(times(x1,x1),x2));
S=minus(S,times(times(x2,x2),x1));
S=minus(S,times(times(x3,x3),x2));
S=minus(S,times(times(x1,x1),x3));
S=plus(S,times(times(y2,y2),x3));
S=plus(S,times(times(y3,y3),x1));
S=plus(S,times(times(y1,y1),x2));
S=minus(S,times(times(y2,y2),x1));
S=minus(S,times(times(y3,y3),x2));
S=minus(S,times(times(y1,y1),x3));
return(S);
}


/*now put together the previous three routines.*/

interval_complex center(v)
interval_vector v;
{
  interval_complex z;
  interval J1,J2,K;
  K=denominator(v);
  J1=x_numerator(v);
  J2=y_numerator(v);
  z.x=divide(J1,K);
  z.y=divide(J2,K);
  return(z);
}




/*once we know the center of the circle it is
easy to find the radius.  After we get the radius
we have to figure out the endpoints of the arc.
We use basic trig to do this.  Our routine is
not perfect.  If the arc is too straight the
center is too big.  We give some cutoff value.
Beyond the cutoff value we replace the arc by
a straight line segment.  In case the arc goes
through (or near) infinity, we represent it by
2 disconnected segments.  You should picture an
arrow sticking off the end of one of the segments,
pointing at infinity.
We emphasize that these routines are used for
drawing purposes only.  The arbitrary cutoff
value does not find its way into our calculations.
*/


arc circle(v)
vector v;
{
arc s;
double x1,x2,y1,y2,x3,y3;
double a1,a2,a3;
double den,fabs(),sqrt();
interval DEN;
interval_complex CENTER;
complex cen;
int test1,test2;
s.line=1;
x1=v.a.x;
y1=v.a.y;
x2=v.b.x;
y2=v.b.y;
x3=v.c.x;
y3=v.c.y; 
DEN=denominator(plain_to_interval(v));
den=DEN.l;
CENTER=center(plain_to_interval(v));
s.center.x=CENTER.x.l;
s.center.y=CENTER.y.l;
 cen=s.center;
s.radius=sqrt((cen.x-x1)*(cen.x-x1)+(cen.y-y1)*(cen.y-y1));
a1=new_atan(x1-cen.x,-y1+cen.y);
a2=new_atan(x2-cen.x,-y2+cen.y);
a3=new_atan(x3-cen.x,-y3+cen.y);

if(a1<=a3)
   {
   if(a2>=a1&a2<a3)  {s.angle1=a1;s.angle2=a3;}
   if(a2>=a3)        {s.angle1=a3;s.angle2=a1+2*Pi;}
   if(a2<=a1)        {s.angle1=a3;s.angle2=a1+2*Pi;}
   }
if(a3<=a1)
   {
   if(a2>=a3&a2<=a1) {s.angle1=a3;s.angle2=a1;}
   if(a2<=a3)        {s.angle1=a1;s.angle2=a3+2*Pi;}
   if(a2>=a1)        {s.angle1=a1;s.angle2=a3+2*Pi;}
   }
if((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)<.00001)
  {
  s.center=v.b;
  s.radius=0.0;
  s.angle1=0.0;
  s.angle2=0.0;
  }
s.line=0;
 if((fabs(den)<.0001)||(fabs(cen.x)>10000.0)||(fabs(cen.y)>10000.0))
  {
  s.line=1;
  test1=0;
  if((v.b.x>v.a.x)&&(v.b.x>v.c.x)) test1=1;
  if((v.b.x<v.a.x)&&(v.b.x<v.c.x)) test1=1;
  if((v.b.y>v.a.y)&&(v.b.y>v.c.y)) test1=1;
  if((v.b.y<v.a.y)&&(v.b.y<v.c.y)) test1=1;
  test2=1;
  if(fabs(v.b.x-v.a.x)>fabs(v.b.x-v.c.x)) test2=3;
  if(test1*test2==0)
      {
      s.z[1]=v.a;
      s.z[2]=v.b;
      s.z[3]=v.b;
      s.z[4]=v.c;
      }
  if(test1*test2==1)
      {
      s.z[1]=v.b;
      s.z[2]=v.a; 
      s.z[3]=v.c; 
      s.z[4].x=2.0*v.c.x-v.a.x;
      s.z[4].y=2.0*v.c.y-v.a.y;
      }
  if(test1*test2==3) 
      {
      s.z[1]=v.b;
      s.z[2]=v.c; 
      s.z[3]=v.a;
      s.z[4].x=2.0*v.a.x-v.c.x;
      s.z[4].y=2.0*v.a.y-v.c.y;
      }
  }
return(s);
}









/*Here we rescale and slightly reformat to
  get a data type acceptable to tcl*/


tcl_arc arc_to_tcl(a)
arc a;
{
tcl_arc ta;
ta.corner1.x=a.center.x-a.radius;
ta.corner1.y=a.center.y-a.radius;
ta.corner2.x=a.center.x+a.radius;
ta.corner2.y=a.center.y+a.radius;
ta.start=180.0*a.angle1/Pi;
ta.extent=180.0*(a.angle2-a.angle1)/Pi;
ta.line=a.line;
ta.z[1]=a.z[1];
ta.z[2]=a.z[2];
ta.z[3]=a.z[3];
ta.z[4]=a.z[4];
return(ta);
}

