
/*This file contains the specialized drawing routines.*/



/*this routine draws the projectivization of a
  segment which is a subset of C2.*/

void edge_project_draw(color,file,e)
     int color;
     FILE *file;
     edge e;

{
  interval_complex c[10];
  complex z;
  int i;
  double ii;
  for(i=0;i<=100;++i) 
    {
      ii=i;ii=ii/100.0;
      c[1]=cx_convert(ii,0.0);
      c[2]=cx_convert(1.0-ii,0.0);
      c[3]=cx_plus(cx_times(c[1],e.s[1][1]),cx_times(c[2],e.s[2][1]));
      c[4]=cx_plus(cx_times(c[1],e.s[1][2]),cx_times(c[2],e.s[2][2]));
      c[5]=cx_divide(c[3],c[4]);
      z=cx_interval_to_plain(c[5]);
      point_write(color,file,z);
    }
}

/*this routine does the same for graphs*/

void graph_project_draw(color,file,G)
    int color;
    FILE *file;
    graph G;
{
  int i;
  for(i=1;i<=G.l;++i) edge_project_draw(color,file,G.e[i]);
}










/*finds positive roots of Ax^2+Bx+C=0.  gives
error when roots are imaginary.  This case
should not arise in our computations */

interval polynomial_root(j,A,B,C)
     int j;
     interval A,B,C;
{
  interval four,X;
  four=double_to_interval(4.0);
  X=minus(times(B,B),times(four,times(A,C)));
  if(X.r<0) {printf("error in polynmomial_root routine\n");}
  X=sq_root(X);
  if(j==1) 
    {
    X=minus(X,B);
    X=divide(X,plus(A,A));
    }
  if(j==2) {
    X=plus(X,B);
    X=divide(X,plus(A,A));
    X=minus(ZERO(),X);
  }
  return(X);
}




/*this routine returns the null vector
interpolating between a negative
and a positive vector*/

interval_vector null_vector(neg,pos)
     interval_vector neg,pos;
{
  interval_complex nn,np,pn,pp;
  interval A,B,C,X1,X2,X,Y;
  interval_complex CX,CY;
  interval_vector N,P,U;
  nn=hermitian_dot(neg,neg);
  if(nn.x.l<=0) {N=neg;P=pos;}
  if(nn.x.l>=0) {N=pos;P=neg;}
  nn=hermitian_dot(N,N);
  pp=hermitian_dot(P,P);
  pn=hermitian_dot(P,N);
  np=hermitian_dot(N,P);
  A=minus(plus(nn.x,pp.x),plus(np.x,pn.x));
  B=minus(plus(np.x,pn.x),plus(pp.x,pp.x));
  C=pp.x;
  X1=polynomial_root(1,A,B,C);
  X2=polynomial_root(2,A,B,C);
  X=X2;
  if((X1.l>=0.0)&&(X1.l<=1.0)) X=X1;
  CX.x=X;
  CX.y=ZERO();
  CY.x=minus(double_to_interval(1.0),X);
  CY.y=ZERO();
  U=vec_plus(vec_scale(CX,N),vec_scale(CY,P));
  return(U);
}





/*Here is the elevation map, discussed in Ch 4.1 of the paper.*/


complex Psi(render,q)
     int render;
     interval_vector q;
{
  interval_matrix m;
  interval_complex zz[5];
  double r,exp(),sin(),cos();
  complex z[15];
  m.a=EiK();
  m.b=E0K();
  m.c=EpK();
  zz[1]=hermitian_dot(q,m.a);
  zz[2]=hermitian_dot(q,m.b);
  zz[3]=hermitian_dot(q,m.c);
  z[1]=cx_interval_to_plain(zz[1]);
  z[2]=cx_interval_to_plain(zz[2]);
  z[3]=cx_interval_to_plain(zz[3]);
  z[11].x=cxnorm(z[1]);z[11].y=0;
  z[12].x=cxnorm(z[2]);z[12].y=0;
  z[4]=cxplus(cxtimes(z[11],z[2]),cxtimes(z[12],z[1]));
  z[5]=cxdivide(z[3],z[4]);
  z[5].x=-z[5].x;
  z[5].y=-z[5].y;
  z[6].x=-arg(z[5]);


  z[6].y=cxnorm(cxdivide(z[1],z[2]));
  z[6].y=.5*log(z[6].y);
  if(render==1) return(z[6]);
  r=exp(z[6].y);
  z[7].x=r*cos(z[6].x);
  z[7].y=r*sin(z[6].x);
  return(z[7]);
}




/*this program deals with the problem of
  wrap on the cylinder.  The guide parameter
  prevents jumps in the arg function */


complex guided_Psi(guide,render,q)
     int render,guide;
     interval_vector q;
{
  interval_matrix m;
  interval_complex zz[15];
  double temp,r,exp(),sin(),cos();
  complex z[20];
  m.a=EiK();
  m.b=E0K();
  m.c=EpK();
  zz[1]=hermitian_dot(q,m.a);
  zz[2]=hermitian_dot(q,m.b);
  zz[3]=hermitian_dot(q,m.c);
  z[1]=cx_interval_to_plain(zz[1]);
  z[2]=cx_interval_to_plain(zz[2]);
  z[3]=cx_interval_to_plain(zz[3]);
  z[11].x=cxnorm(z[1]);z[11].y=0;
  z[12].x=cxnorm(z[2]);z[12].y=0;
  z[4]=cxplus(cxtimes(z[11],z[2]),cxtimes(z[12],z[1]));
  z[5]=cxdivide(z[3],z[4]);
  z[5].x=-z[5].x;
  z[5].y=-z[5].y;
  z[6].x=-arg(z[5]);
  temp=z[6].x;
  if((guide==0)&&(z[6].x>-0.5*Pi)) temp=z[6].x-2*Pi;
  if((guide==1)&&(z[6].x<-1.5*Pi)) temp=z[6].x+2*Pi;
  z[6].x=temp;
  z[6].y=cxnorm(cxdivide(z[1],z[2]));
  z[6].y=.5*log(z[6].y);
  if(render==1) return(z[6]);
  r=exp(z[6].y);
  z[7].x=r*cos(z[6].x);
  z[7].y=r*sin(z[6].x);
  return(z[7]);
}




/*This program draws solid (many-sided) polygons
which are part of the tiling of Z_0, discussed
in Ch 4.*/

void fill_mixed_draw(guide,render,joe,p,q,r)
int guide,render;
FILE *joe;
interval_vector p,q,r;
{
int i;
double ii;
interval_complex cq,cr;
complex z;
interval_vector v,w;

for(i=0;i<=40;++i)
  {
  ii=i;ii=ii/40.0;
  cq=cx_convert(ii,0.0);
  cr=cx_convert(1.0-ii,0.0);
  v=vec_plus(vec_scale(cq,q),vec_scale(cr,r));
  w=null_vector(p,v);
  z=guided_Psi(guide,render,w);
  simple_point_write(joe,z);
  }
}


/*first two vectors negative, second two positive*/

void fill_mixed_draw2(guide,render,joe,p,q,r,s)
int guide,render;
FILE *joe;
interval_vector p,q,r,s;
{
int i;
double ii;
interval_complex cq,cr;
complex z;
interval_vector v1,v2,w;

for(i=0;i<=40;++i)
  {
  ii=i;ii=ii/40.0;
  cq=cx_convert(ii,0.0);
  cr=cx_convert(1.0-ii,0.0);
  v1=vec_plus(vec_scale(cq,p),vec_scale(cr,q));
  v2=vec_plus(vec_scale(cq,r),vec_scale(cr,s));
  w=null_vector(v1,v2);
  z=guided_Psi(guide,render,w);
  simple_point_write(joe,z);
  }
}












void poly_mixed_draw(color,render,joe,P) 
     int render;
     FILE *joe;
     poly P;
{
 integer_list l1,l2;
 complex z;
 int guide;
 l1=negative_vertices(P);
 l2=positive_vertices(P);
 z=Psi(render,null_vector(P.v[l1.n[1]],P.v[l2.n[1]])); 
 guide=1;  
 if(z.x<-3.14159265) guide=0;

 pp(guide); 

 fprintf(joe,"4\n%d\n%d\n",color,1);

 if(l1.l==1) 
   {
    fill_mixed_draw(guide,render,joe,P.v[l1.n[1]],P.v[l2.n[1]],P.v[l2.n[2]]);
    fill_mixed_draw(guide,render,joe,P.v[l1.n[1]],P.v[l2.n[3]],P.v[l2.n[1]]);
    fill_mixed_draw(guide,render,joe,P.v[l1.n[1]],P.v[l2.n[2]],P.v[l2.n[3]]);
  }

 if(l2.l==1) 
   {
    fill_mixed_draw(guide,render,joe,P.v[l2.n[1]],P.v[l1.n[1]],P.v[l1.n[2]]);
    fill_mixed_draw(guide,render,joe,P.v[l2.n[1]],P.v[l1.n[3]],P.v[l1.n[1]]);
    fill_mixed_draw(guide,render,joe,P.v[l2.n[1]],P.v[l1.n[2]],P.v[l1.n[3]]);
  }


 if(l2.l==2) 
   {
    fill_mixed_draw(guide,render,joe,P.v[l1.n[1]],P.v[l2.n[2]],P.v[l2.n[1]]);
    fill_mixed_draw(guide,render,joe,P.v[l2.n[2]],P.v[l1.n[2]],P.v[l1.n[1]]);
    fill_mixed_draw(guide,render,joe,P.v[l1.n[2]],P.v[l2.n[1]],P.v[l2.n[2]]);
    fill_mixed_draw(guide,render,joe,P.v[l2.n[1]],P.v[l1.n[1]],P.v[l1.n[2]]);
  }

 fprintf(joe,"-999999999\n");
}






/*these routines find the null center of symmetry of
a symmetric tetrahedron with two positive and two negative
vectors. It is used to label the tiles */

interval_vector null_center (n1,n2,p1,p2)
     interval_vector n1,n2,p1,p2;
{
  interval_vector n,p,v;
  n=vec_plus(n1,n2);
  p=vec_plus(p1,p2);
  v=null_vector(n,p);
  return(v);
}

complex cx_null_center (render,n1,n2,p1,p2)
     int render;
     interval_vector n1,n2,p1,p2;
{
  interval_vector v;
  complex z;
  v=null_center(n1,n2,p1,p2);
  z=Psi(render,v);
  return(z);
}
  




/*this routine draws an the projection of an edge to C.
It is similar to the routine edge_project_draw, except
that it doesn't plot individual points but rather
uses the routines in circle.c*/

void projection_edge_draw(color,joe,e)
     int color;
     FILE *joe;
     edge e;
{
  interval_vector v;
  vector pv;
  arc a;
  tcl_arc ta;
  v=edge_to_vector(e);
  pv=interval_to_plain(v);
  a=circle(pv);
  ta=arc_to_tcl(a);
  arc_write(color,joe,ta);
}



/*this routine draws the projection of a polyhedron
  into the complex line stabilized by the shift K*/

void projection_graph_draw(color,joe,P)
     int color;
     FILE *joe;
     poly P;
{
  graph g;
  int i;
  g=cutoff_graph(P);
  for(i=1;i<=6;++i) projection_edge_draw(color,joe,g.e[i]);
}


void projection_unit_circle_draw(color,joe)
     int color;
     FILE *joe;
{
  graph g;
  g=unit_circle_graph();
  projection_edge_draw(color,joe,g.e[1]);
  projection_edge_draw(color,joe,g.e[2]);
}






/*thie routine intersects a tetrahedron with a
complex line.  The complex line 
is defined by the polar vector v.
The routine only works on tetrahedra within the
subdivision of a piece whose line of symmetry
is the complex line in question */

void plane_plot(color,joe,v,P)
int color;
FILE *joe;
interval_vector v;
poly P;
{
int i,total;
interval test;
edge e[5];
poly GOOD, BAD;
interval_vector w[10];
total=0;
GOOD.l=0;
BAD.l=0;

/*the variable total counts the number
  of vertices contained in the complex line*/

for(i=1;i<=4;++i)
  {
  test=cx_norm(hermitian_dot(P.v[i],v));
  if(test.l<.001) 
    {
    ++GOOD.l;
    GOOD.v[GOOD.l]=P.v[i];
    ++total;
    }

   
  if(test.l>.001) 
    {
    ++BAD.l;
    BAD.v[BAD.l]=P.v[i];
    }
   
  }




/*here an entire face is contained in the complex line*/

if(total==3)
  {
  w[1]=GOOD.v[1];
  w[2]=GOOD.v[2]; 
  w[3]=GOOD.v[3];
  w[4]=w[1];

  for(i=1;i<=3;++i)
    {
    e[i].s[1][1]=w[i].a;
    e[i].s[1][2]=w[i].c;
    e[i].s[2][1]=w[i+1].a;
    e[i].s[2][2]=w[i+1].c;
    }

  for(i=1;i<=3;++i) projection_edge_draw(color,joe,e[i]);
  }


/*here an edge is contained in the complex line.
Either the complex line bisects the other edge, or
not.  In the latter case we draw a triangle and
in the former case we just draw the single edge*/


if(total == 2)
  {
  w[1]=GOOD.v[1];
  w[2]=GOOD.v[2]; 
  w[3]=vec_plus(BAD.v[1],BAD.v[2]);
  w[4]=w[1];
  for(i=1;i<=3;++i)
    {
    e[i].s[1][1]=w[i].a;
    e[i].s[1][2]=w[i].c;
    e[i].s[2][1]=w[i+1].a;
    e[i].s[2][2]=w[i+1].c;
    }

  projection_edge_draw(color,joe,e[1]);
  test=cx_norm(hermitian_dot(w[3],v)); 
  if(test.l<.00001) 
    {
      projection_edge_draw(color,joe,e[2]);
      projection_edge_draw(color,joe,e[3]);
    }
  }

}
