

/*This file contains the routines which draw
  our tiles in different ways*/





/*These routines draw slices of our tiles by
  their complex lines of symmetry.  They are
  used to generate the pictures in Ch 8.  They
  are called upon by option 4 of our main routine,
  tile_plot, defined below*/


void slice_draw(color,joe,piece,P)
     int color,piece;
     FILE *joe;
     poly P;
{
 interval_vector v;
 if(piece == 1) v=hermitian_cross(neg(2),neg(0));  /*B1*/
 if(piece == 2) v=hermitian_cross(pos(-5),pos(5)); /*A0*/
 if(piece == 3) v=hermitian_cross(pos(-8),pos(8)); /*B0*/
 if(piece == 4) v=hermitian_cross(pos(-7),pos(9)); /*A1*/
 plane_plot(color,joe,v,P);
}



void slice_circle_draw(color,joe,piece)
     int color,piece;
     FILE *joe;
{
 interval_vector v[5];
 vector w,ww;
 arc av;
 int i;
 tcl_arc tav;

 /*first find 3 null vectors in the slice:v[2],v[3],v[4]*/

 if(piece == 1) /*B1*/ 
   {
     v[1]=vec_minus(neg(-1),neg(2));
     v[2]=null_vector(v[1],neg(0));
     v[3]=null_vector(v[1],neg(2));
     v[4]=null_vector(v[1],neg(3));
   }

 if(piece == 2) /*A0*/
   {
     v[1]=pos(0); 
     v[2]=null_vector(v[1],neg(-2));
     v[3]=null_vector(v[1],neg(2));
     v[4]=null_vector(v[1],neg(7));
   }

 if(piece == 3) /*B0*/
   {
     v[1]=pos(8);
     v[2]=null_vector(v[1],neg(-5));
     v[3]=null_vector(v[1],neg(5));
     v[4]=null_vector(v[1],vec_plus(neg(5),neg(-5)));
   }

 if(piece == 4) /*A1*/
   {
     v[1]=neg(1);
     v[2]=null_vector(v[1],pos(-7));
     v[3]=null_vector(v[1],pos(9));
     v[4]=null_vector(v[1],vec_plus(pos(-7),pos(9)));
   }

 

 w.a=cx_interval_to_plain(cx_divide(v[2].a,v[2].c));
 w.b=cx_interval_to_plain(cx_divide(v[3].a,v[3].c));
 w.c=cx_interval_to_plain(cx_divide(v[4].a,v[4].c));
 ww=w;
 av=circle(ww);
 tav=arc_to_tcl(av);        
 arc_write(color,joe,tav);
 ww.a=w.b; 
 ww.b=w.c;
 ww.c=w.a;
 av=circle(ww); 
 tav=arc_to_tcl(av); 
 arc_write(color,joe,tav);  
 ww.a=w.c;
 ww.b=w.a;
 ww.c=w.b;
 av=circle(ww); 
 tav=arc_to_tcl(av); 
 arc_write(color,joe,tav); 

}





/*These routines draw the basic tiles of Z_0.  They
  are used to generate the pictures in Ch 4.*/




void tile(ren,c1,c2,c3,c4,c5,joe,g,p) 
     int ren,c1,c2,g,p;
     FILE *joe;
{
  interval_vector v;
  complex z;
  int guide;
  guide=1;
  if(p==0) 
    { 
      /*compute the guide*/
      z=cx_null_center(ren,neg(3+2*g),neg(-3+2*g),pos(-5+2*g),pos(5+2*g));
      if(z.x<-3.14159265) guide=0;

      /*tile*/

      fprintf(joe,"4\n%d\n%d\n",c1,c2);
      fill_mixed_draw(guide,ren,joe,pos(-5+2*g),neg(-3+2*g),neg(-7+2*g));
      fill_mixed_draw(guide,ren,joe,neg(-3+2*g),pos(+0+2*g),pos(-5+2*g));
      fill_mixed_draw(guide,ren,joe,neg(-3+2*g),pos(+5+2*g),pos(+0+2*g));
      fill_mixed_draw(guide,ren,joe,pos(+5+2*g),neg(+7+2*g),neg(-3+2*g));
      fill_mixed_draw2(guide,ren,joe,
		          neg(-7+2*g),neg(+7+2*g),pos(-5+2*g),pos(+5+2*g));
      fprintf(joe,"-999999999\n");
      fprintf(joe,"4\n%d\n%d\n",c3,c4);
      fill_mixed_draw(guide,ren,joe,pos(+5+2*g),neg(+3+2*g),neg(+7+2*g));
      fill_mixed_draw(guide,ren,joe,neg(+3+2*g),pos(+0+2*g),pos(+5+2*g));
      fill_mixed_draw(guide,ren,joe,neg(+3+2*g),pos(-5+2*g),pos(+0+2*g));
      fill_mixed_draw(guide,ren,joe,pos(-5+2*g),neg(-7+2*g),neg(+3+2*g));
      fill_mixed_draw2(guide,ren,joe,
		          neg(+7+2*g),neg(-7+2*g),pos(+5+2*g),pos(-5+2*g));
      fprintf(joe,"-999999999\n");


      /*line of symmetry*/
      fprintf(joe,"4\n%d\n%d\n",c5,c5);
      fill_mixed_draw2(guide,ren,joe,
		       neg(-7+2*g),neg(+7+2*g),pos(-5+2*g),pos(+5+2*g));
      fill_mixed_draw2(guide,ren,joe,
		       neg(+7+2*g),neg(-7+2*g),pos(+5+2*g),pos(-5+2*g));
      fprintf(joe,"-999999999\n");


      /*tile_label*/
      fprintf(joe,"5\n");
      plot(1,joe,z);
      fprintf(joe,"A%d\n",2*g);
    }



  if(p==1) 
    { 
      /*compute the guide*/
      z=cx_null_center(ren,neg(1+2*g),neg(1+2*g),pos(-2+2*g),pos(4+2*g));
      if(z.x<-3.14159265) guide=0;
      /*tile*/
       fprintf(joe,"4\n%d\n%d\n",c1,c2);
       fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(-2+2*g),pos(+9+2*g));
       fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(-7+2*g),pos(-2+2*g));
       fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(+9+2*g),pos(-7+2*g));
       fprintf(joe,"-999999999\n");
       fprintf(joe,"4\n%d\n%d\n",c3,c4);
       fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(+4+2*g),pos(-7+2*g));
       fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(+9+2*g),pos(+4+2*g));
       fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(-7+2*g),pos(+9+2*g));
       fprintf(joe,"-999999999\n");

      /*line of symmetry*/  
      fprintf(joe,"4\n%d\n%d\n",c5,c5);
      fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(+9+2*g),pos(-7+2*g));
      fill_mixed_draw(guide,ren,joe,neg(1+2*g),pos(-7+2*g),pos(+9+2*g));
      fprintf(joe,"-999999999\n");

      /*tile_label*/
      fprintf(joe,"5\n");
      z=cx_null_center(ren,neg(1+2*g),neg(1+2*g),pos(-2+2*g),pos(4+2*g));
      plot(1,joe,z);
      fprintf(joe,"A%d\n",2*g+1);
    }


  if(p==2) 
    {    
     
      /*compute the guide*/  
      z=cx_null_center(ren,neg(5+2*g),neg(-5+2*g),pos(-3+2*g),pos(3+2*g));
      if(z.x<-3.14159265) guide=0;

      /*tile*/
      fprintf(joe,"4\n%d\n%d\n",c1,c2);
      fill_mixed_draw(guide,ren,joe,neg(+5+2*g),pos(-3+2*g),pos(+8+2*g));
      fill_mixed_draw(guide,ren,joe,pos(-3+2*g),neg(-5+2*g),neg(+5+2*g));
      fill_mixed_draw(guide,ren,joe,neg(-5+2*g),pos(-8+2*g),pos(-3+2*g));   
      fill_mixed_draw2(guide,ren,joe,
                      neg(+5+2*g),neg(-5+2*g),pos(+8+2*g),pos(-8+2*g));
      fprintf(joe,"-999999999\n");
      fprintf(joe,"4\n%d\n%d\n",c3,c4);
      fill_mixed_draw(guide,ren,joe,neg(-5+2*g),pos(+3+2*g),pos(-8+2*g));
      fill_mixed_draw(guide,ren,joe,pos(+3+2*g),neg(+5+2*g),neg(-5+2*g));
      fill_mixed_draw(guide,ren,joe,neg(+5+2*g),pos(+8+2*g),pos(+3+2*g)); 
      fill_mixed_draw2(guide,ren,joe,
		      neg(-5+2*g),neg(+5+2*g),pos(-8+2*g),pos(+8+2*g));
      fprintf(joe,"-999999999\n");

      /*line of symmetry*/
      fprintf(joe,"4\n%d\n%d\n",c5,c5);
      fill_mixed_draw2(guide,ren,joe,
		       neg(-5+2*g),neg(+5+2*g),pos(-8+2*g),pos(+8+2*g));
      fill_mixed_draw2(guide,ren,joe,
		       neg(+5+2*g),neg(-5+2*g),pos(+8+2*g),pos(-8+2*g));
      fprintf(joe,"-999999999\n");



      /*tile_label*/
      fprintf(joe,"5\n");
      z=cx_null_center(ren,neg(5+2*g),neg(-5+2*g),pos(-3+2*g),pos(3+2*g));
      plot(1,joe,z);
      fprintf(joe,"B%d\n",2*g);
    }
}





/**draws all the tetrahedra in the stage*/
void projection_block_draw(P1,stage,file3,color1)
     poly P1;
     int stage;
     FILE *file3;
     int color1;
{
  int i,typ,num;
  poly Q;
  typ=type(P1);
  num=number_of_pieces_in_crook(typ,stage);
  for(i=1;i<=num;++i) 
    {
    Q=crook(P1,typ,stage,i);
    projection_graph_draw(color1,file3,Q);
    }
}


/**draws all the tetrahedra in the stage*/
void slice_block_draw(P1,stage,file3,test,color1)
     poly P1;
     int stage;
     FILE *file3;
     int test;
     int color1;
{
  int i,typ,num;
  poly Q;
  typ=type(P1);
  num=number_of_pieces_in_crook(typ,stage);
  for(i=1;i<=num;++i) 
    {
    Q=crook(P1,typ,stage,i);
    slice_draw(color1,file3,test,Q);
    }
}







/**this is the main routine.  There are 4 separate levels.
   Each level is unrelated to the other ones*/


void tile_plot()
{
  FILE *file0, *file1, *file2, *file3, *file4, *fopen();
  int coord, render, color1, color2,color3,color4,color5,color6,color7;
  int i,j,test;
  int level, group_power, piece,  typ, stage, crk;
  poly P1;
  poly_list X;
  
  file0=fopen("Graphics/Data/coord","r");
  file1=fopen("Graphics/Data/in","r");
  file2=fopen("Graphics/Data/out1","w");
  file3=fopen("Graphics/Data/out2","w"); 
  file4=fopen("Graphics/Data/out3","w");

  fscanf(file1,"%d",&level);
  fscanf(file1,"%d",&group_power);
  fscanf(file0,"%d",&coord);
  fscanf(file0,"%d",&render);
  fscanf(file0,"%d",&color1);
  fscanf(file0,"%d",&color2);
  fscanf(file0,"%d",&color3);
  fscanf(file0,"%d",&color4);
  fscanf(file0,"%d",&color5);
  fscanf(file0,"%d",&color6);
  fscanf(file0,"%d",&color7);


  /************************************/
  if(render<=2) {
    
  fprintf(file2,"100\n");

  if(level==1)
    {
    fscanf(file1,"%d",&piece); 
    fscanf(file1,"%d",&typ);
    fscanf(file1,"%d",&stage);
    fscanf(file1,"%d",&crk);
    P1=tetra(group_power,piece);
    P1=crook(P1,typ,stage,crk);
    print_tetra_code(file4,P1);
    poly_mixed_draw(color1,render,file3,P1);

    }

  if(level==2) 
    {
    fscanf(file1,"%d",&piece);
    P1=tetra(group_power,piece);   
    print_tetra_code(file4,P1);
    poly_mixed_draw(color1,render,file3,P1);
    }

  if(level==3) 
    {
    fscanf(file1,"%d",&piece);
    tile(render,color1,color2,color3,color4,color5,file3,group_power,piece);
    }

  if(level==4) 
    {
      if(color7<=6) 
	{
        tile(render,color1,1,color2,1,color7,file3,group_power,0); 
        tile(render,color3,1,color4,1,color7,file3,group_power,1); 
        tile(render,color5,1,color6,1,color7,file3,group_power,2); 
	}  
        if(color7>=7) 
	{
        tile(render,color1,1,color2,1,color2,file3,group_power,0); 
        tile(render,color3,1,color4,1,color4,file3,group_power,1); 
        tile(render,color5,1,color6,1,color6,file3,group_power,2); 
	}
    }

  if(level==5) 
    {    
      j=group_power+10;
      pp(j);
      for(i=-j;i<=j;++i)
       {    
        if(color7<=6) 
	  {
          tile(render,color1,1,color2,1,color7,file3,i,0); 
          tile(render,color3,1,color4,1,color7,file3,i,1); 
          tile(render,color5,1,color6,1,color7,file3,i,2); 
	  }  
        if((color7>=7) && (color7<=11))
	  {
          tile(render,color1,1,color2,1,color2,file3,i,0); 
          tile(render,color3,1,color4,1,color4,file3,i,1); 
          tile(render,color5,1,color6,1,color6,file3,i,2); 
	  }   
        if(color7>=12)
	  {
          tile(render,color1,color1,color2,color2,color2,file3,i,0); 
          tile(render,color3,color3,color4,color4,color4,file3,i,1); 
          tile(render,color5,color6,color6,color6,color6,file3,i,2); 
	  }

       }
    }
  }




  /*draws projection onto K-eigenspace*/
  /*******************************************/
  if(render==3) {


  if(level==1)
    {
    fscanf(file1,"%d",&piece);
 
    if(piece<=7) {
      P1=tetra(group_power,piece);      
      print_tetra_code(file4,P1); 
    }

    if(piece>=8) {
      fscanf(file1,"%d",&typ);
      fscanf(file1,"%d",&stage);
      fscanf(file1,"%d",&crk);
      P1=tetra(group_power,piece);
      P1=crook(P1,typ,stage,crk);
      print_tetra_code(file4,P1);
    }

    projection_graph_draw(color1,file3,P1);
    test=inside_unit_circle(P1); 
    if(test==1)   fprintf(file2,"7\n");
    test=outside_unit_circle(P1); 
    if(test==1)   fprintf(file2,"8\n");
    fprintf(file2,"100\n");
    }



 if(level==2)
    {
    fscanf(file1,"%d",&piece);  
    fprintf(file2,"100\n");

    if(piece<=7) {
      P1=tetra(group_power,piece);   
      projection_graph_draw(color1,file3,P1);
    }

    if(piece>=8) {
    P1=tetra(group_power,piece);  
    typ=type(P1);
    for(stage=1;stage<=3;++stage) projection_block_draw(P1,stage,file3,color1);
    }
    }

 
 if(level==3)
   {
   fscanf(file1,"%d",&piece);
   /*in this case piece=0,1,2,3,4*/
   fprintf(file2,"100\n");
   if(piece==0) 
     {
     for(i=8;i<=11;++i) 
       {
       P1=tetra(group_power,i);
       typ=type(P1);
       for(stage=1;stage<=3;++stage) projection_block_draw(P1,stage,file3,color1);
       }
     }

   if(piece==1) 
     {
     for(i=15;i<=16;++i) 
       {
       P1=tetra(group_power,i);
       typ=type(P1);
       for(stage=1;stage<=3;++stage)  projection_block_draw(P1,stage,file3,color1);
       }
     }


   if(piece==2) 
     {
     for(i=12;i<=14;++i) 
       {
       P1=tetra(group_power,i);
       typ=type(P1);
       for(stage=1;stage<=3;++stage)  projection_block_draw(P1,stage,file3,color1);
       }
     }
   

   if(piece==3) 
     {
     for(i=5;i<=7;++i) 
       {
       P1=tetra(group_power,i);
       projection_graph_draw(color1,file3,P1);
       }
     }



   if(piece==4) 
     {
     for(i=1;i<=4;++i) 
       {
       P1=tetra(group_power,i);
       projection_graph_draw(color1,file3,P1);
       }
     }

   }



   if(level==4)
     {  
       fprintf(file2,"100\n");
       for(i=1;i<=7;++i)
	 {
         P1=tetra(group_power,i);
         projection_graph_draw(color1,file3,P1);
	 }

       for(i=8;i<=16;++i) 
       {
       P1=tetra(group_power,i);
       typ=type(P1);
       for(stage=1;stage<=3;++stage)   projection_block_draw(P1,stage,file3,color1);
       }
     }

  projection_unit_circle_draw(color2,file3);
 
  }






  /*draws slices of pieces*/
  /*****************************************/
  if(render==4)   
    {
    fprintf(file2,"100\n");

    if(level==1) 
      {
      fscanf(file1,"%d",&piece); 
      if(piece<=4) test=1;
      if((piece>=5)&&(piece<=11)) test=2;
      if((piece>=12)&&(piece<=14)) test=3;
      if(piece>=15) test=4;

      if(piece<=7) {
      P1=tetra(group_power,piece);      
      print_tetra_code(file4,P1); 
      }

      if(piece>=8) {
      fscanf(file1,"%d",&typ);
      fscanf(file1,"%d",&stage);
      fscanf(file1,"%d",&crk);
      P1=tetra(group_power,piece);
      P1=crook(P1,typ,stage,crk);
      print_tetra_code(file4,P1);
      }

      slice_draw(color1,file3,test,P1); 
      slice_circle_draw(color2,file3,test);
      }


 if(level==2)
    {
    fscanf(file1,"%d",&piece);  
    fprintf(file2,"100\n");  
    if(piece<=4) test=1;
    if((piece>=5)&&(piece<=11)) test=2;
    if((piece>=12)&&(piece<=14)) test=3;
    if(piece>=15) test=4;

    if(piece<=7) {
      P1=tetra(group_power,piece);   
      slice_draw(color1,file3,test,P1); 
      slice_circle_draw(color2,file3,test);
    }

    if(piece>=8) {
    P1=tetra(group_power,piece);  
    if(color3!=1) slice_draw(color3,file3,test,P1);
    typ=type(P1);
    for(stage=1;stage<=3;++stage) slice_block_draw(P1,stage,file3,test,color1);
    if(color3==1) slice_draw(color3,file3,test,P1);
    }
    }

    
 if(level==3)
   {
   fscanf(file1,"%d",&piece);

   fprintf(file2,"100\n");
   
   if(piece==0) 
     {  
     slice_circle_draw(color2,file3,2);
     for(i=8;i<=11;++i) 
       {
       P1=tetra(group_power,i);
       typ=type(P1);
       for(stage=1;stage<=3;++stage)  slice_block_draw(P1,stage,file3,2,color1);
       }
     }


   if(piece==1) 
     {
     for(i=15;i<=16;++i) 
       {  
       slice_circle_draw(color2,file3,4);
       P1=tetra(group_power,i);
       typ=type(P1);
       for(stage=1;stage<=3;++stage)  slice_block_draw(P1,stage,file3,4,color1);
       }
     }

   if(piece==2) 
     {
     for(i=12;i<=14;++i) 
       { 
       slice_circle_draw(color2,file3,3);
       P1=tetra(group_power,i);
       typ=type(P1);
       for(stage=1;stage<=3;++stage)  slice_block_draw(P1,stage,file3,3,color1);
       }
     }

   if(piece==3) 
     {
     for(i=5;i<=7;++i) 
       {  
        slice_circle_draw(color2,file3,2);
        P1=tetra(group_power,i);
        slice_draw(color1,file3,2,P1); 
       }
     }



   if(piece==4) 
     {
     for(i=1;i<=4;++i) 
       {  
       slice_circle_draw(color2,file3,1);
       P1=tetra(group_power,i);
       slice_draw(color1,file3,1,P1); 
       }
     }

   }


    }
 
  fclose(file0);
  fclose(file1);
  fclose(file2);
  fclose(file3); 
  fclose(file4);



}
