#! /usr/local/bin/wish8.3  -f





###############postscript###########################
proc postscript_setup {} {
global POSTSCRIPT_SIZE FRAME
set POSTSCRIPT_SIZE 400
set FRAME 1
.control2 create rectangle 240 390 300 450  \
-fill black -outline white -tag ps_frame
.control2 create rectangle 250 400 290 440  \
-fill blue  -tag ps 
.control2 bind ps <Button-2> do_postscript
.control2 bind ps <Button-1> postscript_up
.control2 bind ps <Button-3> postscript_down
.control2 bind ps_frame <Any-Button> toggle_frame
}


proc toggle_frame {} {
global FRAME
set temp [expr 1-$FRAME]
if {$temp==0} {.control2 itemconfigure ps_frame -outline black}
if {$temp==1} {.control2 itemconfigure ps_frame -outline white}
set FRAME $temp
}


proc postscript_up {} {
global POSTSCRIPT_SIZE
set temp [expr $POSTSCRIPT_SIZE/.95]
if {$temp<600} {
set POSTSCRIPT_SIZE $temp
.control2 scale ps 270 420 [expr 1/.95] [expr 1/.95]
}
}

proc postscript_down {} {
global POSTSCRIPT_SIZE
set temp [expr $POSTSCRIPT_SIZE*.95]
if {$temp>60} {
set POSTSCRIPT_SIZE $temp
.control2 scale ps 270 420 .95 .95
}
}


proc do_postscript {} {
global POSTSCRIPT_SIZE FRAME COL COLOR
if {$FRAME==1} {
.plot2 create line 0 0 0 600 -fill black -tag temp
.plot2 create line 0 0 600 0 -fill black -tag temp
.plot2 create line 600 600 0 600 -fill black -tag temp
.plot2 create line 600 600 600 0 -fill black -tag temp
update idletasks
}
.plot2 postscript  -file "temp.ps" -pageheight $POSTSCRIPT_SIZE \
 -height 600 -width 600 \
-colormode color
update idletasks
.plot2 delete temp
}




##################################################





################board set_up#######################
proc board_setup {} {
canvas .plot2 -width 600 -height 600  
canvas .control2 -width 300 -height 450  
pack .plot2  -in .f1
pack .control2 -in .f2
.plot2 create rectangle -200 -200 800 800 -fill white -tag backg
.control2 create rectangle 0 0 300 450 -fill black
source Graphics/piece.t
piece_setup 0 70
}
##################################################







################constants#######################
proc define_constants {} {
global COLOR SCALE MOVE_X MOVE_Y COORD TEXT

set TEXT 1
set COORD 1
set COLOR(1) 1
set COLOR(2) 1
set COLOR(3) 1
set COLOR(4) 1
set COLOR(5) 1
set COLOR(6) 1
set COLOR(7) 1
set COLOR(8) 6


set Pi 3.14159265
set SCALE  90
set MOVE_X 0
set MOVE_Y 0
}
##################################################






##################################################
proc color_select {} {
global COLOR COL COORD
set x [.control2 gettags current]
set x [lindex $x 0]
set xx [lindex $x 1]
set y [string range $x 1 1]
set l [string length $x]
incr l -1
set x [string range $x 3 $l]
for {set i 1} {$i<18} {incr i} {
.control2 itemconfigure C$y,$i -outline black }
.control2 itemconfigure C$y,$x -outline white
set COLOR($y) $x
if {$y==8} {.plot2 itemconfigure backg -fill $COL($x)}
}
##################################################




###########make color boxes##################################
proc make_color_boxes {} {
global COL

.control2 create rectangle 0 313 300 450 -fill #456
for {set k 1} {$k<=8} {incr k} {
for {set i 1} {$i<17} {incr i} {
.control2 create rectangle  \
 [expr 3.5*$i] [expr 4*$k-3] [expr 3+3.5*$i]  [expr 4*$k] \
-fill $COL($i) -tag C${k},$i
.control2 addtag C$k withtag C${k},$i 
}
.control2 addtag C withtag C$k
.control2 itemconfigure C${k},1  -outline white
}

.control2 scale C 0 0 4 4
.control2 move C -10 315
.control2 bind C <Any-Button> {color_select}
.control2 itemconfigure C8,1  -outline black
.control2 itemconfigure C8,6  -outline white
}
###########################################################





###########################some buttons###################
proc button_setup {} {
global COL COLOR SCALE MOVE_X MOVE_Y COORD RENDER TEXT

.control2 create text 275 150 -text "plot" \
 -fill white -tag SEND -anchor e
.control2 create rectangle 298 160 278 140 -fill red -tag SEND
.control2 lower SEND
.control2 bind SEND <Any-Button> {go}

.control2 create text 272 177 -text "labels" -fill white -anchor e
.control2 create rectangle 298 165 278 185 -fill #567 -tag Tex
.control2 bind Tex <Any-Button> {raise_or_lower_text}
}


proc  raise_or_lower_text {} {
global TEXT
if {$TEXT==1} {.plot2 lower labels2}
if {$TEXT==0} {.plot2 raise labels2}
set temp [expr 1-$TEXT]
set TEXT $temp
}
#################################################



#########################choice dependent modifications##############
proc special_changes {} {
global RENDER
if {$RENDER ==1} {
.plot2 create oval 580 300 580 300 -tag origin
.plot2 addtag image withtag origin
.plot2 create rectangle 580 -500 1580 1500 -fill white -tag blinders
.plot2 create rectangle 14.5133 -500 -500 1500 -fill white -tag blinders
.plot2 addtag image withtag blinders

}

if {$RENDER >=2} {
.plot2 create oval 300 300 300 300 -tag origin
.plot2 addtag image withtag origin
}

if {$RENDER >=3} {
foreach name {C4 C5 C6 C7 X5} {
.control2 lower $name }
}

if {$RENDER ==4} {
.control2 lower X4
}

}
###################################################




###########################SCALING####################
proc scale_setup {} {
global RENDER
special_changes


bind .plot2 <Button-1> {location %x %y
                        scale_up}
bind .plot2 <Button-3> {location %x %y
                        scale_down}
}

proc location {x y} {
global X_POS Y_POS
set X_POS $x
set Y_POS $y
}


proc scale_up {} {
global X_POS Y_POS SCALE
set sc [expr 1/.9]
if {$SCALE<10000} \
{set SCALE [expr $SCALE*$sc]
.plot2 scale image $X_POS $Y_POS $sc $sc}
}

proc scale_down {} {
global X_POS Y_POS SCALE 
set sc [expr .9]
if {$SCALE>.001} \
{set SCALE [expr $SCALE*$sc]
.plot2 scale image $X_POS $Y_POS $sc $sc}
}
####################################################





############################plot routine####################

proc go {} {
global COORD RENDER SCALE MOVE_X MOVE_Y COLOR
##
set outfile [open Graphics/Data/option w]
puts $outfile 2
close $outfile
##
set outfile [open Graphics/Data/coord w]
puts $outfile $COORD
puts $outfile $RENDER
for {set i 1} {$i<=7} {incr i} {puts $outfile $COLOR($i) }
close $outfile
##
.control2 delete labels
catch {exec Graphics/interface.o}
file_read .plot2 
update idletasks
text_read .control2
.plot2 scale new 0 0 $SCALE $SCALE
set x [.plot2 coords origin]
set MOVE_X [lindex $x 0]
set MOVE_Y [lindex $x 1]
.plot2 move new $MOVE_X $MOVE_Y
.plot2 addtag image withtag new
.plot2 addtag labels2 withtag labels
.plot2 dtag new
.plot2 dtag labels
}
##############################################################







############main routine##########################
proc tile_setup {} {
board_setup
define_constants
button_setup
make_color_boxes
scale_setup 
postscript_setup
}  
##############################################################

  

