#! /usr/local/bin/wish8.3  -f


#This is a tcl plotter which reads in the file out_to_tcl and
#plots a picture. 
#the file out_to_tcl is generated by the file
#tiling_pix_tcl






#########################setup board#######################
frame .f
pack .f
canvas .plot -width 800 -height 800
pack .plot 
.plot create rectangle 0 0 800 800 -fill white -tag back

bind .plot <Button-1> {location1 %x %y
                       up_scale}
bind .plot <Button-3> {location1 %x %y
                       down_scale}
#####################################################





####################postscript##################
#pageheight controls size of picture
bind .plot <Button-2> {post}
proc post {} {
.plot postscript  -file "temp.ps" -pageheight 380 \
 -height 800 -width 800 \
-colormode color
update idletasks
}
################################################








########colors and initial scale values###########################
set ACOORD1 0
set BCOORD1 0
set SCALE1 1
set COL(0) red
set COL(1) black
set COL(2) #888
set COL(3) #ddd
set COL(4) #999
set COL(5) yellow
set COL(6) black
set COL(7) #ff0
set COL(8) #db0
set COL(9) #06f
set COL(10) #00f
set COL(11) #f00
set COL(12) #b00
set COL(13) #0f2
set COL(14) #0a0
set COL(15) #f0d
set COL(16) #b08
set COL(17) #906
############################################








##########################FILE READ######
proc file_read {} {
global infile ACOORD1 BCOORD1 SCALE1
set ACOORD1 0
set BCOORD1 0
set SCALE1 1
set infile [open out_to_tcl r]
while {[gets $infile line] >= 0} {
set type $line
if {$type == 1} {segment_write}
if {$type == 2} {triangle_write}
}
close $infile
}
##########################################






###############2 kinds of writing###############
proc segment_write {} {
global COL infile 
foreach name {s1 p1 p2 s2 q1 q2} {
gets $infile line
set $name $line }
set pp1 [expr 400 + 100*$p1]
set pp2 [expr 400 - 100*$p2]
set qq1 [expr 400 + 100*$q1]
set qq2 [expr 400 - 100*$q2]

.plot create line $pp1 $pp2 $qq1 $qq2 \
-fill $COL($s1)  -tag im -width 1
}


proc triangle_write {} {
global COL infile
foreach name {s1 p1 p2 s2 q1 q2 s3 r1 r2} {
gets $infile line
set $name $line }
set pp1 [expr 400 + 100*$p1]
set pp2 [expr 400 - 100*$p2]
set qq1 [expr 400 + 100*$q1]
set qq2 [expr 400 - 100*$q2]
set rr1 [expr 400 + 100*$r1]
set rr2 [expr 400 - 100*$r2]
.plot create polygon $pp1 $pp2 $qq1 $qq2 $rr1 $rr2 \
-fill $COL($s1)  -tag im
}
##########################################







#####################set up scaling###########################


.plot create oval 400 400 400 400 -fill white -outline white -tag im
.plot addtag im withtag oval
.plot scale oval 0 0 50 50
.plot move oval 400 400


proc location1 {a b} {
global ACOORD1 BCOORD1
set ACOORD1 $a
set BCOORD1 $b
}


proc up_scale {} {
global ACOORD1 BCOORD1 SCALE1 SCALE1
set sc [expr 1/.9]
if {$SCALE1<10000} \
{set SCALE1 [expr $SCALE1*$sc]
.plot scale im $ACOORD1 $BCOORD1 $sc $sc}
}

proc down_scale {} {
global ACOORD1 BCOORD1 SCALE1 SCALE1
set sc [expr .9]
if {$SCALE1>.001} \
{set SCALE1 [expr $SCALE1*$sc]
.plot scale im $ACOORD1 $BCOORD1 $sc $sc}
}
######################################################


file_read 


