#! /usr/local/bin/wish8.3  -f



######################explanation#######################
# The two files Graphics/interface.t and Graphics/interface.c
# are the ways that our tcl file accesses the C code
# from the directory Computations/.  In general, certain
# parameters are defined in the GUI and then written to
# auxilliary files in the directory Graphics/Data.  These
# files are then read by interface.c, and farmed out
# to auxilliary C programs.  The C programs make their
# computations and then pass the data back to the tcl
# programs.  The data is then read by the file
# interface.t.

# Our GUI has 6 options, and each option is controlled by a
# button.  Here are the options:
# 1. Circular Arc tester:  You can define 2 circular arcs
#    and check that our C code correctly computes the
#    number of intersections of the 2 arcs.  

# 2. Tiling in first coordinates.  You can draw pictures
#    of parts of the tiling in the coordinate system Psi,
#    from Ch. 4 in the chapter.   There are 5 "chunking"
#    modes.  This means that you can either plot single
#    tiles, or groups of tiles.  The larger the chunking
#    mode, the more tiles are grouped together.  The final
#    mode lets you plot a large portion of the whole tiling.
#    the coloring system is rather elaborate, so as to
#    be quite flexible.

# 3. Same as 2, except using the coordinate system exp(Psi).

# 4. You can see pictures of the tiling projeced onto the
#    complex line stabilized by the element K, which plays
#    a big role in the paper.  Using this option you can
#    check that our big crude estimate in Ch.10, which
#    reduces everything to a finite computation, is correct.

# 5. Each tetrahedron in our tiling belongs to a subdivision of
#    a piece of the tiling, in the sense of Ch.4.  The
#    subdivision process is defined in Ch. 9.  Each piece
#    has a complex line of symmetry.  This option lets you
#    slice each tetrahedron by the relevant line of symmetry
#    and plot result.  This option generated the pictures
#    from Ch.9.  

# 6. This option lets you specify a pair of tetrahedra, in
#    the list-like manner used by our code.  (The degenerate_list
#    files list things in exactly the same way)
#    NATURE OF THE LIST:  Each pair is
#    specified by a length 3 sequence  n1 (-a+b) n2 
#    Here either a=-b or a=-b-1.  
#    Thus 0=0-0;1=-(-1)+0;2=-(-1)+1;3=-(-2)+1, etc.
#    In Ch. 10 we explained that the basic tetrahedra T1,...,TN
#    are listed out; and every tetrahedron in the complex
#    has the form K^a(T_j).

#    the first tetrahedon in the pair is
#    K^a(TETRA(n1)) and
#    the second tetrahedron in the pair is
#    K^b(TETRA(n2))
#    ONCE THE PAIR IS SELECTED:
#    Once you use the buttons in option 6 to 
#    specify this code, you can apply any of the
#    computational tests to the selected pair:
#    projection test, edge smash test, face smash test.
#    Or you can let the computer do the test which
#    verifies that the pair intersect as claimed in
#    the paper.  Either way, the computer does the
#    requested test and then reports back the result.
#    The computer also plots the relevant picture
#    of the graphs associated to the pair, as explained
#    in Ch. 10 of the paper.
#################################################################





############BOARD SETUP##########################
frame .f1
pack .f1
frame .f2
pack .f2
canvas .plot0 -width 600 -height 600  -bg black
canvas .control0 -width 300 -height 150 -bg orange
canvas .control00 -width 300 -height 450 -bg black
pack .control0 .control00 -in .f2
pack .f2 .plot0 -in .f1 -side right
##################################################




###############INITIALIZE C CODE##################
source Graphics/interface.t
catch {exec gcc Graphics/interface.c -lm}
catch {exec mv a.out Graphics/interface.o}
##################################################





#########buttons###################################
#option 1
.control0 create rectangle 5 5 20 20 -fill blue -tag arc
.control0 create text 30 13 -text "intersection tests" \
-fill black -anchor w
.control0 bind arc <Any-Button> {do_arc}

#option 2
.control0 create rectangle 5 25 20 40 -fill blue -tag tile1
.control0 create text 30 33 -text "tiling in 1st coord" \
-fill black -anchor w
.control0 bind tile1 <Any-Button> {do_tile 1}

#option 3
.control0 create rectangle 5 45 20 60 -fill blue -tag tile2
.control0 create text 30 53 -text "tiling in 2nd coord" \
-fill black -anchor w
.control0 bind tile2 <Any-Button> {do_tile 2}

#option 4
.control0 create rectangle 5 65 20 80 -fill blue -tag tile3
.control0 create text 30 73 -text "complex in K-coords" \
-fill black -anchor w
.control0 bind tile3 <Any-Button> {do_tile 3}

#option 5
.control0 create rectangle 5 85 20 100 -fill blue -tag tile4
.control0 create text 30 93 -text "slices of pieces" \
-fill black -anchor w
.control0 bind tile4 <Any-Button> {do_tile 4}

#option 6
.control0 create rectangle 5 105 20 120 -fill blue -tag pair1
.control0 create text 30 113 -text "pairs of tetrahedra" \
-fill black -anchor w
.control0 bind pair1 <Any-Button> {do_pair 1}

foreach name {tile1 tile2 tile3 tile4 pair1 arc} {
.control0 addtag button withtag $name }
############################################################


#this routine basically resets the whole program when
#a new option is chosen.

proc complete_destroy {} {
catch {destroy .control00}
catch {destroy .control1}
catch {destroy .control2}
catch {destroy .plot0}
catch {destroy .plot1}
catch {destroy .plot2} }

# the option buttons are bound to these routines.
# To figure out what the routines do, you need to
# to go into the source code.  For instance, the
# file arc.t contains the code for our arc tester
# of option 1.

proc do_arc {} {
complete_destroy
.control0 itemconfigure button -fill blue
.control0 itemconfigure arc -fill yellow
source Graphics/arc.t
arc_setup }


proc do_tile {x} {
global RENDER
complete_destroy
.control0 itemconfigure button -fill blue
.control0 itemconfigure tile$x -fill yellow
source Graphics/tile.t
set RENDER $x
tile_setup }

proc do_pair {x} {
complete_destroy
.control0 itemconfigure button -fill blue
.control0 itemconfigure pair$x -fill yellow
source Graphics/pair${x}.t
}
