
########################################################
#                      Dented Tori
#               By Richard Evan Schwartz
#                University of Maryland
#                 res@math.umd.edu
#                      Sept, 1997
#                 Copyright R.E.S. 1997
#
##########################################################
#This program illustrates my recent proof of the
#Goldman-Parker conjecture on complex hyperbolic ideal
#triangle groups.   To get a fuller explanation,
#install and run the program, as directed below.
############################################################


##############################################
###################TUTORIAL###########
##############################################


############################################
#################CONTROL BUTTON###############
############################################
proc text_box {x1 y1 x2 y2 col1 col2 name text} {
global FONT2
set opt "null"
.hopf create rectangle ${x1}c ${y1}c ${x2}c ${y2}c \
-fill $col2 -tag Z${name}D$opt
.hopf create text [expr 0.5*$x1+0.5*$x2]c [expr 0.5*$y1 + 0.5*$y2]c \
-font $FONT2 \
-fill white -text $text -tag Z${name}D$opt
.hopf create rectangle ${x1}c ${y1}c ${x2}c ${y2}c \
-fill $col1 -tag X${name}D$opt
.hopf create text [expr 0.5*$x1+0.5*$x2]c [expr 0.5*$y1 + 0.5*$y2]c \
-font $FONT2 \
-fill black -text $text -tag Y${name}D$opt
.hopf addtag Y${name}D$opt withtag X${name}D$opt
.hopf addtag Y${name}D$opt withtag Z${name}D$opt
.hopf addtag text withtag Z${name}D$opt
.hopf addtag text withtag X${name}D$opt
.hopf addtag A$col1  withtag Y${name}D$opt
.hopf addtag B$col2  withtag Y${name}D$opt
.hopf addtag text withtag Y${name}D$opt
.hopf bind Y${name}D$opt <Any-Enter> {text_enter}
.hopf bind Y${name}D$opt <Any-Leave> {text_leave}
.hopf bind Y${name}D$opt <Any-Button> {text_push}
}

proc text_enter {} {
set x [.hopf gettags current]
set name [lindex $x [expr [lsearch $x Y*]]]
set name [string trim $name X]
set name [string trim $name Y]
set col  [lindex $x [expr [lsearch $x B*]]]
set col [string trim $col B]
.hopf itemconfigure X$name -fill $col
}
proc text_leave {} {
set x [.hopf gettags current]
set name [lindex $x [expr [lsearch $x Y*]]]
set name [string trim $name X]
set name [string trim $name Y]
set col  [lindex $x [expr [lsearch $x A*]]]
set col [string trim $col A]
.hopf itemconfigure X$name -fill $col
}
proc text_push {} {
set x [.hopf gettags current]
set name [lindex $x [expr [lsearch $x Y*]]]
set name [string trim $name X]
set name [string trim $name Y]
set name1 [string range $name 0 [expr [string first D $name] -1]]
set name2 [string range $name [expr [string first D $name] +1] \
                              [expr [string length $name] -1]]
$name1 
}


proc font_change {} {
global FONT FONT1 FONT2 FONT3
if {$FONT == $FONT1} {set Z $FONT2}
if {$FONT == $FONT2} {set Z $FONT3}
if {$FONT == $FONT3} {set Z $FONT1}
set FONT $Z
text1 
}
######

proc text_clear {} {
.torus delete xtra
.elev delete  control
}

proc text_clear2 {} {
.hopf delete text
.plan delete pix
.torus delete pix
}

proc back_text {} {
set nav [.hopf gettags text1]
set len [llength $nav]
set temp [lindex $nav [expr $len -2]] 
for {set i 0} {$i<$len} {incr i} {
.hopf dtag [lindex $nav $i] }
.hopf create rectangle 0c 0c 0c 0c -fill black -tag text1
for {set i 1} {$i<[expr $len -1]} {incr i} {
.hopf addtag [lindex $nav $i] withtag text1}
$temp
}




###############################
##########INTRODUCTION###########
###############################

proc text1 {} {
global FONT FONT4 FONT0 
text_clear2
.hopf create text 5c 1.5c -tag text  -fill cyan -anchor n \
-font $FONT0 \
-text "Dented Tori"

.hopf create text 5c 3.0c -tag text -fill cyan -anchor n \
-font $FONT4 \
-text "An interactive demo for the proof of"

.hopf create text 5c 3.6c -tag text -fill cyan -anchor n \
-font $FONT4 \
-text "the Goldman-Parker conjecture"

.hopf create text 5c 6c -tag text  -fill magenta -anchor n \
-font $FONT4 \
-text "Richard Evan Schwartz"          

.hopf create text 5c 7c -tag text  -fill magenta -anchor n \
-font $FONT4 \
-text "University of Maryland"

.hopf create text 8.7c 9.5c -tag text  -fill red  \
-font $FONT \
-text "font:"

text_box .2 9.2 1.2 9.7 green blue start_text "start"
text_box 1.5 9.2 2.7 9.7 yellow blue version_text "version"
text_box 3.0 9.2 4.2 9.7 yellow blue thanks_text "thanks"
text_box 4.5 9.2 6.2 9.7 yellow blue ref_text "references"
text_box 6.5 9.2 7.5 9.7 yellow blue bug_text "bugs"
text_box 9.3 9.2 9.8 9.7 red blue font_change ""
.hopf create rectangle 0c 0c 0c 0c -fill black -tag text1
}


proc version_text {} {
global FONT 
text_clear2
.hopf addtag version_text withtag text1 
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "This version of the program was completed
Oct. 15, 1997."  
text_box .2 9.2 1.2 9.7 red blue back_text "back"
}


proc thanks_text {} {
global FONT 
text_clear2
.hopf addtag thanks_text withtag text1 
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "This project is supported by an Alfred P. Sloan
Research Fellowship.   

I worked out some of the mathematics for this
project at the University of Chicago, in 1997."
text_box .2 9.2 1.2 9.7 red blue back_text "back"
}

proc ref_text {} {
global FONT 
text_clear2
.hopf addtag ref_text withtag text1 
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "REFERENCES

1. The Goldman-Parker paper was published in 
J. reine agnew math., 1992, #425 

2. For a succinct introduction to complex
hyperbolic geometry, see D.B.A. Epstein's
article, `Complex Hyperbolic Geometry',
in  the L.M.S. Lecture Note series, #111.

3. For a comprehensive introduction to complex
hyperbolic geometry, see W. Goldman's
book `Complex Hyperbolic Geometry'.
(The book is available from the author.)"

text_box .2 9.2 1.2 9.7 red blue back_text "back"
}



proc dict_text {} {
global FONT 
text_clear2
.hopf addtag dict_text withtag text1 
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "DICTIONARY"

text_box .5 1.5 3.0 2.0 yellow blue triangle_text "Triangle Groups"
text_box .5 2.2 1.8 2.7 yellow blue group_text "PU(2,1)"
text_box .5 2.9 2.6 3.4 yellow blue L_text "Lorenz Form"
text_box .5 3.6 3.3 4.1 yellow blue angle_text "angular invariant"
text_box .5 4.3 1.7 4.8 yellow blue chain_text "chains"
text_box .5 5.0 2.0 5.5 yellow blue Rcircle_text "R-circles"
text_box .5 5.7 2.5 6.2 yellow blue cone_text "Hybrid Cone"
text_box .5 6.4 2.5 6.9 yellow blue compress_text "compression"
text_box 8.2 1.5 9.5 2.0 yellow blue discrete_text "discrete"
text_box 8.2 2.2 9.5 2.7 yellow blue faithful_text "faithful"
text_box 8.4 2.9 9.5 3.4 yellow blue hopf_text "HYP"
text_box 8.4 3.6 9.5 4.1 yellow blue plan_text "PLAN"
text_box 8.4 4.3 9.5 4.8 yellow blue elev_text "ELEV"
text_box 7.4 5.0 9.5 5.5 yellow blue dent_text "Dented Torus"
text_box 7.3 5.7 9.5 6.2 yellow blue cliff_text "Clifford Torus"
text_box 8.0 9.2 9.6 9.7 green blue notation_text "notation"
text_box .2 9.2 1.2 9.7 red blue back_text "back"
}

proc helper {x1 y1 x2 y2 s} {
global FONT
set xm [expr .5*($x1+$x2)]
set ym [expr .5*($y1+$y2)]
.torus create polygon ${x1}c ${y1}c \
                      ${x1}c ${y2}c \
                      [expr 2*${xm}]c ${ym}c \
-fill #0c0 -tag help
.torus create text [expr .05+${x1}]c ${ym}c -fill black \
-font $FONT -text $s -tag help -anchor w
.torus addtag pix withtag help
.torus bind help <Double-Button-2> {
.torus delete help}
.torus bind help <Button-1> {
.torus itemconfigure current -fill red}
.torus bind help <Button-3> {
.torus itemconfigure current -fill #0c0}


}



proc start_text {} {
global FONT
.hopf addtag start_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "Welcome to Dented Tori.  This program explains 
my proof of the Goldman-Parker conjecture, which
gives the exact discreteness criterion for complex
hyperbolic ideal triangle groups.

This is the tutorial mode.  By reading the text and
playing with the control panel, you can learn about
the conjecture and about this program.

The best path for you to take through this tutorial
depends on your prior knowledge.  Each window of
text contains links to other windows which explain
the meaning of terms which might be new.

The bottom two windows illustrate the function of
the control panel.  When you push a button on the
control panel an explanation appears beside it." 


.plan create rectangle 2c 2c 8c 8c -fill black -outline white -tag pix
.plan create line 2c 5c 8c 5c -fill white -tag pix
.plan create line 5c 2c 5c 8c -fill white -tag pix

.plan create text 5c 1c -text "Tutorial Layout" \
-font $FONT -tag pix -fill white
.plan create text 3.5c 3.5c -text "Text" \
-font $FONT -tag pix -fill white
.plan create text 3.5c 6.5c -text "Control Panel" \
-font $FONT -tag pix -fill white
.plan create text 6.5c 3.5c -text "Diagrams" \
-font $FONT -tag pix -fill white
.plan create text 6.5c 6.5c -text "C.Panel Text" \
-font $FONT -tag pix -fill white

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 3.9 9.7 yellow blue triangle_text "triangle groups"
text_box 4.2 9.2 6.2 9.7 yellow blue conjecture_text "conjecture"
text_box 6.5 9.2 7.7 9.7 yellow blue proof_text "proof"
text_box 8.0 9.2 9.6 9.7 yellow blue notation_text "notation"
text_box .2 8.5 2.2 9.0 yellow blue mode_text "how to play!"
text_box 7.9 8.5 9.6 9.0 yellow blue dict_text "dictionary"
}


proc mode_text {} {
global FONT
.hopf addtag mode_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "HOW TO PLAY

To play with the program, the first thing you
do is press on the ``play'' button on the control
panel.  (Read on before doing this.)

By pressing the `'pix'' button
below, and reading the instructions,
you can practice making pictures.

As already mentioned above, you can learn
how to make pictures, in a less direct way,
by clicking various buttons on the control
panel to see what they do."

helper 7 2.4 2 3.4  "play"

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.4 9.2 2.4 9.7 yellow blue basic_text "pix"
}


proc basic_text {} {
global FONT
.hopf addtag basic_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "MAKING PICTURES

The sequence of button presses below
will plot a single piece of the dented torus,
in the PLAN coordinate system.  To see more
features, press ``fancy plot''.
In either case, you can try it out by switching
into the play mode.  The green arrows point
to the buttons you should push. 

To help you mark your place in the sequence,
you can change the colors of the arrows by
by clicking left/right on them.
You can delete all the arrows by double-clicking
the middle button on them.

When you are done playing, you can return
to the tutorial by pushing the tutorial
button on the control panel."


helper  3.3 .36  1 1.3  "1st"
helper  6 .1 3.2   .9  "2nd &4th"
helper  2.6 5.6 5.1 7.2 "3rd: click left (repeat)"

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 3.4 9.2 5.3 9.7 yellow blue dent_text "dented torus"
text_box 1.5 9.2 3.1 9.7 yellow blue fancy_text "fancy plot"
text_box 5.6 9.2 6.6 9.7 yellow blue plan_text "PLAN"
text_box 6.9 9.2 9.7 9.7 yellow blue backg_text "background colors"
}

proc backg_text {} {
global FONT
.hopf addtag backg_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "BACKGROUND COLORS

You can change the window background colors,
in the play mode, as follows:

First select a color on the color strip,
then click on the middle button on the
relevant part of window.   Go into play
mode to try this out."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
}

proc fancy_text {} {
global FONT
.hopf addtag fancy_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "FANCY PLOT 

This sequence lets you plot the same pieces, first
using the identity element, then using the element
120, in ELEV.  After making the two plots, you get
to scale the pictures, and change the colors of
what has been plotted." 

helper  5 .33  .5 1.33  "1"
helper  2.7 2.1 2 3.3 "3&5 left"
helper  3.9 8  .5 9  "4"
helper  7 8 2.2  9  "2&7&13"
helper  6.1 .8 .42  1.6  "8"
helper  6.6 .7 .55  1.6  "10"
helper  7.3 .8 .42  1.6  "9"
helper  .3 3.1 5 4.4 "11 middle (8 times)"
helper  1.8 1.1  .8 2.1  "12"
helper  7.3 6.7 .9  7.4  "6"
helper  4.8 4.5 11 6.5 "14: Click lt-lt-rt-rt on the pix"
helper  3.6 .33  .8 1.33  "15"
helper  8.32 8.73 .8  9.33  "16"
helper  1 4.5 3 6 "17: rt-lt-rt-lt"

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.6 9.7 yellow blue elev_text "ELEV"
}

proc notation_text {} {
global FONT
.hopf addtag notation_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "NOTATION 

-- A<B stands for `A is a proper subset of B'
-- A||B stands for `A intersect B' 
-- A&B stands for `A union B' 
-- AxB stands for the product of A and B.
-- R^n stands for real n-space.
-- C^n stands for complex n-space.
-- Z stands for the integers.
-- S^3 stands for the unit sphere in C^2.
-- CP^2 stands for the complex projective plane.
-- |z| stands for the absolute value of z.
-- arg z stands for the argument of z.
"
text_box .2 9.2 1.2 9.7 red blue back_text "back"

}


proc triangle_text {} {
global FONT
.hopf addtag triangle_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "TRIANGLE GROUPS 

A complex hyperbolic ideal triangle group is a
subgroup of PU(2,1) generated by three complex
reflections, such that the composition of any
two of the generators is parabolic.

Every such group is conjugate to one which is
constructed as follows:  Let X be the Clifford
torus |z|=|w|=sqrt(1/2), which is a submanifold
of S^3.  Let ARG(z,w)=(arg z,arg w).  ARG(X) is
the square torus shown at rignt.

Choose horizontal, vertical, diagonal curves,
h,v,d, on the square torus, with the symmetry
shown.  There are chains, H,V,D, all in X, such
that ARG(H,V,D)=(h,v,d).  The complex reflections
determined by H,V,D generate a triangle group."


text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.8 9.7 yellow blue group_text "PU(2,1)"
text_box 3.1 9.2 5.2 9.7 yellow blue cliff_text "Clifford torus"
text_box 5.5 9.2 6.7 9.7 yellow blue chain_text "chains"
text_box 7.0 9.2 8.0 9.7 yellow blue tri2_text "more"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
triangle_pix
}



proc Rcircle_text {} {
global FONT
text_clear2
.hopf addtag Rcircle_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "R-CIRCLES

An R-circle is any image, under PU(2,1) of
the real circle,  S^1=R^2||S^3.  

For example, the curve {z=Conjugate(w)} is an
R-circle contained on the clifford torus.
ARG maps this R-circle to the main diagonal
of slope -1.

There is a 1-parameter family of R-circles through
every pair of distinct points in S^3.  R-circles
and chains are two distinguished PU(2,1)-invariant
families of curves in S^3."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.8 9.7 yellow blue group_text "PU(2,1)"
text_box 3.1 9.2 5.2 9.7 yellow blue cliff_text "Clifford torus"
text_box 5.5 9.2 6.7 9.7 yellow blue chain_text "chains"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}


proc cliff_text {} {
global FONT
text_clear2
.hopf addtag cliff_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "CLIFFORD TORUS

The Clifford Torus is the submanifold of S^3,
X={|z|=|w|=sqrt(1/2)}.  The map 
ARG(z,w)=(arg z,arg w) maps X onto the
square torus (R/2 Pi Z)x(R/2 Pi Z).

X has four interesting foliations.  The inverse images,
under ARG, of 

1. the horizontal lines
2. the vertical lines
3. the lines of slope 1
4. the lines of slope -1

give foliations of X by chains, chains, chains, 
and R-circles."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.7 9.7 yellow blue chain_text "chains"
text_box 3.0 9.2 4.7 9.7 yellow blue Rcircle_text "R-circles"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"

.plan create rectangle 1c 1c 9c 9c \
 -fill black -outline white -tag pix
.plan create line 4c 1c 6c 1c -width .1c -fill red -arrow last -tag pix
.plan create line 4c 9c 6c 9c -width .1c -fill red -arrow last -tag pix
.plan create line 1c 4c 1c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 9c 4c 9c 6c -width .1c -fill green -arrow last -tag pix
for {set i 1} {$i<10} {incr i} {
.plan create line ${i}c 1c ${i}c 9c -fill cyan -tag pix
.plan create line 1c ${i}c 9c ${i}c -fill cyan -tag pix
.plan create line 1c ${i}c ${i}c 1c -fill cyan -tag pix
.plan create line ${i}c 9c 9c ${i}c -fill cyan -tag pix
.plan create line ${i}c 1c 9c [expr 10-$i]c \
-fill yellow -tag pix -width .05
.plan create line 1c ${i}c [expr 10-$i]c 9c \
-fill yellow -tag pix -width .05}

}


proc tri2_text {} {
global FONT
.hopf addtag tri2_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "TRIANGLE GROUPS, CONTINUED 

The point H||D is the fixed point of the
composition of the reflection determined
by H and D.  Similarly for H||V and V||D.
ARG maps the 3 points H||D, H||V, V||D to the
3 magenta points h||d, h||v, h||d.  

The angular invariant of the the triple  
(H||D, H||V, V||D) is a conjugacy invariant
of the group, and varies with the size of
the triangle in ARG(X) bounded by h,v,d. 
This number is called the angular invariant
of the triangle group.

The Goldman-Parker Conjecture gives the exact
criterion for when the triangle group is
discrete, based on its angular invariant."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 4.1 9.7 yellow blue angle_text "angular invariant"
text_box 4.4 9.2 5.4 9.7 yellow blue tri3_text "more"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
triangle_pix
}

proc tri3_text {} {
global FONT  PARAMETER
.hopf addtag tri3_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "TRIANGLE GROUPS, CONTINUED 

Let Th, Tv, Td be the complex reflections determined
by  H,V,D.   In this program, we use the generators:

0=Td         1=Th           2=Td Tv Td

By pressing buttons 0, 1, 2 on the keyboard, you
can see formulas for these elements, as a function
of t, the angular invariant of the group.  We
call this choice of generators the Zig-Zag
representation.

The figure at right shows the location,
on ARG(X), of the images of the chains fixed
by elements 0, 1, 2.   Of course, the exact
positions depend on the angular invariant of the
group."


.plan create rectangle 1c 1c 9c 9c \
 -fill black -outline white -tag pix
.plan create line 4c 1c 6c 1c -width .1c -fill red -arrow last -tag pix
.plan create line 4c 9c 6c 9c -width .1c -fill red -arrow last -tag pix
.plan create line 1c 4c 1c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 9c 4c 9c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 1c 1.5c 9c 1.5c -fill cyan -tag pix
.plan create line 1c 8.5c 9c 8.5c -fill cyan -tag pix
.plan create line 1c 9c 9c 1c -fill cyan -tag pix
.plan create text 5c 1.8c  -fill cyan -text "1" -tag pix
.plan create text 5c 8.2c  -fill cyan -text "2" -tag pix
.plan create text 4.8c 4.8c  -fill cyan -text "d" -tag pix

text_box 0.2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 5.0 9.7 yellow blue triangle_text "restart triangle groups"
text_box 5.3 9.2 6.8 9.7 yellow blue conjecture_text "conjecture"
}



proc triangle_pix {} {
.plan create rectangle 1c 1c 9c 9c \
 -fill black -outline white -tag pix
.plan create line 4c 1c 6c 1c -width .1c -fill red -arrow last -tag pix
.plan create line 4c 9c 6c 9c -width .1c -fill red -arrow last -tag pix
.plan create line 1c 4c 1c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 9c 4c 9c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 1c 1.5c 9c 1.5c -fill cyan -tag pix
.plan create line 1.5c 1c 1.5c 9c -fill cyan -tag pix
.plan create line 1c 9c 9c 1c -fill cyan -tag pix
.plan create text 5c 1.8c  -fill cyan -text "h" -tag pix
.plan create text 1.8c 5c  -fill cyan -text "v" -tag pix
.plan create text 4.8c 4.8c  -fill cyan -text "d" -tag pix
.plan create oval 1.3c 1.3c 1.7c 1.7c  -fill magenta -tag pix
.plan create oval 1.3c 8.3c 1.7c 8.7c  -fill magenta -tag pix
.plan create oval 8.3c 1.3c 8.7c 1.7c  -fill magenta -tag pix
}



proc group_text {} {
global FONT
.hopf addtag group_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "PROJECTIVE (2,1)-UNITARY GROUP

PU(2,1) is the group of biholomorphic automorphisms 
of the unit ball in C^2.  Concretely, let L be the
standard type (2,1) hermitian form on C^3.  The
elements of PU(2,1) are exactly projectivizations of 
L-preserving complex linear maps of C^3.

A complex reflection is any element in PU(2,1), 
conjugate to the element 0(z,w)=(z,w).  Such
an element fixes a chain in S^3, and is determined
completely by this fixed chain.  For example, 0
fixes the chain D, described in the initial
section on triangle groups.  By definition,
complex reflections have order 2.

An element of PU(2,1) is called parabolic, 
loxodromic, or elliptic, depending on whether
is has 1, 2, or more fixed points in S^3."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.7 9.7 yellow blue chain_text "chains"
text_box 3.0 9.2 3.4 9.7 yellow blue L_text "L"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}



proc L_text {} {
global FONT
.hopf addtag L_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "LORENZ UNITARY FORM

If Z=(z1,z2,z2) and W=(w1,w2,w2), then  

L(Z,W)= z1 C(w1) + z2 C(w2) - z3 C(w3)

Here C() stands for conjugation.  The minus sign
in the formula for L is deliberate.

An L-preserving linear map automatically preserves
the null cone N={|z3|^2=|z1|^2+|z2|^2}.  If we define
PROJ(z1,z2,z3)=(z1/z3,z2/z3),  then PROJ(N)=S^3.
This is why L-preserving linear maps projectivize
to give S^3 preserving complex projective maps."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}


proc angle_text {} {
global FONT
.hopf addtag angle_text withtag text1
text_clear2
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "ANGULAR INVARIANT 

Given three distinct points (p1,p2,p3) in S^3,
choose three L-null vectors P1,P2,P3, such
that PROJ(Pj)=pj.  The angular invariant 
A(p1,p2,p3)= arg(L(P1,P2) L(P2,P3) L(P3,P1))
is independent of the choices of Pj, and
by construction is PU(2,1)-invariant.

|A| is a complete PU(2,1) invariant of
unordered triples, and we call it the
absolute angular invariant.

|A|(p1,p2,p3)=0 (resp Pi/2) if and only if
p1,p2,p3 lie in a chain (resp. R-circle.)"

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
text_box 1.5 9.2 2.8 9.7 yellow blue group_text "PU(2,1)"
text_box 3.0 9.2 3.4 9.7 yellow blue L_text "L"
text_box 3.7 9.2 5.3 9.7 yellow blue Rcircle_text "R-circles"
text_box 5.6 9.2 6.7 9.7 yellow blue chain_text "chains"

}




proc chain_text {} {
global FONT
text_clear2
.hopf addtag chain_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "CHAINS
 
A complex line is any solution to the equation
az+bw=c, in C^2.  A chain is the intersection
of a complex line with S^3.   

For example, the chain D, described in the page
above, is the intersection of the complex
line {z=w} with S^3.   The chains V and H
are intersections of S^3 with chains of the
form {z=constant} and {w=constant}.

Every two distinct points in S^3 determined a
unique chain.  Chains and R-circles form two
PU(2,1) invariant families of curves in S^3."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 3.0 9.2 4.7 9.7 yellow blue Rcircle_text "R-circles"
text_box 1.5 9.2 2.8 9.7 yellow blue group_text "PU(2,1)"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}



proc conjecture_text {} {
global FONT
text_clear2
.hopf addtag conjecture_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "GOLDMAN PARKER CONJECTURE
 
Around 1991, Goldman and Parker proved

1. A complex hyperbolic ideal triangle group
is discrete and faithful if its absolute angular  
invariant is at most M=arctan(sqrt(35)).

2. The absolute angular invariant of a discrete 
faithful complex hyperbolic ideal triangle group does
not exceed N=arctan(sqrt(125/3)) in absolute value.

The G-P conjecture is that a complex hyperbolic ideal
triangle group is discrete and faithful if and only
if its absolute angular invariant is at most N.

This program demonstrates the proof that groups
with absolute angular invariant in the ``gap''
(M,N] are discrete and faithful."

conjecture_pix
text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 3.9 9.7 yellow blue triangle_text "triangle groups"
text_box 4.2 9.2 5.6 9.7 yellow blue discrete_text "discrete"
text_box 5.9 9.2 7.1 9.7 yellow blue faithful_text "faithful"
text_box 7.4 9.2 8.4 9.7 yellow blue value_text "M&N"
text_box 8.7 9.2 9.7 9.7 yellow blue proof_text "proof"
text_box 8.0 8.5 9.7 9.0 yellow blue ref_text "References"
}

proc conjecture_pix {} {
.plan create arc -10c 20c 10c 0c  -start 0 -extent 90 \
-fill blue  -outline white -tag pix
.plan create arc -10c 20c 10c 0c  -start 0 -extent 80.406 \
-fill yellow  -outline white -tag pix
.plan create arc -10c 20c 10c 0c  -start 81.194 -extent 8.806 \
-fill red  -outline white -tag pix

.plan create rectangle  1.8c 3.8c 7.2c 9.2c \
-fill black  -tag pix 

.plan create arc 2c 4c 7c 9c  -start 0 -extent 359.99 \
-fill black -outline white -tag pix
.plan create arc 2c 4c 7c 9c  -start 0 -extent 90 \
-fill black  -outline white -tag pix
.plan create arc 2c 4c 7c 9c  -start 0 -extent 80.406 \
-fill yellow  -outline white -tag pix
.plan create arc 2c 4c 7c 9c  -start 81.194 -extent 8.806 \
-fill red  -outline white -tag pix
}




proc discrete_text {} {
global FONT
text_clear2
.hopf addtag discrete_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "DISCRETENESS
 
A subgroup G of a Lie group is discrete if every
nontrivial element of G is isolated from the
identity element.  By this, we mean that there
is an open subset about the identity which
does not intersect any other element of the G.

In the situation at hand, the Lie group is PU(2,1)."

text_box 1.5 9.2 2.8 9.7 yellow blue group_text "PU(2,1)"
text_box .2 9.2 1.2 9.7 red blue back_text "back"
}


proc faithful_text {} {
global FONT
text_clear2
.hopf addtag faithful_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "FAITHFULNESS 

A triangle group is faithful if any nontrivial
word in the generators of the group is a nontrivial
element of PU(2,1)."

text_box 1.5 9.2 2.8 9.7 yellow blue group_text "PU(2,1)"
text_box .2 9.2 1.2 9.7 red blue back_text "back"
}


proc value_text {} {
global FONT
text_clear2
.hopf addtag value_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "KEY VALUES

M is the value at which the Dirichlet domain for the
triangle group becomes  incomprehensible.  (See the
G.P. paper for details.)  From our point of view, 
M is the largest value for which the triangle group
is compressing with respect to the pair of
components of the complement of the Clifford torus

Let g be the product of the 3 generators of the
triangle group.  N is the value at which g is
parabolic.  For absolute angular invariant smaller
(resp. larger) than N, this product is loxodromic
(resp. elliptic)  For rather trivial reasons,
the presence of the elliptic precludes simultaneous
discreteness and faithfulness.

Note that the gap between M and N, shown as the
blue region in the figure to the right, is quite 
small." 

conjecture_pix
text_box 1.5 9.2 2.8 9.7 yellow blue group_text "PU(2,1)"
text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 3.1 9.2 4.9 9.7 yellow blue comptess_text "compressing"
text_box 5.2 9.2 7.4 9.7 yellow blue triangle_text "triangle groups"
text_box 7.7 9.2 9.8 9.7 yellow blue cliff_text "Clifford torus"
}


proc proof_text {} {
global FONT
text_clear2
.hopf addtag proof_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "PROOF OF G.P. CONJECTURE

Let G(t) be the triangle group having absolute
angular invariant t, assumed to lie in (M,N].
We will construct a surface, S(t), which we call
a dented torus, having the property that G(t)
G(t) is compressing with respect to the pair
of components of S^3-S(t).   This suffices to
prove that G(t) is discrete faithful.

S(t) is obtained by replacing parts of the 
Clifford torus, using a process we call the
Hybrid cone.   This program lets you visualize
the action of G(t) on S(t), and shows that
that the compression property holds."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 4.7 9.2 6.0 9.7 yellow blue triangle_text "tri gps"
text_box 2.9 9.2 4.4 9.7 yellow blue conjecture_text "GP Conj" 
text_box 6.3 9.2 7.8 9.7 yellow blue compress_text "compress"
text_box 8.1 9.2 9.8 9.7 yellow blue cliff_text "Cliff torus"
text_box 2.9 8.5 6.0 9.0 yellow blue \
prog_text "Visual Verification"
text_box 6.3 8.5 7.4 9.0 yellow blue cone_text "h cone"
text_box 7.7 8.5 9.8 9.0 yellow blue dent_text "Dented torus"
}



proc dent_text {} {
global FONT
text_clear2
.hopf addtag dent_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "DENTED TORUS 

Let t be in the interval (M,N].  In what follows,
we will suppress the subscript t, on which everything
depends.

0. Let X be the Clifford torus.
1. Let C be the chain preserved by 120 and let p be
the important intersection point of X||C. 
2. Let V be the vertical chain {z=exp(Pi i/12)/sqrt(2)}
3. Let A be the solid triangle bounded by edges
which are contained in the chains V, r(V), d. 
Here r(z,w)=(conjugtate w,conjugate z).
4. Let dA be the boundary of A (shown in red)
5. Let B=0(A) and dB=0(dB) (shown in blue)  
6. Let CA=CONE(C,p;dA).
7. Let CB=0(CA)
8. Let S=(X-A-B)&CA&CB

The final object, S, is the dented torus."
dent_pix

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.2 9.7 yellow blue element_text "120"
text_box 2.5 9.2 3.4 9.7 yellow blue cone_text "cone"
text_box 3.7 9.2 4.8 9.7 yellow blue value_text "M&N"
text_box 5.1 9.2 6.6 9.7 yellow blue cliff_text "cliff torus"
text_box 6.9 9.2 8.7 9.7 yellow blue sub_text "subdivision"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}

proc sub_text {} {
global FONT
text_clear2
.hopf addtag sub_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "CANONICAL SUBDIVISION

The piece CA has the following subdivision

1. CA=CONE(C,p;V)||CA &          (write as CAv)
         CONE(C,p;120(V))||CA &     (write as CAh)
         CONE(C,p;d)||CA            (write as CAd)
2. CAd further splits as CAdh and CAdv
3. CAv||CAh and CAdv||CAdh both lie in the
      R-circle Y.
 
As usual, the picture at right shows the image
of the Clifford torus under the map ARG.
All lines but the magenta ones lie on the
Clifford torus."

dent_pix
.plan create polygon 1.8c 1.8c 1.8c 8.2c 8.2c 1.8c -fill #500 -tag pix
.plan create line 1.8c 8.1c 8.1c 1.8c -width .14c -fill red -tag pix
.plan create text 3.3c 2.9c -fill white -tag pix -text "p"
.plan create line 1.8c 1.8c 8.2c 8.2c -tag pix -fill yellow
.plan create text 6.5c 6.8c -text "Y" -tag pix -fill white
.plan create line 2.8c 2.8c 1.8c 8.2c -fill magenta -tag pix
.plan create line 2.8c 2.8c 8.2c 1.8c -fill magenta -tag pix

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.2 9.7 yellow blue element_text "120"
text_box 2.5 9.2 3.4 9.7 yellow blue cone_text "cone"
text_box 3.7 9.2 5.7 9.7 yellow blue dent_text "Dented Torus"
text_box 6.0 9.2 7.5 9.7 yellow blue cliff_text "cliff torus"
text_box 7.8 9.2 8.7 9.7 yellow blue sub2_text "more"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}


proc sub2_text {} {
global FONT
text_clear2
.hopf addtag sub2_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "CANONICAL SUBDIVISION, CONT.

The piece CB has the following subdivision:

CB= 0(CAh) & 0(CAv) & 0(CAdh) & 0(CAdv)."

dent_pix
.plan create polygon 8.2c 8.2c 1.8c 8.2c 8.2c 1.8c -fill #006 -tag pix
.plan create line 1.8c 8.3c 8.3c 1.8c -width .14c -fill #07f -tag pix
.plan create oval 7.3c 7.3c 7.1c 7.1c -fill green -tag pix
.plan create text 6.8c 7.6c -fill white -tag pix -text "0(p)"
.plan create line 1.8c 1.8c 8.2c 8.2c -tag pix -fill yellow
.plan create text 6.5c 6.8c -text "Y" -tag pix -fill white
.plan create line 2.8c 2.8c 1.8c 8.2c -fill magenta -tag pix
.plan create line 2.8c 2.8c 8.2c 1.8c -fill magenta -tag pix
.plan create line 7.2c 7.2c 8.2c 1.8c -fill magenta -tag pix
.plan create line 7.2c 7.2c 1.8c 8.2c -fill magenta -tag pix


text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.2 9.7 yellow blue element_text "120"
text_box 2.5 9.2 3.4 9.7 yellow blue cone_text "cone"
text_box 3.7 9.2 5.7 9.7 yellow blue dent_text "Dented Torus"
text_box 6.0 9.2 7.5 9.7 yellow blue cliff_text "cliff torus"
text_box 7.8 9.2 8.7 9.7 yellow blue sub3_text "more"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}



proc sub3_text {} {
global FONT
text_clear2
.hopf addtag sub3_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "CANONICAL SUBDIVISION, CONT.

The piece X-A-B has the following subdivision:

1. There are 3 chains on the Clifford torus X
   which contain the point p.  
2. There are 3 chains on the Clifford torus X
   which contain the point 0(p).     
3. There are the 4 chains V, 0(V), 120(V), 0120(V).
4. These 10 chains cut X-A-B into 24 pieces."

.plan create rectangle 1c 1c 9c 9c \
 -fill black -outline white -tag pix
.plan create line 4c 1c 6c 1c -width .1c -fill red -arrow last -tag pix
.plan create line 4c 9c 6c 9c -width .1c -fill red -arrow last -tag pix
.plan create line 1c 4c 1c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 9c 4c 9c 6c -width .1c -fill green -arrow last -tag pix
.plan create text 6.8c 3.5c -fill white -tag pix  -text "d"
.plan create text 3.2c 2.93c -fill white -tag pix -text "p"
.plan create text 1.5c 5c -tag pix -text "V" -fill white
.plan create text 5c 1.5c -tag pix -text "120(V)" -fill white
.plan create oval 2.7c 2.7c 2.9c 2.9c -fill yellow -tag pix


.plan create rectangle 1.03c 1.03c 1.8c 8.97c -fill #555 -tag pix
.plan create rectangle 1.03c 1.03c 8.97c 1.8c -fill #555 -tag pix
.plan create rectangle 8.97c 8.97c 8.2c 1.03c  -fill #555 -tag pix
.plan create rectangle 8.97c 8.97c 1.03c 8.2c  -fill #555 -tag pix
.plan create line 1.8c 1c 1.8c 9c -fill red -tag pix
.plan create line 1c 1.8c 9c 1.8c -fill red -tag pix
.plan create line 8.2c 1c 8.2c 9c -fill #09f -tag pix
.plan create line 1c 8.2c 9c 8.2c -fill #09f -tag pix
.plan create oval 7.3c 7.3c 7.1c 7.1c -fill green -tag pix
.plan create text 7.8c 7.6c -fill white -tag pix -text "0(p)"
.plan create line 1c 2.8c 9c 2.8c -fill yellow -tag pix
.plan create line 2.8c 1c 2.8c 9c -fill yellow -tag pix
.plan create line 1c 7.2c 9c 7.2c -fill green -tag pix
.plan create line 7.2c 1c 7.2c 9c -fill green -tag pix
.plan create line 4c 1c 6c 1c -width .1c -fill red -arrow last -tag pix
.plan create line 4c 9c 6c 9c -width .1c -fill red -arrow last -tag pix
.plan create line 1c 4c 1c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 9c 4c 9c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 1c 4.6c 4.6c 1c -fill orange -tag pix
.plan create line 9c 4.6c 4.6c 9c -fill orange -tag pix
.plan create line 9c 5.4c 5.4c 9c -fill #0c0 -tag pix
.plan create line 1c 5.4c 5.4c 1c -fill #0c0 -tag pix

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.2 9.7 yellow blue element_text "120"
text_box 2.5 9.2 3.4 9.7 yellow blue cone_text "cone"
text_box 3.7 9.2 5.7 9.7 yellow blue dent_text "Dented Torus"
text_box 6.0 9.2 7.5 9.7 yellow blue cliff_text "cliff torus"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"

}




proc dent_pix {} {
.plan create rectangle 1c 1c 9c 9c \
 -fill black -outline white -tag pix
.plan create line 4c 1c 6c 1c -width .1c -fill red -arrow last -tag pix
.plan create line 4c 9c 6c 9c -width .1c -fill red -arrow last -tag pix
.plan create line 1c 4c 1c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 9c 4c 9c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 1.8c 1.8c 8.2c  1.8c -width .14c -fill red  -tag pix
.plan create line 1.8c 1.8c 1.8c 8.2c -fill red -width .14c  -tag pix
.plan create line 1.8c 8.1c 8.1c 1.8c -width .14c -fill red -tag pix
.plan create line 1.8c 8.3c 8.3c 1.8c -width .14c -fill #07f -tag pix
.plan create line 8.2c 8.2c 8.2c 1.8c -width .14c -fill #07f  -tag pix
.plan create line 8.2c 8.2c 1.8c 8.2c -width .14c -fill #07f  -tag pix
.plan create text 6.8c 3.5c -fill white -tag pix  -text "d"
.plan create text 3.2c 2.93c -fill white -tag pix -text "p"
.plan create text 1.5c 5c -tag pix -text "V" -fill white
.plan create text 5c 1.5c -tag pix -text "r(V)" -fill white
.plan create oval 2.7c 2.7c 2.9c 2.9c -fill yellow -tag pix
}

proc prog_text {} {
global FONT
text_clear2
.hopf addtag prog_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "VISUAL VERIFICATION

Let S be the dented torus.  By construction 0(S)=S.
Let |h| denote the word length of an element in H.
For instance |212|=3.   

You can check the following things
1. If |h|>3 then h(S) and S are disjoint
2. If |h|=3 then h(S) and S are disjoint
3. If |h|=2 then h(S) and S have at most a single
point of intersection.
4. If |h|=1, then h(S) || S  is a circle which
does not separate either surface.

These statements, together with some topological
bookkeeping, prove that G is compressing with
respect to the components of S^3-S."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.6 8.5 2.6 9.0 yellow blue long_text "|h|>3"
text_box 2.9 8.5 3.9 9.0 yellow blue three_text "|h|=3"
text_box 4.2 8.5 5.2 9.0 yellow blue two_text "|h|=2"
text_box 5.5 8.5 6.5 9.0 yellow blue one_text "|h|=1"
text_box 6.8 8.5 9.0 9.0 yellow blue book_text "bookkeeping"
text_box 1.5 9.2 2.6 9.7 yellow blue triangle_text "tri gps"
text_box 2.9 9.2 4.4 9.7 yellow blue compress_text "compress"
text_box 4.7 9.2 7.3 9.7 yellow blue tech_text "technical details"
text_box 7.6 9.2 9.7 9.7 yellow blue dent_text "dented torus"
}

proc book_text {} {
global FONT
text_clear2
.hopf addtag book_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "TOPOLOGICAL BOOKKEEPING

Suppose we have verified steps 1-4.
Elementary topology implies that there are
arbitrarily small perturbations of these
surfaces which are disjoint.  The key point
is that the intersection of h(S) and S
does not disconnect S or h(S).  

Another easy argument in topology says the
following:   If a component of S^3-h(S)
intersects a component of S^3-S, then
these components are nested.  This is obvious
in the disjoint case, and follows by perturbation
in the general case.
"

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 3.6 9.2 4.6 9.7 yellow blue book2_text "more"
}

proc book2_text {} {
global FONT
text_clear2
.hopf addtag book2_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "TOPOLOGICAL BOOKKEEPING, cont.

From the picture in HYP, it is easy to
see that both fixed points of the element
12 lie in the same component of S^3-S.
Call this component U.  Let V=c(U).

It is also clear from the picture in HYP
that h(V) and U intersect nontrivially
for all h in H.  Therefore, we have
either h(V)<U or U<h(V).  The second
option is impossible from the picture in HYP.
Hence h(V)<U for all h in H.

Since 12 is loxodomic, we see that h_n(V)
converges to a point as the word length
of h_n tends to infinity.  This, and 
compactness, shows that H is compressing
with respect to the pair (U,V)."

.plan create oval 1c 1c 5c 5c -fill red -tag pix
.plan creat text 3c 3c -font $FONT -text V -tag pix
.plan create oval 5c 5c 9c 9c -fill blue -tag pix
.plan creat text 6c 6c -font $FONT -text U -tag pix -fill white
.plan create oval 7c 7c 8c 8c -fill red -tag pix
.plan create oval 7.8c 7.8c 8.4c 8.4c -fill red -tag pix
.plan create oval 7.6c 8.3c 7.9c 8.6c -fill red -tag pix
.plan create line 4.5c 7.5c 7.5c 7.5c -fill white -tag pix
.plan create line 4c 8.2c 8c 8.2c -fill white -tag pix
.plan create line 4c 8.5c 7.8c 8.5c -fill white -tag pix
.plan create text 1c 6c -font $FONT \
-text "images of V
under successively
longer words in H
converging to one of
the fixed points of
the element 12"  -tag pix -fill white -anchor nw

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.9 9.7 yellow blue long2_text "picture"
}


proc three_text {} {
global FONT
text_clear2
.hopf addtag three_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "|h|=3

In this case, you can just plot
HYP(h(S)) versus HYP(S), and see that they
are disjoint.  It isn't even close." 
text_box .2 9.2 1.2 9.7 red blue back_text "back"
}

proc one_text {} {
global FONT
text_clear2
.hopf addtag one_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "|h|=1

In this case, you can just plot
HYP(h(S)) versus HYP(S), and see that 
these two sets have a single point of
tangency.  The inverse image of this
point is a chain on the Clifford torus.
Hence h(S) and S intersect in a single 
chain.  

This is enough to conclude that one of the
components of S^3-h(S) is contained in
one of the components of S^3-S.   
"

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.6 9.7 yellow blue chain_text "chain"
text_box 2.9 9.2 4.9 9.7 yellow blue cliff_text "Cliff torus"
}


proc long_text {} {
global FONT
text_clear2
.hopf addtag long_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "|h|>3

The quick way to see this, for each individual element,
it to plot h(S) and S in HYP, and see that they are
disjoint.   This appears to involve an infinite
number of checks, but one can actually reduce this
to to a single check, as follows:

The image of HYP can be identified, canonically,
with the unit disk D in the complex line {z=0}.
The identification is just w --> (0,w).
Elements of H preserve D and hence act as
ordinary hypebolic isometries, when D is equipped
with the standard hyperbolic metric.

The elements 1 and 2 are elliptic elements of
D, and each have fixed points f1 and f2 in D.  
The element 12 is loxodromic, and preserves 
the geodesic u containing f1 and f2."

.plan create oval 0c 0c  10c 10c -fill black -outline white -tag pix
.plan create arc 8.417c 6.95c 12.315c 3.050c -start 111.3 \
-extent 137.4 -style arc -fill red -outline red -tag pix
.plan create oval 8.34c 4.5c 8.54c 4.7c -fill #06f -tag pix
.plan create oval 8.34c 5.5c 8.54c 5.3c -fill #06f -tag pix
.plan create text 9c 4c -text "u" -fill red -tag pix -font $FONT
.plan create text 5c 5c -text D -fill white -tag pix -font $FONT
.plan scale pix 5c 5c .9 .9


text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.5 9.7 yellow blue long2_text "more"
}



proc long2_text {} {
global FONT
text_clear2
.hopf addtag long2_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "|h|>3, continued.

Let v and w be the images of the real line R under
the elements 12 and 21.   Let R be the connected
component of D-u-v-w which contains the
Origin  Let R' be the component of
D-v-w which contains the origin.  Note that R<R'.
You can see by plotting that HYP(CA&CB) < R and 
HYP(S-CA-CB)) <R'.  In particular, HYP(S)<R' 
(which is all we need in this case.)  By
By construction, h(R') and R' are disjoint if
|h|>3.   Therefore,  h(S) and S are disjoint as well.

The green arrows show you how to plot u and w
in the PLAY mode.  (Plotting u and v similar.
To plot u,v and w, first plot u and w then plot
v and w.  For an explanation of how to plot,
and how the green arrows work, push the  
``how to play'' button below."

.plan create oval 0c 0c  10c 10c -fill blue -outline white -tag pix
.plan create oval 8.417c 6.95c 12.315c 3.050c  \
 -fill black -outline red -tag pix
.plan create oval 9c 2.1c 11c 4.1c -fill black -outline yellow -tag pix
.plan create oval 9c 7.9c 11c 5.9c -fill black -outline yellow -tag pix
.plan create text 9c 4c -text "u" -fill red -tag pix -font $FONT
.plan create text 9.3c 2.8c -text "v" -fill red -tag pix -font $FONT
.plan create text 9.3c 7.2c -text "w" -fill red -tag pix -font $FONT
.plan create text .5c 5c -text "R" -fill white -tag pix -font $FONT
.plan create oval 6.8c 4c  8.8c 6c -fill orange  -tag pix
.plan create oval 1c 3c  8c 7c -fill #c00 -outline red -tag pix
.plan create text 3c 5c -text "HYP(CA&CB)" -fill white -tag pix -font $FONT
.plan create text 6c 8c -text "HYP(S-CA-CB)" -fill white -tag pix -font $FONT
.plan create line 7.8c 8c 8c 5.7c -fill white -tag pix

helper  6.5 .36  .5 1.3  "1"
helper  7.2 .36  .5 1.3  "2"
helper  3.3 .36  1 1.3  "3"
helper  .2 .1  1 .9  "4,6"
helper  .05 1.5  .5 2.2  "5"

.plan scale pix 5c 5c .9 .9
text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 3.5 9.7 yellow blue mode_text "how to play"
text_box 3.8 9.2 5.8 9.7 yellow blue dent_text "dented torus"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}



proc hyp_text {} {
global FONT
text_clear2
.hopf addtag hyp_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "HYP PROJECTION

This is the projection (z,w) --> w.
Geometrically, it is projection onto
a hyperbolic plane.  The key property of
HYP is that the group generated by 1 and 2
commutes with HYP."

text_box .2 9.2 1.2 9.7 red blue back_text "back"

}

proc symmetry_text {} {
global FONT
text_clear2
.hopf addtag symmetry_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "SYMMETRY

Let c(z,w)=(w,z).  Let r(z,w)=(conj(w),conj(z)).
Here conj() is complex conjugation.
The elements c and r commute with each other.

1. Both c and r preserve S.  On the piece selector,
c correpsonds to a reflection in the main diagonal, 
and r correpsonds to a reflection in the main 
anti-diagonal

2. Conjugation by cr interchanges 1 and 2, 12 and 21,
121 and 212, etc.   Also cr preserves the componnents
of S^3-S.

3. Conjugation by r interchanges 120 and its inverse 021:
r(120)r=r0(012)0r=0((r0)1(0r))((r0)2(0r))=021." 

text_box .2 9.2 1.2 9.7 red blue back_text "back"
}

proc two_text {} {
global FONT
text_clear2
.hopf addtag two_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "|h|=2

If you plot 120(S) verses S in ELEV, you
will see that they are disjoint.
ELEV is defined on all but one point
of each surface.  Hence, S and 120(S)
intersect in at most one point.
By symmetry, the same statements
hold for 12(S) and 21(S) in place
of 120(S)."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 3.8 9.2 5.4 9.7 yellow blue symmetry_text "symmetry"
}



proc bug_text {} {
global FONT
text_clear2
.hopf addtag prog_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "BUGS

--The scaling feature for the graphical plots tends to
freeze the screen if you repeatedly push it quickly.
This ugly bug shows up on machines slower than a
sparc5.

--If the PLOT feature is in operation and you 
partially cover this program with another window,
it will erase the display.  When PLOT is done, the
display is restored.  This is annoying, but harmless.

--The text is too large on silicon graphics
machines.  Use the font adjuster to make it
smaller.

--If you exit the program unnaturally, it will fail
to remove some auxilliary files, with names like
tcl_to_C1.  You can delete these as you see fit.
This is a harmless bug."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
}



proc tech_text {} {
global FONT
text_clear2
.hopf addtag tech_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "TECHNICAL DETAILS

This program lets you plot the relevant pictures
for 21 evenly and maximally spaced parameer
values in the interval (M,n].  This is a very
dense sampling considering the tiny size of (M,n]. 

This program uses C and Tcl for its computations,
giving it a commputational accuracy better than
0.00001.  For noncircular curves, the program
plots polygonal paths based on the sample points.
This program allows you to plot pictures at
densities for which the polygonal curves visually
look smooth."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.5 9.7 yellow blue value_text "M&N"
}




proc compress_text {} {
global FONT
text_clear2
.hopf addtag compress_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "COMPRESSION

Let  0,1,2 be the generators of the triangle group G,
under the Zig-Zag representation.  Let H be the
subgroup generated by 1 and 2.

We say that G is compressing with respect to a pair
of open subset (U,V) of S^3 if  0(V)=U and if
there is some W<U such that h(V)<W for all h in H.

Here is an argument that this compression property
implies that G is discrete faithful.  Every element
in G has a decomposition of the form
h1 0 h2 0 h3 0 ...  0 hn,  where hj in H. 
By induction on the length of this decomposition,
every element of G, other than the identity and 0,
maps one of U,V into one of W,0(W).  This property
clearly implies discreteness and faithfulness."

.plan create oval 2c 2c 3c 8c -fill red -outline white -tag pix
.plan create oval 7c 2c 8c 8c -fill yellow -outline white -tag pix
.plan create oval 7.1c 3c 7.9c 7c -fill blue -outline white -tag pix
.plan create oval 7.3c 4c 7.7c 6c -fill red -outline white -tag pix
.plan create line 2.5c 2c 7.5c 4c -arrow last -fill white -tag pix
.plan create line 2.5c 8c 7.5c 6c -arrow last -fill white -tag pix
.plan create text 5c 2.7c -fill white -text "H" -tag pix
.plan create text 5c 7.3c -fill white -text "H" -tag pix
.plan create line 7.5c 2c 5c 2c -arrow last -fill white -tag pix
.plan create line 2.5c 2c 7.5c 2c  -fill white  -tag pix
.plan create line 7.5c 8c 5c 8c -arrow last -fill white -tag pix
.plan create line 2.5c 8c 7.5c 8c  -fill white -tag pix
.plan create text 5c 1.7c -fill white -text "0" -tag pix
.plan create text 5c 8.3c -fill white -text "0" -tag pix
.plan create text 2.5c 5c -fill black -text "V" -tag pix
.plan create text 7.5c 2.6c -fill black -text "U" -tag pix
.plan create text 7.5c 3.6c -fill white -text "W" -tag pix

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 3.9 9.7 yellow blue triangle_text "triangle groups"
text_box 4.2 9.2 5.6 9.7 yellow blue discrete_text "discrete"
text_box 5.9 9.2 7.1 9.7 yellow blue faithful_text "faithful"
}


proc cone_text {} {
global FONT
text_clear2
.hopf addtag cone_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "HYBRID CONE

Let (C,p) be a pair, where C is a chain and p is 
a point on C.  Given any point s, in S^3-C, there
is a unique R-circle R(C,p;s) which contains both
p and w, and intersects C-p.  Let CONE(C,p;s) be
the portion of R(C,p;s) which connects p to w,
but avoids C-p.  If S is a subset of S^3-C, then
we define CONE(C,p;S) to be the union of
CONE(C,p;s), taken over all points s in S.
CONE() is a PU(2,1)-natural construction.

There is an alternate description, which makes it
clear that CONE() is well-defined.  Choose a
Heisenberg Stereographic Projection which takes
C to the {0}xR, and p to infinity.  R-circles
which contain p and intersect C-p map to straignt
lines parallel to Cx{0}, which intersect {0}xR. 
Any point in CxR-{0}xR lies on a unique such line."

.plan create oval 2.5c 1c  6c 4.5c -tag pix -fill black -outline yellow
.plan create arc 2.5c 1c  6c 4.5c  -style arc \
-start 0 -extent 180 -fill yellow -width .15c  -tag pix
.plan create arc 1c 3c 4c 8c -style arc -fill cyan \
-start 0 -extent 359.99 -tag pix
.plan create oval 2.3c 2.8c 2.7c 3.2c \
-fill cyan -outline white -tag pix
.plan create oval 5.8c 2.55c 6.2c 2.95c  -fill red -outline white -tag pix
.plan create text 6.3c 3.2c  -fill white -tag pix -text "s"
.plan create text 2.3c 3.4c  -fill white -tag pix -text "p"
.plan create text 4.3c 6.4c  -fill white -tag pix -text "C"
.plan create text 5c 4.7c  -anchor w -text "R(C,p;s)" \
-fill white -tag pix
.plan move pix 1c .3c

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.7 9.7 yellow blue chain_text "chains"
text_box 3.0 9.2 4.7 9.7 yellow blue Rcircle_text "R-circles"
text_box 5.0 9.2 6.3 9.7 yellow blue group_text "PU(2,1)"
text_box 6.6 9.2 7.4 9.7 yellow blue hsp_text "HSP"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}



proc hsp_text {} {
global FONT
text_clear2
.hopf addtag hsp_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "HEISENBERG STEREOGRAPHIC PROJECTION

The Siegel Domain is the subset Z={Re(z)>|w|^2},
in C^2.  A Siegel projection is a biholomorphic
map from the open unit ball in C^2 to Z.  Such a
map is a complex projective transformation, and
extends to a map A:  S^3-p --> dZ={Re(z)=|w|^2}.
Here p is some point in S^3.

There is a canonical map B: dZ --> CxR, given
by B(z,w)=(w,Im(z).  The composition 
BA: S^3-p --> CxR is called a Heisenberg
Stereographic Projection (HSP).

The image of a chain under an HSP is an ellipse,
whose image in PLAN is a round circle. The image
of an R-circle under an HSP is a curve whose
image in PLAN is a either a straight line or a
Lemniscate (a figure-8)."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.7 9.7 yellow blue chain_text "chains"
text_box 3.0 9.2 4.7 9.7 yellow blue Rcircle_text "R-circles"
text_box 5.0 9.2 6.0 9.7 yellow blue plan_text "PLAN"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}


proc elev_text {} {
global FONT
text_clear2
.hopf addtag elev_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "ELEV PROJECTION

Given a pair (C,p), where C is a chain in S^3 and
p is a point on C, let H(C,p) be a Heisenberg
stereographic projection which maps S^3-p to
CxR.   If E is the map E(z,t)=(arg z,t), then
ELEV=EH(C,p). 

ELEV depends on (C,p). In the actual program,
C is the chain preserved by the element 120
and p is one of the intersection points of C
and the Clifford torus.

ELEV is a projection of S^3-p onto Q=(R/2 Pi Z)xR.  The
choice of H(C,p) is unique up to post-composition
with maps of the form (z,t) --> (q*z,|q|^2*z).
ELEV is well defined up to affine maps of the flat
cylinder Q.  ELEV is well adapted the hybrid
cone:  ELEV(CONE(C,p;S))=ELEV(S). "

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.5 9.7 yellow blue cone_text "cone"
text_box 2.8 9.2 3.7 9.7 yellow blue hsp_text "HSP"
text_box 4.0 9.2 4.8 9.7 yellow blue element_text "120"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}


proc plan_text {} {
global FONT
text_clear2
.hopf addtag plan_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "PLAN PROJECTION

Given a pair (C,p), where C is a chain in S^3 and
p is a point on C, let H(C,p) be a Heisenberg
stereographic projection which maps S^3-p to
CxR.   If P is the map P(z,t)=z, then
PLAN=PH(C,p). 

PLAN depends on (C,p). In the actual program,
C is the chain preserved by the element 120
and p is one of the intersection points of C
and the Clifford torus.

PLAN is a projection of S^3-p onto C.  The
choice of H(C,p) is unique up to post-composition
with maps of the form (z,t) --> (q*z,|q|^2*z).
PLAN is well defined up to complex multiplication.
PLAN maps chains (resp. R-circles) in S^3-p to  
circles or points (resp. Lemniscates or lines)."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.7 9.7 yellow blue chain_text "chains"
text_box 3.0 9.2 4.7 9.7 yellow blue Rcircle_text "R-circles"
text_box 5.0 9.2 5.9 9.7 yellow blue cone_text "cone"
text_box 6.2 9.2 7.0 9.7 yellow blue hsp_text "HSP"
text_box 7.3 9.2 8.1 9.7 yellow blue element_text "120"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}



proc hopf_text {} {
global FONT
text_clear2
.hopf addtag hopf_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "HYP PROJECTION

HYP(z,w)=w.  Geometrically, HYP projects S^3 
onto the unit disk in C.  HYP maps the Clifford
to the circle of radius  sqrt(1/2).  In general,
HYP chains to circles or lines in C.

Let H be the subgroup generated by elements 1 and 2.
HYP intertwines the action of H with a certain
subgroup of the mobius group, acting on the
unit disk in C.   Thus, for any h in H, and
any set S, the sets HYP(S) and HYP(h(S))
differ by the action of a mobius transformation."

text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.7 9.7 yellow blue chain_text "chains"
text_box 3.0 9.2 4.6 9.7 yellow blue cliff_text "Cliff torus"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}


proc element_text {} {
global FONT
text_clear2
.hopf addtag element_text withtag text1
.hopf create text .5c .5c -tag text -fill white -anchor nw \
-font $FONT \
-text "THE ELEMENT 120

Let g_t be the element 120, in the zig-zag representation
of the triangle group G(t).  For t<N, g_t is a loxodromic
element of PU(2,1), and g(N) is parabolic.  For t in (M,N],
g_t preserves a chain C_t which intersects the Clifford
torus in two points, p_t and q_t.  We call p_t
the important intersection.  p_N is the fixed point 
of g_N, and lies on W_N. q_N) lies on the line labelled
2 in the figure on the right.  For other parameter values,
everything is topologically as shown.

The vertical blue strip at in the figure to the right
shows the portion of the Clifford torus which is
mapped to the region {|z|>|w|}.  Surprisingly,
the restriction of g_t to the boundary U_t,W_t 
of this strip is an isometry in the natural flat metric
on X.  The red chain V is the one used 
in the construction of the dented torus."


.plan create rectangle 1c 1c 9c 9c \
 -fill black -outline white -tag pix
.plan create rectangle 1c 2.0c 9c  2.5c -outline #08f -fill black  -tag pix
.plan create rectangle 2.0c 1c 2.5c 9c -outline #08f -fill #08f  -tag pix
.plan create line 1.8c 1c 1.8c 9c -fill red  -tag pix
.plan create text 1.8c 7c  -fill white -text "V" -tag pix
.plan create line 4c 1c 6c 1c -width .1c -fill red -arrow last -tag pix
.plan create line 4c 9c 6c 9c -width .1c -fill red -arrow last -tag pix
.plan create line 1c 4c 1c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 9c 4c 9c 6c -width .1c -fill green -arrow last -tag pix
.plan create line 1c 1.5c 9c 1.5c -fill cyan -tag pix
.plan create line 1.5c 1c 1.5c 9c -fill cyan -tag pix
.plan create line 8.5c 1c 8.5c 9c -fill cyan -tag pix
.plan create line 1c 8.5c 9c 8.5c -fill cyan -tag pix
.plan create line 1c 1c 9c 9c -fill yellow -tag pix
.plan create text 5c 1.3c  -fill cyan -text "1" -tag pix
.plan create text 5c 8.7c  -fill cyan -text "2" -tag pix
.plan create oval 2.7c 2.7c 2.9c 2.9c -fill yellow -tag pix
.plan create text 3.3c 2.8c -fill white -tag pix -text "p"
.plan create oval 8.65c 8.65c 8.85c 8.85c -fill yellow -tag pix
.plan create line 6.5c 8.75c 8.55c 8.75c -fill white \
-arrow last -tag pix
.plan create text 6.3c 8.75c -fill white -tag pix -text "q"
.plan create text 2.0c 5c -tag pix -text "U" -fill white
.plan create text 2.5c 5c -tag pix -text "W" -fill white
.plan create text 5c 2.0c -tag pix -text "g(U)" -fill white
.plan create text 5c 2.5c -tag pix -text "g(W)" -fill white


text_box .2 9.2 1.2 9.7 red blue back_text "back"
text_box 1.5 9.2 2.5 9.7 yellow blue chain_text "chains"
text_box 2.8 9.2 4.1 9.7 yellow blue group_text "PU(2,1)"
text_box 4.4 9.2 5.8 9.7 yellow blue cliff_text "cliff torus"
text_box 6.1 9.2 7.1 9.7 yellow blue value_text "M&N"
text_box 7.5 9.2 8.7 9.7 yellow blue tri3_text "tri gps"
text_box 9.0 9.2 9.8 9.7 green blue notation_text "not"
}


########################
#####CONTROL PANEL######
########################


proc decompose_text {} {
global FONT
text_clear
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "MINUS BUTTON: This button erases the last
digit of the group element you have created."
}

proc compose_text {type} {
global FONT
text_clear 
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "GROUP COMPISITION: Clicking on the numbered
buttons, in sequence, creates an element in the 
triangle group.    For example, the element 120 is
created by pressing  0, then 2, then 1.    The 
identity element is listed as e."

if {$type == 0} {
.elev create text .5c 3.5c -fill white -tag control -anchor nw \
-font $FONT \
-text "The formula for 0 is:
0(z,w)=(w,z).

This element is listed as t0() in the program
surface.c."}

if {$type == 1} {
.elev create text .5c 3.5c -fill white -tag control -anchor nw \
-font $FONT \
-text "The formula for 1 is:
1(z,w) =  (-z/(A w -3) , (B + 3 w)/(A w - 3))
A=sqrt(8) i exp(-i t) 
B=sqrt(8) i exp(+i t)
Here t is the parameter of the triangle group, and
ranges from arctan(sqrt 35) to arctan(sqrt(125/3)).

This element is called t1() in the program surface.c."}

if {$type == 2} {
.elev create text .5c 3.5c -fill white -tag control -anchor nw \
-font $FONT \
-text "The formula for 2 is:
2(z,w)=v(1(v(z,w))
v(z,w)=(conjugate(z),conjugate(w))

This element is called t2() in the program surface.c."}
}

##########################
##############CORNER CONTROL MODULES###############
##########################
proc update_text {} {
global COORD FONT
text_clear
if {$COORD == 1} {
set loc "top right"
set coo PLAN}
if {$COORD == 2} { 
set loc "top left"
set coo HYP}
if {$COORD == 3} {
set loc "bottom right"
set coo ELEV}
.elev create text .5c .5c -tag control -fill white -anchor nw  \
-font $FONT \
-text "PLOT BUTTON:  This button applies the element
you have selected to the pieces you have selected
on the PIECE SELECTOR, and plots the result in 
the $coo projection.  The picture appears in the
$loc window.

If you click on the $loc window, the picture 
scales up (left button) or down (right button), by
a factor of sqrt(2), about the point on which you
have clicked.

Once you push the PLOT button, a ``blocker''
will cover the control panel until the
plot has been completed.  At this point,
any motion of the mouse removes the blocker."
}

proc clear_text {} { 
global COORD FONT
text_clear
if {$COORD == 1} {set loc "top right"}
if {$COORD == 2} {set loc "top left"}
if {$COORD == 3} {set loc "bottom right"}
.elev create text .5c .5c -fill white -tag control -anchor nw \
-font $FONT \
-text "CLEAR BUTTON:  This button erases everything
which has been drawn in the $loc screen.  It
also erases all text in the little blue window,
thereby resetting the memory.

This CLEAR button has no effect on the other two
screens, or their memories"
}

proc switch_text {} {
global FONT COORD
update_text
text_clear
if {$COORD == 1} {set loc "top right"
set coo PLAN}
if {$COORD == 2} {set loc "top left"
set coo HYP}
if {$COORD == 3} {set loc "bottom left"
set coo ELEV}
.elev create text .5c .5c -tag control -anchor nw -fill white \
-font $FONT \
-text "$coo SELECTOR:  Clicking on the
$coo button enables you to plot pieces in the
$coo projection.  

(See the `dictionary' for the definition of $coo.)"
}


proc up_text {} {
global FONT COORD
text_clear
.elev create text .5c .5c -tag control -anchor nw -fill white \
-font $FONT \
-text "TEXT SCROLLING:  This button lets you scroll 
text in the blue window.  

The text in the blue window serves as the memory
system for the program.  When you click on such
text, the PIECE selector automatically returns to
the state it was in when you last plotted pieces
in the relevant coordinate system, with respect
to the group element represented by the text.
"
}

proc down_text {} {
global FONT COORD
text_clear
.elev create text .5c .5c -tag control -anchor nw -fill white \
-font $FONT \
-text "TEXT SCROLLING:  This button returns the text in
the blue window to its original position.

The text in the blue window serves as the memory
system for the program.  When you click on such
text, the PIECE selector automatically returns to
the state it was in when you last plotted pieces
in the relevant coordinate system, with respect
to the group element represented by the text.
"
}

##########################
##############PARAMETER###############
##########################
proc parameter_text {i} {
global COORD FONT
text_clear
set s1 [expr 0.05*$i]
set s2 [expr 1 - 0.05*$i]
.elev create text .5c .5c -tag control -fill white -anchor nw  \
-font $FONT \
-text "PARAMETERS:  The triangle groups depend on
a parameter, the angular invariant

The cutoff parameter found by G-P is
M = arctan(sqrt(35)) and

The critical parameter is
N= ArcTan(sqrt(125/3))

This button sets the angular invariant at 
$s1 M + $s2 N"
}


proc render_text {} {
global FONT
text_clear
.elev create text .5c .5c -fill white -tag control -anchor nw \
-font $FONT \
-text "RENDERING OPTIONS: These buttons control
the density of the plot in the various graphical
displays.   Roughly speaking, the left-most button
chooses a sparsely plotted image and the right-most
button chooses a densely plotted image.

It is a good policy to start by placing both these
buttons at the extreme left.  This avoids irritating
time delays, and also gives a lower bound to detail.
If you want a more detailed plot, you can edge
the buttons right-ward.   The program initially
sets the buttons to the left.

The two sets of rendering buttons--5 each--have
different effects on the plots.  In fact, sometimes
the choice of button has no effect at all.
We will not describe the effects here, but rather
will leave it to the viewer to discover."
}

proc memory_text {} {
global FONT
text_clear
.elev create text .5c .5c -fill white -tag control -anchor nw \
-font $FONT \
-text "MEMORY: The text in the blue window is the
memory the program.  When you click on such
text, the PIECE SELECTOR automatically returns to
the state it was in when you last plotted pieces
in the relevant coordinate system, with respect
to the group element represented by the text.

The PLOT button places text in the blue windows
and the CLEAR button removes it."
}

proc post_text {s} {
global FONT
if {$s=="torus"} {set wind  "lower left"}
if {$s=="elev"} {set wind  "lower right"}
if {$s=="hopf"} {set wind  "upper left"}
if {$s=="plan"} {set wind  "upper right"}
text_clear
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "POSTSCRIPT:  This button causes the
current picture in the $wind window to be 
stored as PostScript, in the file temp.ps.  

To see what you have saved as PostScript,
you can use a PostScript viewer.  For example,
try typing ghostview temp.ps

If you want to save temp.ps in such a way
that the next call for PostScript does not
overwrite the file, you need to rename the
file yourself."
}


proc label_text {} {
global FONT
text_clear
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "POSTSCRIPT LABELS:  Pressing left on this
button changes the labelling option on the
PostScript pictures.  

Pressing the middle or right buttons changes the
size of the labelling."
}


proc pssize_text {} {
global FONT
text_clear
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "BACKGROUND:  Pressing middle on this
button changes the background color of the piece
selector.   Double clicking on thr middle of
this button changes both the color of the pieces
and the color of their borders.  

Changing the color of the piece selector
also effects the color of the labels for
PostScript output.

Pressing left or right on this button changes the
size of the image which is saved as PostScript.
When using, say, ghostview, the ghostview window
is exactly the size of the picture which gets
printed."
}


proc color_text {} {
global FONT
text_clear
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "COLOR SELECTION:  This is one of the buttons
which selects the color in which the pieces are
plotted."
}


proc many_text {s} {
global FONT
text_clear
if {$s==0} {set  gp "one at a time."}
if {$s==1} {set  gp "several at a time."}
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "PIECE GROUPING:  This button causes the
piece selector select pieces $gp"
}

##############################
##########PIECE SELECTOR TEXT####################
##############################
proc flash_text {} {.torus delete xtra}

proc on_text {piece color} {
global FONT
piece_text $piece $color
.elev delete control
.elev create text .5c .5c -fill white -anchor nw -tag control \
-font $FONT \
-text "PIECE SELECTOR:  Clicking the left button
on a piece selects it for plotting.  Clicking 
on the right button deselects it.  Clicking
(as often as you like) on the left or middle
button changes the plotting color.  

Suppose that the image of the selected piece, 
under a certain group element, has already been
plotted, in a certain coordinate system.
If both the group element and the coordinate
system are currently selected, then clicking
on the piece will effect the actual plot.
You can change the color of the plot, and you
can also delete the piece from the plot.
(You can also ``resurrect'' the piece, in the
plot, by again selecting it.)"}

proc piece_text {s whit} {}


#.torus create oval 1.8c 1.8c 2.2c 2.2c -fill red -tag xtra
#.torus create oval 7.8c 7.8c 8.2c 8.2c -fill green -tag xtra
#.torus create line 2c .5c 2c 9.5c -fill red -tag xtra 
#.torus create line .5c 2c 9.5c 2c -fill red -tag xtra 
#.torus create line .5c 3.5c 3.5c .5c -fill red -tag xtra 
#.torus create line 4.5c 9.5c 9.5c 4.5c -fill red -tag xtra
#.torus create line 5.5c .5c .5c 5.5c -fill green -tag xtra 
#.torus create line 8c .5c 8c 9.5c -fill green -tag xtra
#.torus create line .5c 8c 9.5c 8c -fill green -tag xtra
#.torus create line 9.5c 6.5c 6.5c 9.5c -fill green -tag xtra
#.torus scale xtra 0 0 .8 .8
#.torus move xtra 0c 2c

proc off_text {} {.torus delete xtra}


############################################################
############################################################
############################################################

